/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupCompatManager;
import razerdp.basepopup.PopupReflectionHelper;
import razerdp.basepopup.WindowManagerProxy;
import razerdp.util.PopupUtils;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

abstract class BasePopupWindowProxy
extends PopupWindow {
    private static final String TAG = "BasePopupWindowProxy";
    private static final int MAX_SCAN_ACTIVITY_COUNT = 50;
    private BasePopupHelper mHelper;
    private WindowManagerProxy mWindowManagerProxy;
    private boolean oldFocusable = true;
    private boolean isHandledFullScreen;

    public BasePopupWindowProxy(Context context, BasePopupHelper helper) {
        super(context);
        this.mHelper = helper;
        this.init(context);
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, BasePopupHelper helper) {
        super(context, attrs);
        this.mHelper = helper;
        this.init(context);
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, BasePopupHelper helper) {
        super(context, attrs, defStyleAttr);
        this.mHelper = helper;
        this.init(context);
    }

    public BasePopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, BasePopupHelper helper) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mHelper = helper;
        this.init(context);
    }

    public BasePopupWindowProxy(View contentView, BasePopupHelper helper) {
        super(contentView);
        this.mHelper = helper;
        this.init(contentView.getContext());
    }

    public BasePopupWindowProxy(View contentView, int width, int height, BasePopupHelper helper) {
        super(contentView, width, height);
        this.mHelper = helper;
        this.init(contentView.getContext());
    }

    public BasePopupWindowProxy(View contentView, int width, int height, boolean focusable, BasePopupHelper helper) {
        super(contentView, width, height, focusable);
        this.mHelper = helper;
        this.init(contentView.getContext());
    }

    void bindPopupHelper(BasePopupHelper mHelper) {
        if (this.mWindowManagerProxy == null) {
            this.tryToProxyWindowManagerMethod(this);
        }
        this.mWindowManagerProxy.bindPopupHelper(mHelper);
    }

    private void init(Context context) {
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.tryToProxyWindowManagerMethod(this);
    }

    public void setContentView(View contentView) {
        super.setContentView(contentView);
        this.tryToProxyWindowManagerMethod(this);
    }

    void callSuperShowAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        Activity activity = this.scanForActivity(anchor.getContext());
        if (activity == null) {
            Log.e((String)TAG, (String)"please make sure that context is instance of activity");
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            super.showAsDropDown(anchor, xoff, yoff, gravity);
        } else {
            super.showAsDropDown(anchor, xoff, yoff);
        }
    }

    void callSuperShowAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
    }

    boolean callSuperIsShowing() {
        return super.isShowing();
    }

    Activity scanForActivity(Context from) {
        return PopupUtils.scanForActivity(from, 50);
    }

    public void dismiss() {
        if (this.mHelper == null) {
            return;
        }
        boolean performDismiss = this.mHelper.onBeforeDismiss();
        if (!performDismiss) {
            return;
        }
        boolean dismissAtOnce = this.mHelper.callDismissAtOnce();
        if (dismissAtOnce) {
            this.callSuperDismiss();
        }
    }

    void callSuperDismiss() {
        try {
            super.dismiss();
            this.clear();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"dismiss error");
            e.printStackTrace();
            this.clear();
        }
    }

    void clear() {
        if (this.mWindowManagerProxy != null) {
            this.mWindowManagerProxy.clear();
        }
        PopupUtils.clearViewFromParent(this.getContentView());
        PopupCompatManager.clear(this);
    }

    private void tryToProxyWindowManagerMethod(PopupWindow popupWindow) {
        if (this.mHelper == null || this.mWindowManagerProxy != null) {
            return;
        }
        PopupLogUtil.trace("cur api >> " + Build.VERSION.SDK_INT);
        this.troToProxyWindowManagerMethodBeforeP(popupWindow);
    }

    private void troToProxyWindowManagerMethodOverP(PopupWindow popupWindow) {
        try {
            WindowManager windowManager = PopupReflectionHelper.getInstance().getPopupWindowManager(popupWindow);
            if (windowManager == null) {
                return;
            }
            this.mWindowManagerProxy = new WindowManagerProxy(windowManager);
            PopupReflectionHelper.getInstance().setPopupWindowManager(popupWindow, this.mWindowManagerProxy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void troToProxyWindowManagerMethodBeforeP(PopupWindow popupWindow) {
        try {
            Field fieldWindowManager = PopupWindow.class.getDeclaredField("mWindowManager");
            fieldWindowManager.setAccessible(true);
            WindowManager windowManager = (WindowManager)fieldWindowManager.get(popupWindow);
            if (windowManager == null) {
                return;
            }
            this.mWindowManagerProxy = new WindowManagerProxy(windowManager);
            fieldWindowManager.set(popupWindow, this.mWindowManagerProxy);
            PopupLogUtil.trace(LogTag.i, TAG, "\u5c1d\u8bd5\u4ee3\u7406WindowManager\u6210\u529f");
        }
        catch (NoSuchFieldException e) {
            if (Build.VERSION.SDK_INT >= 27) {
                this.troToProxyWindowManagerMethodOverP(popupWindow);
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        try {
            if (this.mHelper != null) {
                if (this.mHelper.isInterceptTouchEvent()) {
                    if (this.mWindowManagerProxy != null) {
                        this.mWindowManagerProxy.update();
                    }
                } else {
                    super.update(this.mHelper.getAnchorX(), this.mHelper.getAnchorY() + this.mHelper.getAnchorHeight(), this.mHelper.getPopupViewWidth(), this.mHelper.getPopupViewHeight(), true);
                }
            } else {
                super.update();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isHandledFullScreen() {
        return this.isHandledFullScreen;
    }

    void handleFullScreenFocusable() {
        this.oldFocusable = this.isFocusable();
        this.setFocusable(false);
        this.isHandledFullScreen = true;
    }

    void restoreFocusable() {
        if (this.mWindowManagerProxy != null) {
            this.mWindowManagerProxy.updateFocus(this.oldFocusable);
        }
        this.isHandledFullScreen = false;
    }

    WindowManagerProxy getWindowManagerProxy() {
        return this.mWindowManagerProxy;
    }
}

