/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupDecorViewProxy;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

final class WindowManagerProxy
implements WindowManager {
    private static final String TAG = "WindowManagerProxy";
    private WindowManager mWindowManager;
    private WeakReference<PopupDecorViewProxy> mPopupDecorViewProxy;
    private WeakReference<BasePopupHelper> mPopupHelper;
    private static int statusBarHeight;

    public WindowManagerProxy(WindowManager windowManager) {
        this.mWindowManager = windowManager;
    }

    public Display getDefaultDisplay() {
        return this.mWindowManager == null ? null : this.mWindowManager.getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeViewImmediate  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getPopupDecorViewProxy() != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.getPopupDecorViewProxy();
            if (Build.VERSION.SDK_INT >= 19 && !popupDecorViewProxy.isAttachedToWindow()) {
                return;
            }
            this.mWindowManager.removeViewImmediate((View)popupDecorViewProxy);
            this.mPopupDecorViewProxy.clear();
            this.mPopupDecorViewProxy = null;
        } else {
            this.mWindowManager.removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.addView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view)) {
            BasePopupHelper helper = this.getBasePopupHelper();
            this.applyHelper(params, helper);
            PopupDecorViewProxy popupDecorViewProxy = PopupDecorViewProxy.create(view.getContext(), helper);
            popupDecorViewProxy.addPopupDecorView(view, (WindowManager.LayoutParams)params);
            this.mPopupDecorViewProxy = new WeakReference<PopupDecorViewProxy>(popupDecorViewProxy);
            this.mWindowManager.addView((View)popupDecorViewProxy, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.addView(view, params);
        }
    }

    private void applyHelper(ViewGroup.LayoutParams params, BasePopupHelper helper) {
        if (params instanceof WindowManager.LayoutParams && helper != null) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            if (!helper.isInterceptTouchEvent()) {
                PopupLogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u4e0d\u62e6\u622a\u4e8b\u4ef6");
                p.flags |= 0x20;
                p.flags |= 0x40000;
                if (!helper.isClipToScreen()) {
                    p.flags |= 0x200;
                }
            }
            if (helper.isFullScreen()) {
                PopupLogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u5168\u5c4f");
                p.flags |= 0x100;
                if (helper.isInterceptTouchEvent()) {
                    p.flags |= 0x200;
                }
            }
        }
    }

    private ViewGroup.LayoutParams fitLayoutParamsPosition(ViewGroup.LayoutParams params) {
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            BasePopupHelper helper = this.getBasePopupHelper();
            if (helper != null) {
                if (helper.getShowCount() > 1) {
                    p.type = 1002;
                }
                if (helper.isInterceptTouchEvent()) {
                    p.y = 0;
                    p.x = 0;
                } else if (helper.isShowAsDropDown()) {
                    Point offset = helper.getCachedOffset();
                    p.x += offset.x;
                    p.y += offset.y;
                    Log.d((String)TAG, (String)("fitLayoutParamsPosition: x = " + p.x + "  y = " + p.y + "  offsetX = " + offset.x + "  offsetY = " + offset.y));
                    p.height = -2;
                }
            }
            this.applyHelper((ViewGroup.LayoutParams)p, helper);
        }
        return params;
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.updateViewLayout  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getPopupDecorViewProxy() != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.getPopupDecorViewProxy();
            this.mWindowManager.updateViewLayout((View)popupDecorViewProxy, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.updateViewLayout(view, params);
        }
    }

    public void update() {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.getPopupDecorViewProxy() != null) {
            this.getPopupDecorViewProxy().updateLayout();
        }
    }

    public void removeView(View view) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getPopupDecorViewProxy() != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.getPopupDecorViewProxy();
            this.mWindowManager.removeView((View)popupDecorViewProxy);
            this.mPopupDecorViewProxy.clear();
            this.mPopupDecorViewProxy = null;
        } else {
            this.mWindowManager.removeView(view);
        }
    }

    public void clear() {
        try {
            this.removeViewImmediate((View)this.mPopupDecorViewProxy.get());
            this.mPopupDecorViewProxy.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isPopupInnerDecorView(View v) {
        if (v == null) {
            return false;
        }
        String viewSimpleClassName = v.getClass().getSimpleName();
        return TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupDecorView") || TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupViewContainer");
    }

    private PopupDecorViewProxy getPopupDecorViewProxy() {
        if (this.mPopupDecorViewProxy == null) {
            return null;
        }
        return (PopupDecorViewProxy)this.mPopupDecorViewProxy.get();
    }

    private BasePopupHelper getBasePopupHelper() {
        if (this.mPopupHelper == null) {
            return null;
        }
        return (BasePopupHelper)this.mPopupHelper.get();
    }

    void bindPopupHelper(BasePopupHelper helper) {
        this.mPopupHelper = new WeakReference<BasePopupHelper>(helper);
    }

    private void checkStatusBarHeight(Context context) {
        if (statusBarHeight != 0 || context == null) {
            return;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }
}

