/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import razerdp.basepopup.BasePopupHelper;
import razerdp.library.R;
import razerdp.util.PopupUtils;

class PopupBackgroundView
extends View {
    BasePopupHelper mHelper;

    private PopupBackgroundView(Context context) {
        this(context, null);
    }

    private PopupBackgroundView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupBackgroundView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static PopupBackgroundView creaete(Context context, BasePopupHelper helper) {
        PopupBackgroundView view = new PopupBackgroundView(context);
        view.init(context, helper);
        return view;
    }

    private void init(Context context, final BasePopupHelper mHelper) {
        if (PopupUtils.isBackgroundInvalidated(mHelper.getPopupBackground())) {
            this.setVisibility(8);
            return;
        }
        this.mHelper = mHelper;
        this.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(mHelper.getPopupBackground());
        } else {
            this.setBackgroundDrawable(mHelper.getPopupBackground());
        }
        if (mHelper.isPopupFadeEnable()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    Animation fadeIn = AnimationUtils.loadAnimation((Context)PopupBackgroundView.this.getContext(), (int)R.anim.basepopup_fade_in);
                    if (fadeIn != null) {
                        long fadeInTime = mHelper.getShowAnimationDuration() - 200L;
                        fadeIn.setDuration(Math.max(fadeIn.getDuration(), fadeInTime));
                        fadeIn.setFillAfter(true);
                        PopupBackgroundView.this.startAnimation(fadeIn);
                    }
                    PopupBackgroundView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            });
        }
    }

    public void destroy() {
        this.mHelper = null;
    }

    public void handleAnimateDismiss() {
        Animation fadeOut;
        if (this.mHelper != null && this.mHelper.isPopupFadeEnable() && (fadeOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.basepopup_fade_out)) != null) {
            long fadeDismissTime = this.mHelper.getExitAnimationDuration() - 200L;
            fadeOut.setDuration(Math.max(fadeOut.getDuration(), fadeDismissTime));
            fadeOut.setFillAfter(true);
            this.startAnimation(fadeOut);
        }
    }
}

