/*
 * Decompiled with CFR 0.152.
 */
package razerdp.blur;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import java.lang.ref.WeakReference;

public class PopupBlurOption {
    private static final float DEFAULT_BLUR_RADIUS = 6.0f;
    private static final float DEFAULT_PRE_SCALE_RATIO = 0.6f;
    private static final long DEFAULT_ANIMATION_DURATION = 500L;
    private static final boolean DEFAULT_BLUR_ASYNC = true;
    private WeakReference<View> mBlurView;
    private float mBlurRadius = 6.0f;
    private float mBlurPreScaleRatio = 0.6f;
    private long mBlurInDuration = 500L;
    private long mBlurOutDuration = 500L;
    private boolean mBlurAsync = true;
    private boolean mFullScreen = true;

    public View getBlurView() {
        if (this.mBlurView == null) {
            return null;
        }
        return (View)this.mBlurView.get();
    }

    public PopupBlurOption setBlurView(View blurView) {
        this.mBlurView = new WeakReference<View>(blurView);
        boolean isDecorView = false;
        if (blurView != null) {
            ViewParent parent = blurView.getParent();
            if (parent != null) {
                isDecorView = TextUtils.equals((CharSequence)parent.getClass().getName(), (CharSequence)"com.android.internal.policy.DecorView");
            }
            if (!isDecorView) {
                boolean bl = isDecorView = blurView.getId() == 0x1020002;
            }
            if (!isDecorView) {
                isDecorView = TextUtils.equals((CharSequence)blurView.getClass().getName(), (CharSequence)"com.android.internal.policy.DecorView");
            }
        }
        this.setFullScreen(isDecorView);
        return this;
    }

    public float getBlurRadius() {
        return this.mBlurRadius;
    }

    public PopupBlurOption setBlurRadius(float blurRadius) {
        this.mBlurRadius = Math.min(Math.max(0.0f, blurRadius), 25.0f);
        return this;
    }

    public float getBlurPreScaleRatio() {
        return this.mBlurPreScaleRatio;
    }

    public PopupBlurOption setBlurPreScaleRatio(float blurPreScaleRatio) {
        this.mBlurPreScaleRatio = blurPreScaleRatio;
        return this;
    }

    public long getBlurInDuration() {
        return this.mBlurInDuration;
    }

    public PopupBlurOption setBlurInDuration(long blurInDuration) {
        this.mBlurInDuration = blurInDuration;
        return this;
    }

    public long getBlurOutDuration() {
        return this.mBlurOutDuration;
    }

    public PopupBlurOption setBlurOutDuration(long blurOutDuration) {
        this.mBlurOutDuration = blurOutDuration;
        return this;
    }

    public boolean isBlurAsync() {
        return this.mBlurAsync;
    }

    public PopupBlurOption setBlurAsync(boolean blurAsync) {
        this.mBlurAsync = blurAsync;
        return this;
    }

    public boolean isFullScreen() {
        return this.mFullScreen;
    }

    public PopupBlurOption setFullScreen(boolean fullScreen) {
        this.mFullScreen = fullScreen;
        return this;
    }

    public boolean isAllowToBlur() {
        return this.getBlurView() != null;
    }
}

