/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupDecorViewProxy;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

final class WindowManagerProxy
implements WindowManager {
    private static final String TAG = "WindowManagerProxy";
    private WindowManager mWindowManager;
    private WeakReference<PopupDecorViewProxy> mHackPopupDecorView;
    private WeakReference<BasePopupHelper> mPopupHelper;
    private static int statusBarHeight;

    public WindowManagerProxy(WindowManager windowManager) {
        this.mWindowManager = windowManager;
    }

    public Display getDefaultDisplay() {
        return this.mWindowManager == null ? null : this.mWindowManager.getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeViewImmediate  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getPopupDecorViewProxy() != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.getPopupDecorViewProxy();
            if (Build.VERSION.SDK_INT >= 19 && !popupDecorViewProxy.isAttachedToWindow()) {
                return;
            }
            this.mWindowManager.removeViewImmediate((View)popupDecorViewProxy);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.mWindowManager.removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.addView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view)) {
            BasePopupHelper helper = this.getBasePopupHelper();
            this.applyHelper(params, helper);
            PopupDecorViewProxy popupDecorViewProxy = PopupDecorViewProxy.create(view.getContext(), helper);
            popupDecorViewProxy.addPopupDecorView(view, (WindowManager.LayoutParams)params);
            this.mHackPopupDecorView = new WeakReference<PopupDecorViewProxy>(popupDecorViewProxy);
            this.mWindowManager.addView((View)popupDecorViewProxy, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.addView(view, params);
        }
    }

    private void applyHelper(ViewGroup.LayoutParams params, BasePopupHelper helper) {
        if (params instanceof WindowManager.LayoutParams && helper != null) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            if (!helper.isInterceptTouchEvent()) {
                PopupLogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u4e0d\u62e6\u622a\u4e8b\u4ef6");
                p.flags |= 0x20;
                p.flags |= 0x40000;
            }
            if (helper.isFullScreen()) {
                PopupLogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u5168\u5c4f");
                p.flags |= 0x100;
                if (helper.isInterceptTouchEvent()) {
                    p.flags |= 0x200;
                }
                p.softInputMode = 1;
            }
        }
    }

    private ViewGroup.LayoutParams fitLayoutParamsPosition(ViewGroup.LayoutParams params) {
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            BasePopupHelper helper = this.getBasePopupHelper();
            if (helper != null && helper.getShowCount() > 1) {
                p.type = 1002;
            }
            if (helper != null && helper.isInterceptTouchEvent()) {
                p.y = 0;
                p.x = 0;
            }
            this.applyHelper((ViewGroup.LayoutParams)p, helper);
        }
        return params;
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.updateViewLayout  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getPopupDecorViewProxy() != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.getPopupDecorViewProxy();
            this.mWindowManager.updateViewLayout((View)popupDecorViewProxy, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.updateViewLayout(view, params);
        }
    }

    public void removeView(View view) {
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeView  >>>  " + (view == null ? null : view.getClass().getSimpleName()));
        if (this.mWindowManager == null || view == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        if (this.isPopupInnerDecorView(view) && this.getPopupDecorViewProxy() != null) {
            PopupDecorViewProxy popupDecorViewProxy = this.getPopupDecorViewProxy();
            this.mWindowManager.removeView((View)popupDecorViewProxy);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.mWindowManager.removeView(view);
        }
    }

    public void clear() {
        try {
            this.removeViewImmediate((View)this.mHackPopupDecorView.get());
            this.mHackPopupDecorView.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ViewGroup.LayoutParams createBlurBackgroundWindowParams(ViewGroup.LayoutParams params) {
        ViewGroup.LayoutParams result = new ViewGroup.LayoutParams(params);
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams mResults = new WindowManager.LayoutParams();
            mResults.copyFrom((WindowManager.LayoutParams)params);
            mResults.flags |= 8;
            mResults.flags |= 0x10;
            mResults.flags |= 0x100;
            mResults.windowAnimations = 0;
            mResults.type = 1000;
            mResults.x = 0;
            mResults.y = 0;
            mResults.format = 1;
            result = mResults;
        }
        result.width = -1;
        result.height = -1;
        return result;
    }

    private boolean isPopupInnerDecorView(View v) {
        if (v == null) {
            return false;
        }
        String viewSimpleClassName = v.getClass().getSimpleName();
        return TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupDecorView") || TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupViewContainer");
    }

    private PopupDecorViewProxy getPopupDecorViewProxy() {
        if (this.mHackPopupDecorView == null) {
            return null;
        }
        return (PopupDecorViewProxy)this.mHackPopupDecorView.get();
    }

    private BasePopupHelper getBasePopupHelper() {
        if (this.mPopupHelper == null) {
            return null;
        }
        return (BasePopupHelper)this.mPopupHelper.get();
    }

    void bindPopupHelper(BasePopupHelper helper) {
        this.mPopupHelper = new WeakReference<BasePopupHelper>(helper);
    }

    private void checkStatusBarHeight(Context context) {
        if (statusBarHeight != 0 || context == null) {
            return;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }
}

