/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import razerdp.basepopup.BasePopupWindowProxy;
import razerdp.util.log.PopupLogUtil;

final class PopupCompatManager {
    private static final String TAG = "PopupCompatManager";
    private static final PopupWindowImpl IMPL;

    PopupCompatManager() {
    }

    public static void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
        if (IMPL != null) {
            IMPL.showAsDropDown(popupWindow, anchor, xoff, yoff, gravity);
        }
    }

    public static void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
        if (IMPL != null) {
            IMPL.showAtLocation(popupWindow, parent, gravity, x, y);
        }
    }

    static {
        int buildVersion = Build.VERSION.SDK_INT;
        IMPL = buildVersion == 24 ? new Impl24() : (buildVersion > 24 ? new ImplOver24() : new ImplBefore24());
    }

    static class ImplOver24
    extends BaseImpl {
        ImplOver24() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            popupWindow.callSuperShowAsDropDown(anchor, xoff, yoff, gravity);
        }

        @Override
        void showAtLocationImpl(Activity activity, BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
        }
    }

    static class Impl24
    extends BaseImpl {
        Impl24() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            int[] anchorLocation = new int[2];
            anchor.getLocationInWindow(anchorLocation);
            xoff = anchorLocation[0] + xoff;
            yoff = anchorLocation[1] + anchor.getHeight() + yoff;
            popupWindow.callSuperShowAtLocation(activity.getWindow().getDecorView(), 0, xoff, yoff);
        }

        @Override
        void showAtLocationImpl(Activity activity, BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
        }
    }

    static class ImplBefore24
    extends BaseImpl {
        ImplBefore24() {
        }

        @Override
        void showAsDropDownImpl(Activity activity, BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            popupWindow.callSuperShowAsDropDown(anchor, xoff, yoff, gravity);
        }

        @Override
        void showAtLocationImpl(Activity activity, BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            popupWindow.callSuperShowAtLocation(parent, gravity, x, y);
        }
    }

    static abstract class BaseImpl
    implements PopupWindowImpl {
        BaseImpl() {
        }

        abstract void showAsDropDownImpl(Activity var1, BasePopupWindowProxy var2, View var3, int var4, int var5, int var6);

        abstract void showAtLocationImpl(Activity var1, BasePopupWindowProxy var2, View var3, int var4, int var5, int var6);

        @Override
        public void showAsDropDown(BasePopupWindowProxy popupWindow, View anchor, int xoff, int yoff, int gravity) {
            if (this.isPopupShowing(popupWindow)) {
                return;
            }
            Activity activity = popupWindow.scanForActivity(anchor.getContext());
            if (activity == null) {
                Log.e((String)PopupCompatManager.TAG, (String)"please make sure that context is instance of activity");
                return;
            }
            this.onBeforeShowExec(popupWindow, activity);
            this.showAsDropDownImpl(activity, popupWindow, anchor, xoff, yoff, gravity);
            this.onAfterShowExec(popupWindow, activity);
        }

        @Override
        public void showAtLocation(BasePopupWindowProxy popupWindow, View parent, int gravity, int x, int y) {
            if (this.isPopupShowing(popupWindow)) {
                return;
            }
            Activity activity = popupWindow.scanForActivity(parent.getContext());
            if (activity == null) {
                Log.e((String)PopupCompatManager.TAG, (String)"please make sure that context is instance of activity");
                return;
            }
            this.onBeforeShowExec(popupWindow, activity);
            this.showAtLocationImpl(activity, popupWindow, parent, gravity, x, y);
            this.onAfterShowExec(popupWindow, activity);
        }

        protected void onBeforeShowExec(BasePopupWindowProxy popupWindowProxy, Activity act) {
        }

        protected void onAfterShowExec(BasePopupWindowProxy popupWindowProxy, Activity act) {
        }

        boolean isPopupShowing(BasePopupWindowProxy popupWindow) {
            return popupWindow != null && popupWindow.callSuperIsShowing();
        }

        void fitSystemBar(Activity act, View popupContentView) {
            if (act == null) {
                return;
            }
            try {
                WindowManager.LayoutParams lp = act.getWindow().getAttributes();
                int i = lp.flags;
                if ((i & 0x400) != 0) {
                    this.hideSystemUI(act, popupContentView);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void hideSystemUI(Activity act, View popupContentView) {
            if (popupContentView == null) {
                return;
            }
            try {
                int uiOptions;
                int newUiOptions = uiOptions = act.getWindow().getDecorView().getSystemUiVisibility();
                if (Build.VERSION.SDK_INT >= 14) {
                    newUiOptions |= 4;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    newUiOptions |= 2;
                }
                if (Build.VERSION.SDK_INT >= 19) {
                    newUiOptions |= 0x1000;
                }
                act.getWindow().getDecorView().setSystemUiVisibility(newUiOptions);
                PopupLogUtil.trace("hideSystemBar");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void showSystemUI(View view) {
            try {
                if (Build.VERSION.SDK_INT >= 19) {
                    int uiOptions = 1792;
                    view.setSystemUiVisibility(uiOptions);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static interface PopupWindowImpl {
        public void showAsDropDown(BasePopupWindowProxy var1, View var2, int var3, int var4, int var5);

        public void showAtLocation(BasePopupWindowProxy var1, View var2, int var3, int var4, int var5);
    }
}

