/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.HackPopupDecorView;
import razerdp.basepopup.InnerPopupWindowStateListener;
import razerdp.basepopup.PopupTouchController;
import razerdp.blur.BlurImageView;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

final class HackWindowManager
extends InnerPopupWindowStateListener
implements WindowManager {
    private static final String TAG = "HackWindowManager";
    private WindowManager mWindowManager;
    private WeakReference<PopupTouchController> mPopupController;
    private WeakReference<HackPopupDecorView> mHackPopupDecorView;
    private WeakReference<BasePopupHelper> mPopupHelper;
    private WeakReference<BlurImageView> mBlurImageView;
    private static int statusBarHeight;

    public HackWindowManager(WindowManager windowManager, PopupTouchController popupTouchController) {
        this.mWindowManager = windowManager;
        this.mPopupController = new WeakReference<PopupTouchController>(popupTouchController);
    }

    public Display getDefaultDisplay() {
        return this.mWindowManager == null ? null : this.mWindowManager.getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        if (this.mWindowManager == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeViewImmediate  >>>  " + view.getClass().getSimpleName());
        if (this.isPopupInnerDecorView(view) && this.getHackPopupDecorView() != null) {
            if (this.getBlurImageView() != null) {
                try {
                    this.mWindowManager.removeViewImmediate((View)this.getBlurImageView());
                    this.mBlurImageView.clear();
                    this.mBlurImageView = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.mWindowManager.removeViewImmediate((View)hackPopupDecorView);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.mWindowManager.removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        if (this.mWindowManager == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.addView  >>>  " + view.getClass().getSimpleName());
        if (this.isPopupInnerDecorView(view)) {
            BasePopupHelper helper = this.getBasePopupHelper();
            BlurImageView blurImageView = null;
            HackPopupDecorView hackPopupDecorView = new HackPopupDecorView(view.getContext());
            params = hackPopupDecorView.addPopupDecorView(view, params, helper, this.getPopupController());
            this.mHackPopupDecorView = new WeakReference<HackPopupDecorView>(hackPopupDecorView);
            if (helper != null && helper.isAllowToBlur()) {
                blurImageView = new BlurImageView(view.getContext());
                blurImageView.attachBlurOption(helper.getBlurOption());
                this.mBlurImageView = new WeakReference<BlurImageView>(blurImageView);
                if (this.getPopupController() instanceof BasePopupWindow) {
                    ((BasePopupWindow)this.getPopupController()).setOnInnerPopupWIndowStateListener(this);
                }
                hackPopupDecorView.setOnAttachListener(new HackPopupDecorView.OnAttachListener(){

                    @Override
                    public void onAttachtoWindow() {
                        if (HackWindowManager.this.getBlurImageView() != null) {
                            HackWindowManager.this.getBlurImageView().start(-2L);
                        }
                    }
                });
                this.mWindowManager.addView((View)blurImageView, this.createBlurBackgroundWindowParams(params));
            }
            this.mWindowManager.addView((View)hackPopupDecorView, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.addView(view, params);
        }
    }

    private ViewGroup.LayoutParams fitLayoutParamsPosition(ViewGroup.LayoutParams params) {
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
            BasePopupHelper helper = this.getBasePopupHelper();
            if (helper != null && helper.isShowAtDown() && p.y <= helper.getAnchorY()) {
                int y = helper.getAnchorY() + helper.getAnchorHeight() + helper.getInternalOffsetY();
                p.y = y <= 0 ? 0 : y;
            }
        }
        return params;
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (this.mWindowManager == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.updateViewLayout  >>>  " + view.getClass().getSimpleName());
        if (this.isPopupInnerDecorView(view) && this.getHackPopupDecorView() != null) {
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.mWindowManager.updateViewLayout((View)hackPopupDecorView, this.fitLayoutParamsPosition(params));
        } else {
            this.mWindowManager.updateViewLayout(view, params);
        }
    }

    public void removeView(View view) {
        if (this.mWindowManager == null) {
            return;
        }
        this.checkStatusBarHeight(view.getContext());
        PopupLogUtil.trace(LogTag.i, TAG, "WindowManager.removeView  >>>  " + view.getClass().getSimpleName());
        if (this.isPopupInnerDecorView(view) && this.getHackPopupDecorView() != null) {
            if (this.getBlurImageView() != null) {
                try {
                    this.mWindowManager.removeView((View)this.getBlurImageView());
                    this.mBlurImageView.clear();
                    this.mBlurImageView = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.mWindowManager.removeView((View)hackPopupDecorView);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.mWindowManager.removeView(view);
        }
    }

    private ViewGroup.LayoutParams createBlurBackgroundWindowParams(ViewGroup.LayoutParams params) {
        ViewGroup.LayoutParams result = new ViewGroup.LayoutParams(params);
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams mResults = new WindowManager.LayoutParams();
            mResults.copyFrom((WindowManager.LayoutParams)params);
            mResults.flags |= 8;
            mResults.flags |= 0x10;
            mResults.flags |= 0x100;
            mResults.x = 0;
            mResults.y = 0;
            mResults.format = 1;
            result = mResults;
        }
        result.width = -1;
        result.height = -1;
        return result;
    }

    private boolean isPopupInnerDecorView(View v) {
        if (v == null) {
            return false;
        }
        String viewSimpleClassName = v.getClass().getSimpleName();
        return TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupDecorView") || TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupViewContainer");
    }

    private HackPopupDecorView getHackPopupDecorView() {
        if (this.mHackPopupDecorView == null) {
            return null;
        }
        return (HackPopupDecorView)((Object)this.mHackPopupDecorView.get());
    }

    private PopupTouchController getPopupController() {
        if (this.mPopupController == null) {
            return null;
        }
        return (PopupTouchController)this.mPopupController.get();
    }

    private BasePopupHelper getBasePopupHelper() {
        if (this.mPopupHelper == null) {
            return null;
        }
        return (BasePopupHelper)this.mPopupHelper.get();
    }

    private BlurImageView getBlurImageView() {
        if (this.mBlurImageView == null) {
            return null;
        }
        return (BlurImageView)((Object)this.mBlurImageView.get());
    }

    void bindPopupHelper(BasePopupHelper helper) {
        this.mPopupHelper = new WeakReference<BasePopupHelper>(helper);
    }

    private void checkStatusBarHeight(Context context) {
        if (statusBarHeight != 0 || context == null) {
            return;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }

    @Override
    void onAnimateDismissStart() {
        if (this.getBlurImageView() != null) {
            this.getBlurImageView().dismiss(-2L);
        }
    }

    @Override
    void onNoAnimateDismiss() {
        if (this.getBlurImageView() != null) {
            this.getBlurImageView().dismiss(0L);
        }
    }
}

