/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupTouchController;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

public class HackPopupDecorView
extends ViewGroup {
    private static final String TAG = "HackPopupDecorView";
    private PopupTouchController mPopupTouchController;
    private View mPopupDecorView;
    private BasePopupHelper mBasePopupHelper;
    private OnAttachListener mOnAttachListener;

    public HackPopupDecorView(Context context) {
        super(context);
    }

    public HackPopupDecorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HackPopupDecorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int maxWidth = 0;
            int maxHeight = 0;
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            }
            this.setMeasuredDimension(maxWidth, maxHeight);
        }
        PopupLogUtil.trace(LogTag.d, TAG, "onMeasure");
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            child.layout(l, t, r, b);
        }
        PopupLogUtil.trace(LogTag.d, TAG, "onLayout");
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.mPopupTouchController != null && this.mPopupTouchController.onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.mPopupTouchController != null) {
                PopupLogUtil.trace(LogTag.i, TAG, "dispatchKeyEvent: >>> onBackPressed");
                return this.mPopupTouchController.onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mPopupTouchController != null && this.mPopupTouchController.onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
            if (this.mPopupTouchController != null) {
                PopupLogUtil.trace(LogTag.i, TAG, "onTouchEvent:[ACTION_DOWN] >>> onOutSideTouch");
                return this.mPopupTouchController.onOutSideTouch();
            }
        } else if (event.getAction() == 4 && this.mPopupTouchController != null) {
            PopupLogUtil.trace(LogTag.i, TAG, "onTouchEvent:[ACTION_OUTSIDE] >>> onOutSideTouch");
            return this.mPopupTouchController.onOutSideTouch();
        }
        return super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mOnAttachListener != null) {
            this.mOnAttachListener.onAttachtoWindow();
        }
    }

    ViewGroup.LayoutParams addPopupDecorView(View view, ViewGroup.LayoutParams sourcePopupDecorViewParams, BasePopupHelper helper, PopupTouchController controller) {
        ViewGroup.LayoutParams decorViewLayoutParams;
        this.mPopupDecorView = view;
        this.mPopupTouchController = controller;
        this.mBasePopupHelper = helper;
        if ((sourcePopupDecorViewParams = this.applyHelper(sourcePopupDecorViewParams, helper)) instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams wp = new WindowManager.LayoutParams();
            wp.copyFrom((WindowManager.LayoutParams)sourcePopupDecorViewParams);
            decorViewLayoutParams = wp;
        } else {
            decorViewLayoutParams = new ViewGroup.LayoutParams(sourcePopupDecorViewParams);
        }
        if (helper != null) {
            decorViewLayoutParams.width = helper.getPopupViewWidth();
            decorViewLayoutParams.height = helper.getPopupViewHeight();
        }
        this.addView(view, decorViewLayoutParams);
        return sourcePopupDecorViewParams;
    }

    private ViewGroup.LayoutParams applyHelper(ViewGroup.LayoutParams params, BasePopupHelper helper) {
        if (!(params instanceof WindowManager.LayoutParams) || helper == null) {
            return params;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
        if (!helper.isInterceptTouchEvent()) {
            PopupLogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u4e0d\u62e6\u622a\u4e8b\u4ef6");
            p.flags |= 0x20;
            p.flags |= 0x40000;
        }
        if (helper.isFullScreen()) {
            PopupLogUtil.trace(LogTag.i, TAG, "applyHelper  >>>  \u5168\u5c4f");
            p.flags |= 0x100;
            p.softInputMode = 1;
        }
        PopupLogUtil.trace(LogTag.i, TAG, "PopupWindow\u7a97\u53e3\u7684window type >>  " + p.type);
        return p;
    }

    public OnAttachListener getOnAttachListener() {
        return this.mOnAttachListener;
    }

    public void setOnAttachListener(OnAttachListener onAttachListener) {
        this.mOnAttachListener = onAttachListener;
    }

    static interface OnAttachListener {
        public void onAttachtoWindow();
    }
}

