/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.PopupController;
import razerdp.blur.BlurImageView;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

public class HackPopupDecorView
extends ViewGroup {
    private static final String TAG = "HackPopupDecorView";
    private PopupController mPopupController;
    private WeakReference<BlurImageView> mBlurImageViewWeakReference;

    public HackPopupDecorView(Context context) {
        super(context);
    }

    public HackPopupDecorView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public HackPopupDecorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int maxWidth = 0;
            int maxHeight = 0;
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                maxWidth = Math.max(maxWidth, child.getMeasuredWidth());
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            }
            this.setMeasuredDimension(maxWidth, maxHeight);
        }
        PopupLogUtil.trace(LogTag.d, TAG, "onMeasure");
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return;
        }
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            child.layout(l, t, r, b);
        }
        PopupLogUtil.trace(LogTag.d, TAG, "onLayout");
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean intercept;
        boolean bl = intercept = this.getPopupController() != null && this.getPopupController().onDispatchKeyEvent(event);
        if (intercept) {
            return true;
        }
        if (event.getKeyCode() == 4) {
            KeyEvent.DispatcherState state;
            if (this.getKeyDispatcherState() == null) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                if (state2 != null) {
                    state2.startTracking(event, (Object)this);
                }
                return true;
            }
            if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled() && this.getPopupController() != null) {
                PopupLogUtil.trace(LogTag.i, TAG, "dispatchKeyEvent: >>> onBackPressed");
                return this.getPopupController().onBackPressed();
            }
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.getPopupController() != null && this.getPopupController().onTouchEvent(event)) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
            if (this.getPopupController() != null) {
                PopupLogUtil.trace(LogTag.i, TAG, "onTouchEvent:[ACTION_DOWN] >>> onOutSideTouch");
                return this.getPopupController().onOutSideTouch();
            }
        } else if (event.getAction() == 4 && this.getPopupController() != null) {
            PopupLogUtil.trace(LogTag.i, TAG, "onTouchEvent:[ACTION_OUTSIDE] >>> onOutSideTouch");
            return this.getPopupController().onOutSideTouch();
        }
        return super.onTouchEvent(event);
    }

    public PopupController getPopupController() {
        return this.mPopupController;
    }

    public void setPopupController(PopupController popupController) {
        this.mPopupController = popupController;
        if (this.mPopupController instanceof BasePopupWindow) {
            ((BasePopupWindow)this.mPopupController).setOnInnerPopupWIndowStateListener(new InnerPopupWindowStateListener());
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startBlurAnima();
    }

    public void addBlurImageview(BlurImageView blurImageView) {
        if (blurImageView == null) {
            return;
        }
        this.mBlurImageViewWeakReference = new WeakReference<BlurImageView>(blurImageView);
    }

    public void startBlurAnima() {
        this.startBlurAnima(-2L);
    }

    public void startBlurAnima(long duration) {
        if (this.getBlurImageView() == null) {
            return;
        }
        this.getBlurImageView().start(duration);
    }

    public void dismissBlurAnima() {
        this.dismissBlurAnima(-2L);
    }

    public void dismissBlurAnima(long duration) {
        if (this.getBlurImageView() == null) {
            return;
        }
        this.getBlurImageView().dismiss(duration);
    }

    BlurImageView getBlurImageView() {
        if (this.mBlurImageViewWeakReference == null) {
            return null;
        }
        return (BlurImageView)((Object)this.mBlurImageViewWeakReference.get());
    }

    class InnerPopupWindowStateListener
    extends razerdp.basepopup.InnerPopupWindowStateListener {
        InnerPopupWindowStateListener() {
        }

        @Override
        void onAnimaDismissStart() {
            HackPopupDecorView.this.dismissBlurAnima();
        }

        @Override
        void onWithAnimaDismiss() {
            HackPopupDecorView.this.dismissBlurAnima(0L);
        }
    }
}

