/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;

public class SimpleAnimationUtils {
    public static Animation getTranslateAnimation(int start, int end, int durationMillis) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)start, (float)end);
        translateAnimation.setDuration((long)durationMillis);
        return translateAnimation;
    }

    public static Animation getDefaultScaleAnimation(boolean in) {
        return SimpleAnimationUtils.getScaleAnimation(in ? 0.0f : 1.0f, in ? 1.0f : 0.0f, in ? 0.0f : 1.0f, in ? 1.0f : 0.0f, 1, 0.5f, 1, 0.5f);
    }

    public static Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        ScaleAnimation scaleAnimation = new ScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
        scaleAnimation.setDuration(360L);
        return scaleAnimation;
    }

    public static Animation getDefaultAlphaAnimation(boolean in) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(in ? 0.0f : 1.0f, in ? 1.0f : 0.0f);
        alphaAnimation.setDuration(360L);
        alphaAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        return alphaAnimation;
    }

    public static AnimatorSet getDefaultSlideFromBottomAnimationSet(View mAnimaView) {
        AnimatorSet set = null;
        set = new AnimatorSet();
        if (mAnimaView != null) {
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)mAnimaView, (String)"translationY", (float[])new float[]{250.0f, 0.0f}).setDuration(400L), ObjectAnimator.ofFloat((Object)mAnimaView, (String)"alpha", (float[])new float[]{0.4f, 1.0f}).setDuration(375L)});
        }
        return set;
    }

    public static abstract class AnimationListenerAdapter
    implements Animation.AnimationListener {
        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }
}

