/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.view.View;
import android.view.animation.Animation;
import android.widget.PopupWindow;
import razerdp.basepopup.BasePopupWindow;
import razerdp.library.R;

final class BasePopupHelper {
    private boolean autoShowInputMethod = false;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mExitAnimation;
    private Animator mExitAnimator;
    private BasePopupWindow.OnDismissListener mOnDismissListener;
    private BasePopupWindow.OnBeforeShowCallback mOnBeforeShowCallback;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int popupViewWidth;
    private int popupViewHeight;
    private int[] mAnchorViewLocation = new int[2];
    private boolean isAutoLocatePopup;
    private boolean showAtDown;
    private boolean dismissWhenTouchOutside;
    private boolean fullScreen = true;
    private volatile boolean needPopupFadeAnima = true;
    private int mPopupLayoutId;
    private boolean backPressEnable = true;
    private boolean interCeptOutSideTouchEvent = true;

    BasePopupHelper() {
    }

    int getPopupLayoutId() {
        return this.mPopupLayoutId;
    }

    BasePopupHelper setPopupLayoutId(int popupLayoutId) {
        this.mPopupLayoutId = popupLayoutId;
        return this;
    }

    Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    BasePopupHelper setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation == showAnimation) {
            return this;
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
        }
        this.mShowAnimation = showAnimation;
        return this;
    }

    Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    BasePopupHelper setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator == showAnimator) {
            return this;
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        this.mShowAnimator = showAnimator;
        return this;
    }

    Animation getExitAnimation() {
        return this.mExitAnimation;
    }

    BasePopupHelper setExitAnimation(Animation exitAnimation) {
        if (this.mExitAnimation == exitAnimation) {
            return this;
        }
        if (this.mExitAnimation != null) {
            this.mExitAnimation.cancel();
        }
        this.mExitAnimation = exitAnimation;
        return this;
    }

    Animator getExitAnimator() {
        return this.mExitAnimator;
    }

    BasePopupHelper setExitAnimator(Animator exitAnimator) {
        if (this.mExitAnimator == exitAnimator) {
            return this;
        }
        if (this.mExitAnimator != null) {
            this.mExitAnimator.cancel();
        }
        this.mExitAnimator = exitAnimator;
        return this;
    }

    int getPopupViewWidth() {
        return this.popupViewWidth;
    }

    BasePopupHelper setPopupViewWidth(int popupViewWidth) {
        this.popupViewWidth = popupViewWidth;
        return this;
    }

    int getPopupViewHeight() {
        return this.popupViewHeight;
    }

    BasePopupHelper setPopupViewHeight(int popupViewHeight) {
        this.popupViewHeight = popupViewHeight;
        return this;
    }

    boolean isNeedPopupFadeAnima() {
        return this.needPopupFadeAnima;
    }

    BasePopupHelper setNeedPopupFadeAnima(PopupWindow popupWindow, boolean needPopupFadeAnima) {
        if (popupWindow == null) {
            return this;
        }
        this.needPopupFadeAnima = needPopupFadeAnima;
        popupWindow.setAnimationStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
        return this;
    }

    boolean isShowAtDown() {
        return this.showAtDown;
    }

    BasePopupHelper setShowAtDown(boolean showAtDown) {
        this.showAtDown = showAtDown;
        return this;
    }

    int getPopupGravity() {
        return this.popupGravity;
    }

    BasePopupHelper setPopupGravity(int popupGravity) {
        this.popupGravity = popupGravity;
        return this;
    }

    int getOffsetX() {
        return this.offsetX;
    }

    BasePopupHelper setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    int getOffsetY() {
        return this.offsetY;
    }

    BasePopupHelper setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    boolean isAutoShowInputMethod() {
        return this.autoShowInputMethod;
    }

    BasePopupHelper setAutoShowInputMethod(PopupWindow popupWindow, boolean autoShowInputMethod) {
        if (popupWindow == null) {
            return this;
        }
        this.autoShowInputMethod = autoShowInputMethod;
        popupWindow.setSoftInputMode(autoShowInputMethod ? 16 : 48);
        return this;
    }

    boolean isAutoLocatePopup() {
        return this.isAutoLocatePopup;
    }

    BasePopupHelper setAutoLocatePopup(boolean autoLocatePopup) {
        this.isAutoLocatePopup = autoLocatePopup;
        return this;
    }

    BasePopupWindow.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    BasePopupHelper setOnDismissListener(BasePopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    BasePopupWindow.OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    BasePopupHelper setOnBeforeShowCallback(BasePopupWindow.OnBeforeShowCallback onBeforeShowCallback) {
        this.mOnBeforeShowCallback = onBeforeShowCallback;
        return this;
    }

    boolean isDismissWhenTouchOutside() {
        return this.dismissWhenTouchOutside;
    }

    BasePopupHelper setDismissWhenTouchOutside(PopupWindow popupWindow, boolean dismissWhenTouchOutside) {
        if (popupWindow == null) {
            return this;
        }
        this.dismissWhenTouchOutside = dismissWhenTouchOutside;
        return this;
    }

    boolean isInterceptTouchEvent() {
        return this.interCeptOutSideTouchEvent;
    }

    BasePopupHelper setInterceptTouchEvent(PopupWindow popupWindow, boolean intecept) {
        if (popupWindow == null) {
            return this;
        }
        this.interCeptOutSideTouchEvent = intecept;
        return this;
    }

    BasePopupHelper getAnchorLocation(View v) {
        if (v == null) {
            return this;
        }
        v.getLocationOnScreen(this.mAnchorViewLocation);
        return this;
    }

    int getAnchorX() {
        return this.mAnchorViewLocation[0];
    }

    int getAnchorY() {
        return this.mAnchorViewLocation[1];
    }

    public boolean isBackPressEnable() {
        return this.backPressEnable;
    }

    BasePopupHelper setBackPressEnable(PopupWindow popupWindow, boolean backPressEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.backPressEnable = backPressEnable;
        return this;
    }

    boolean isFullScreen() {
        return this.fullScreen;
    }

    BasePopupHelper setFullScreen(boolean fullScreen) {
        this.fullScreen = fullScreen;
        return this;
    }
}

