/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.util;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.annotations.Annotations;

public class CompatibilityHelper {
    private static final String BULLET = Character.toString('\u0095');
    private static final String DOUBLE_ANGLE = Character.toString('\u00bb');
    private static final String IMAGE_CACHE = "IMAGE_CACHE";
    private static Map<PDDocument, Map<String, Map<?, ?>>> documentCaches = new WeakHashMap();
    private static PDBorderStyleDictionary noBorder;

    public static String getBulletCharacter(int level) {
        if (level % 2 == 1) {
            return System.getProperty("pdfbox.layout.bullet.odd", BULLET);
        }
        return System.getProperty("pdfbox.layout.bullet.even", DOUBLE_ANGLE);
    }

    public static void clip(PDPageContentStream contentStream) throws IOException {
        contentStream.clipPath(1);
    }

    public static void transform(PDPageContentStream contentStream, float a, float b, float c, float d, float e, float f) throws IOException {
        contentStream.concatenate2CTM((double)a, (double)b, (double)c, (double)d, (double)e, (double)f);
    }

    public static void curveTo(PDPageContentStream contentStream, float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        contentStream.addBezier312(x1, y1, x2, y2, x3, y3);
    }

    public static void curveTo1(PDPageContentStream contentStream, float x1, float y1, float x3, float y3) throws IOException {
        contentStream.addBezier31(x1, y1, x3, y3);
    }

    public static void fillNonZero(PDPageContentStream contentStream) throws IOException {
        contentStream.fill(1);
    }

    public static void showText(PDPageContentStream contentStream, String text) throws IOException {
        contentStream.drawString(text);
    }

    public static void setTextTranslation(PDPageContentStream contentStream, float x, float y) throws IOException {
        contentStream.setTextTranslation((double)x, (double)y);
    }

    public static void moveTextPosition(PDPageContentStream contentStream, float x, float y) throws IOException {
        contentStream.concatenate2CTM(1.0, 0.0, 0.0, 1.0, (double)x, (double)y);
    }

    public static PDPageContentStream createAppendablePDPageContentStream(PDDocument pdDocument, PDPage page) throws IOException {
        return new PDPageContentStream(pdDocument, page, true, true);
    }

    public static void drawImage(BufferedImage image, PDDocument document, PDPageContentStream contentStream, Position upperLeft, float width, float height) throws IOException {
        PDXObjectImage cachedImage = CompatibilityHelper.getCachedImage(document, image);
        float x = upperLeft.getX();
        float y = upperLeft.getY() - height;
        contentStream.drawXObject((PDXObject)cachedImage, x, y, width, height);
    }

    public static BufferedImage createImageFromPage(PDDocument document, int pageIndex, int resolution) throws IOException {
        PDPage page = (PDPage)document.getDocumentCatalog().getAllPages().get(pageIndex);
        return page.convertToImage(1, resolution);
    }

    public static int getPageRotation(PDPage page) {
        return page.getRotation() == null ? 0 : page.getRotation();
    }

    public static PDAnnotationLink createLink(PDPage page, PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle, String uri) {
        PDAnnotationLink pdLink = CompatibilityHelper.createLink(page, rect, color, linkStyle);
        PDActionURI actionUri = new PDActionURI();
        actionUri.setURI(uri);
        pdLink.setAction((PDAction)actionUri);
        return pdLink;
    }

    public static PDAnnotationLink createLink(PDPage page, PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle, PDDestination destination) {
        PDAnnotationLink pdLink = CompatibilityHelper.createLink(page, rect, color, linkStyle);
        PDActionGoTo gotoAction = new PDActionGoTo();
        gotoAction.setDestination(destination);
        pdLink.setAction((PDAction)gotoAction);
        return pdLink;
    }

    private static PDAnnotationLink createLink(PDPage page, PDRectangle rect, Color color, Annotations.HyperlinkAnnotation.LinkStyle linkStyle) {
        PDAnnotationLink pdLink = new PDAnnotationLink();
        pdLink.setBorderStyle(CompatibilityHelper.toBorderStyle(linkStyle));
        PDRectangle rotatedRect = CompatibilityHelper.transformToPageRotation(rect, page);
        pdLink.setRectangle(rotatedRect);
        CompatibilityHelper.setAnnotationColor((PDAnnotation)pdLink, color);
        return pdLink;
    }

    private static PDBorderStyleDictionary toBorderStyle(Annotations.HyperlinkAnnotation.LinkStyle linkStyle) {
        if (linkStyle == Annotations.HyperlinkAnnotation.LinkStyle.none) {
            return CompatibilityHelper.getNoBorder();
        }
        PDBorderStyleDictionary borderStyle = new PDBorderStyleDictionary();
        borderStyle.setStyle("U");
        return borderStyle;
    }

    public static void setAnnotationColor(PDAnnotation annotation, Color color) {
        annotation.setColour(CompatibilityHelper.toPDGamma(color));
    }

    private static PDGamma toPDGamma(Color color) {
        COSArray values = new COSArray();
        values.add((COSBase)new COSFloat((float)color.getRed() / 255.0f));
        values.add((COSBase)new COSFloat((float)color.getGreen() / 255.0f));
        values.add((COSBase)new COSFloat((float)color.getBlue() / 255.0f));
        return new PDGamma(values);
    }

    public static float[] toQuadPoints(PDRectangle rect) {
        return CompatibilityHelper.toQuadPoints(rect, 0.0f, 0.0f);
    }

    public static float[] toQuadPoints(PDRectangle rect, float xOffset, float yOffset) {
        float[] quads;
        quads = new float[]{rect.getLowerLeftX() + xOffset, rect.getUpperRightY() + yOffset, rect.getUpperRightX() + xOffset, quads[1], quads[0], rect.getLowerLeftY() + yOffset, quads[2], quads[5]};
        return quads;
    }

    public static float[] transformToPageRotation(float[] quadPoints, PDPage page) {
        AffineTransform transform = CompatibilityHelper.transformToPageRotation(page);
        if (transform == null) {
            return quadPoints;
        }
        float[] rotatedPoints = new float[quadPoints.length];
        transform.transform(quadPoints, 0, rotatedPoints, 0, 4);
        return rotatedPoints;
    }

    public static PDRectangle transformToPageRotation(PDRectangle rect, PDPage page) {
        AffineTransform transform = CompatibilityHelper.transformToPageRotation(page);
        if (transform == null) {
            return rect;
        }
        float[] points = new float[]{rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY()};
        float[] rotatedPoints = new float[4];
        transform.transform(points, 0, rotatedPoints, 0, 2);
        PDRectangle rotated = new PDRectangle();
        rotated.setLowerLeftX(rotatedPoints[0]);
        rotated.setLowerLeftY(rotatedPoints[1]);
        rotated.setUpperRightX(rotatedPoints[2]);
        rotated.setUpperRightY(rotatedPoints[3]);
        return rotated;
    }

    private static AffineTransform transformToPageRotation(PDPage page) {
        int pageRotation = CompatibilityHelper.getPageRotation(page);
        if (pageRotation == 0) {
            return null;
        }
        float pageWidth = page.getMediaBox().getHeight();
        float pageHeight = page.getMediaBox().getWidth();
        AffineTransform transform = new AffineTransform();
        transform.rotate((double)pageRotation * Math.PI / 180.0, pageHeight / 2.0f, pageWidth / 2.0f);
        double offset = Math.abs(pageHeight - pageWidth) / 2.0f;
        transform.translate(-offset, offset);
        return transform;
    }

    private static PDBorderStyleDictionary getNoBorder() {
        if (noBorder == null) {
            noBorder = new PDBorderStyleDictionary();
            noBorder.setWidth(0.0f);
        }
        return noBorder;
    }

    private static synchronized Map<String, Map<?, ?>> getDocumentCache(PDDocument document) {
        Map<String, Map<?, ?>> cache = documentCaches.get(document);
        if (cache == null) {
            cache = new HashMap();
            documentCaches.put(document, cache);
        }
        return cache;
    }

    private static synchronized Map<BufferedImage, PDXObjectImage> getImageCache(PDDocument document) {
        Map<String, Map<?, ?>> documentCache = CompatibilityHelper.getDocumentCache(document);
        Map<BufferedImage, PDXObjectImage> imageCache = documentCache.get(IMAGE_CACHE);
        if (imageCache == null) {
            imageCache = new HashMap<BufferedImage, PDXObjectImage>();
            documentCache.put(IMAGE_CACHE, imageCache);
        }
        return imageCache;
    }

    private static synchronized PDXObjectImage getCachedImage(PDDocument document, BufferedImage image) throws IOException {
        Map<BufferedImage, PDXObjectImage> imageCache = CompatibilityHelper.getImageCache(document);
        PDXObjectImage pdxObjectImage = imageCache.get(image);
        if (pdxObjectImage == null) {
            pdxObjectImage = new PDPixelMap(document, image);
            imageCache.put(image, pdxObjectImage);
        }
        return pdxObjectImage;
    }
}

