/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.BaseFont;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.TextFlowUtil;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextSequence;
import rst.pdfbox.layout.text.TextSequenceUtil;
import rst.pdfbox.layout.text.WidthRespecting;

public class TextFlow
implements TextSequence,
WidthRespecting {
    public static final float DEFAULT_LINE_SPACING = 1.2f;
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private Map<String, Object> cache = new HashMap<String, Object>();
    private final List<TextFragment> text = new ArrayList<TextFragment>();
    private float lineSpacing = 1.2f;
    private float maxWidth = -1.0f;
    private boolean applyLineSpacingToFirstLine = true;

    private void clearCache() {
        this.cache.clear();
    }

    private void setCachedValue(String key, Object value) {
        this.cache.put(key, value);
    }

    private <T> T getCachedValue(String key, Class<T> type) {
        return (T)this.cache.get(key);
    }

    public void addText(String text, float fontSize, PDFont font) throws IOException {
        this.add(TextFlowUtil.createTextFlow(text, fontSize, font));
    }

    public void addMarkup(String markup, float fontSize, BaseFont baseFont) throws IOException {
        this.add(TextFlowUtil.createTextFlowFromMarkup(markup, fontSize, baseFont));
    }

    public void addMarkup(String markup, float fontSize, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) throws IOException {
        this.add(TextFlowUtil.createTextFlowFromMarkup(markup, fontSize, plainFont, boldFont, italicFont, boldItalicFont));
    }

    public void add(TextSequence sequence) {
        for (TextFragment fragment : sequence) {
            this.add(fragment);
        }
    }

    public void add(TextFragment fragment) {
        this.text.add(fragment);
        this.clearCache();
    }

    public TextFragment removeLast() {
        if (this.text.size() > 0) {
            this.clearCache();
            return this.text.remove(this.text.size() - 1);
        }
        return null;
    }

    public TextFragment getLast() {
        if (this.text.size() > 0) {
            this.clearCache();
            return this.text.get(this.text.size() - 1);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public Iterator<TextFragment> iterator() {
        return this.text.iterator();
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
        this.clearCache();
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.clearCache();
    }

    public boolean isApplyLineSpacingToFirstLine() {
        return this.applyLineSpacingToFirstLine;
    }

    public void setApplyLineSpacingToFirstLine(boolean applyLineSpacingToFirstLine) {
        this.applyLineSpacingToFirstLine = applyLineSpacingToFirstLine;
    }

    @Override
    public float getWidth() throws IOException {
        Float width = this.getCachedValue(WIDTH, Float.class);
        if (width == null) {
            width = Float.valueOf(TextSequenceUtil.getWidth(this, this.getMaxWidth()));
            this.setCachedValue(WIDTH, width);
        }
        return width.floatValue();
    }

    @Override
    public float getHeight() throws IOException {
        Float height = this.getCachedValue(HEIGHT, Float.class);
        if (height == null) {
            height = Float.valueOf(TextSequenceUtil.getHeight(this, this.getMaxWidth(), this.getLineSpacing(), this.isApplyLineSpacingToFirstLine()));
            this.setCachedValue(HEIGHT, height);
        }
        return height.floatValue();
    }

    @Override
    public void drawText(PDPageContentStream contentStream, Position upperLeft, Alignment alignment, DrawListener drawListener) throws IOException {
        TextSequenceUtil.drawText(this, contentStream, upperLeft, drawListener, alignment, this.getMaxWidth(), this.getLineSpacing(), this.isApplyLineSpacingToFirstLine());
    }

    public void drawTextRightAligned(PDPageContentStream contentStream, Position endOfFirstLine, DrawListener drawListener) throws IOException {
        this.drawText(contentStream, endOfFirstLine.add(-this.getWidth(), 0.0f), Alignment.Right, drawListener);
    }

    public TextFlow removeLeadingEmptyLines() throws IOException {
        if (this.text.size() == 0 || !(this.text.get(0) instanceof NewLine)) {
            return this;
        }
        TextFlow result = this.createInstance();
        result.setApplyLineSpacingToFirstLine(this.isApplyLineSpacingToFirstLine());
        result.setLineSpacing(this.getLineSpacing());
        result.setMaxWidth(this.getMaxWidth());
        for (TextFragment fragment : this) {
            if (result.isEmpty() && fragment instanceof NewLine) continue;
            result.add(fragment);
        }
        return result;
    }

    protected TextFlow createInstance() {
        return new TextFlow();
    }

    public String toString() {
        return "TextFlow [text=" + this.text + "]";
    }
}

