/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.shape;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class Stroke {
    private final CapStyle capStyle;
    private final JoinStyle joinStyle;
    private final DashPattern dashPattern;
    private final float lineWidth;

    public Stroke() {
        this(1.0f);
    }

    public Stroke(float lineWidth) {
        this(CapStyle.Cap, JoinStyle.Miter, null, lineWidth);
    }

    public Stroke(CapStyle capStyle, JoinStyle joinStyle, DashPattern dashPattern, float lineWidth) {
        this.capStyle = capStyle;
        this.joinStyle = joinStyle;
        this.dashPattern = dashPattern;
        this.lineWidth = lineWidth;
    }

    public CapStyle getCapStyle() {
        return this.capStyle;
    }

    public JoinStyle getJoinStyle() {
        return this.joinStyle;
    }

    public DashPattern getDashPattern() {
        return this.dashPattern;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void applyTo(PDPageContentStream contentStream) throws IOException {
        if (this.getCapStyle() != null) {
            contentStream.setLineCapStyle(this.getCapStyle().value());
        }
        if (this.getJoinStyle() != null) {
            contentStream.setLineJoinStyle(this.getJoinStyle().value());
        }
        if (this.getDashPattern() != null) {
            contentStream.setLineDashPattern(this.getDashPattern().getPattern(), this.getDashPattern().getPhase());
        }
        contentStream.setLineWidth(this.getLineWidth());
    }

    public static StrokeBuilder builder() {
        return new StrokeBuilder();
    }

    public static class StrokeBuilder {
        private CapStyle capStyle = CapStyle.Cap;
        private JoinStyle joinStyle = JoinStyle.Miter;
        private DashPattern dashPattern;
        float lineWidth = 1.0f;

        public StrokeBuilder capStyle(CapStyle capStyle) {
            this.capStyle = capStyle;
            return this;
        }

        public StrokeBuilder joinStyle(JoinStyle joinStyle) {
            this.joinStyle = joinStyle;
            return this;
        }

        public StrokeBuilder dashPattern(DashPattern dashPattern) {
            this.dashPattern = dashPattern;
            return this;
        }

        public StrokeBuilder lineWidth(float lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public Stroke build() {
            return new Stroke(this.capStyle, this.joinStyle, this.dashPattern, this.lineWidth);
        }
    }

    public static class DashPattern {
        private final float[] pattern;
        private final float phase;

        public DashPattern(float onOff) {
            this(onOff, onOff, 0.0f);
        }

        public DashPattern(float on, float off) {
            this(on, off, 0.0f);
        }

        public DashPattern(float on, float off, float phase) {
            this.pattern = new float[]{on, off};
            this.phase = phase;
        }

        public float getOn() {
            return this.pattern[0];
        }

        public float getOff() {
            return this.pattern[1];
        }

        public float[] getPattern() {
            return this.pattern;
        }

        public float getPhase() {
            return this.phase;
        }
    }

    public static enum JoinStyle {
        Miter(0),
        Round(1),
        Bevel(2);

        private final int value;

        private JoinStyle(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum CapStyle {
        Cap(0),
        RoundCap(1),
        Square(2);

        private final int value;

        private CapStyle(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

