/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.shape;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import rst.pdfbox.layout.shape.AbstractShape;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class RoundRect
extends AbstractShape {
    private static final float BEZ = 0.55191505f;
    private final float cornerRadiusX;
    private final float cornerRadiusY;

    public RoundRect(float cornerRadius) {
        this(cornerRadius, cornerRadius);
    }

    public RoundRect(float cornerRadiusX, float cornerRadiusY) {
        this.cornerRadiusX = cornerRadiusX;
        this.cornerRadiusY = cornerRadiusY;
    }

    @Override
    public void add(PDDocument pdDocument, PDPageContentStream contentStream, Position upperLeft, float width, float height) throws IOException {
        this.addRoundRect(contentStream, upperLeft, width, height, this.cornerRadiusX, this.cornerRadiusY);
    }

    protected void addRoundRect(PDPageContentStream contentStream, Position upperLeft, float width, float height, float cornerRadiusX, float cornerRadiusY) throws IOException {
        float nettoWidth = width - 2.0f * cornerRadiusX;
        float nettoHeight = height - 2.0f * cornerRadiusY;
        Position a = new Position(upperLeft.getX() + cornerRadiusX, upperLeft.getY());
        Position b = new Position(a.getX() + nettoWidth, a.getY());
        Position c = new Position(upperLeft.getX() + width, upperLeft.getY() - cornerRadiusY);
        Position d = new Position(c.getX(), c.getY() - nettoHeight);
        Position e = new Position(upperLeft.getX() + width - cornerRadiusX, upperLeft.getY() - height);
        Position f = new Position(e.getX() - nettoWidth, e.getY());
        Position g = new Position(upperLeft.getX(), upperLeft.getY() - height + cornerRadiusY);
        Position h = new Position(g.getX(), upperLeft.getY() - cornerRadiusY);
        float bezX = cornerRadiusX * 0.55191505f;
        float bezY = cornerRadiusY * 0.55191505f;
        contentStream.moveTo(a.getX(), a.getY());
        this.addLine(contentStream, a.getX(), a.getY(), b.getX(), b.getY());
        CompatibilityHelper.curveTo(contentStream, b.getX() + bezX, b.getY(), c.getX(), c.getY() + bezY, c.getX(), c.getY());
        this.addLine(contentStream, c.getX(), c.getY(), d.getX(), d.getY());
        CompatibilityHelper.curveTo(contentStream, d.getX(), d.getY() - bezY, e.getX() + bezX, e.getY(), e.getX(), e.getY());
        this.addLine(contentStream, e.getX(), e.getY(), f.getX(), f.getY());
        CompatibilityHelper.curveTo(contentStream, f.getX() - bezX, f.getY(), g.getX(), g.getY() - bezY, g.getX(), g.getY());
        this.addLine(contentStream, g.getX(), g.getY(), h.getX(), h.getY());
        CompatibilityHelper.curveTo(contentStream, h.getX(), h.getY() + bezY, a.getX() - bezX, a.getY(), a.getX(), a.getY());
    }

    private void addLine(PDPageContentStream contentStream, float x1, float y1, float x2, float y2) throws IOException {
        float xMid = (x1 + x2) / 2.0f;
        float yMid = (y1 + y2) / 2.0f;
        CompatibilityHelper.curveTo1(contentStream, xMid, yMid, x2, y2);
    }
}

