/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.text.DrawListener;
import rst.pdfbox.layout.text.Position;

public class Cutter
implements Dividable,
Drawable {
    private final Drawable undividable;
    private final float viewPortY;
    private final float viewPortHeight;

    public Cutter(Drawable undividableElement) throws IOException {
        this(undividableElement, 0.0f, undividableElement.getHeight());
    }

    protected Cutter(Drawable undividable, float viewPortY, float viewPortHeight) {
        this.undividable = undividable;
        this.viewPortY = viewPortY;
        this.viewPortHeight = viewPortHeight;
    }

    @Override
    public Dividable.Divided divide(float remainingHeight, float pageHeight) {
        return new Dividable.Divided(new Cutter(this.undividable, this.viewPortY, remainingHeight), new Cutter(this.undividable, this.viewPortY - remainingHeight, this.viewPortHeight - remainingHeight));
    }

    @Override
    public float getWidth() throws IOException {
        return this.undividable.getWidth();
    }

    @Override
    public float getHeight() throws IOException {
        return this.viewPortHeight;
    }

    @Override
    public Position getAbsolutePosition() {
        return null;
    }

    @Override
    public void draw(PDDocument pdDocument, PDPageContentStream contentStream, Position upperLeft, DrawListener drawListener) throws IOException {
        Position viewPortOrigin = upperLeft.add(0.0f, -this.viewPortY);
        this.undividable.draw(pdDocument, contentStream, viewPortOrigin, drawListener);
    }

    @Override
    public Drawable removeLeadingEmptyVerticalSpace() throws IOException {
        return new Cutter(this.undividable.removeLeadingEmptyVerticalSpace());
    }
}

