/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextSequence;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class TextLine
implements TextSequence {
    private final List<StyledText> styledTextList = new ArrayList<StyledText>();
    private NewLine newLine;

    public void add(StyledText fragment) {
        this.styledTextList.add(fragment);
    }

    public void add(TextLine textLine) {
        for (StyledText fragment : textLine.getStyledTexts()) {
            this.add(fragment);
        }
    }

    public NewLine getNewLine() {
        return this.newLine;
    }

    public void setNewLine(NewLine newLine) {
        this.newLine = newLine;
    }

    public List<StyledText> getStyledTexts() {
        return Collections.unmodifiableList(this.styledTextList);
    }

    @Override
    public Iterator<TextFragment> iterator() {
        return new TextLineIterator(this.styledTextList.iterator(), this.newLine);
    }

    public boolean isEmpty() {
        return this.styledTextList.isEmpty() && this.newLine == null;
    }

    @Override
    public float getWidth() throws IOException {
        float sum = 0.0f;
        for (TextFragment fragment : this) {
            sum += fragment.getWidth();
        }
        return sum;
    }

    @Override
    public float getHeight() throws IOException {
        float max = 0.0f;
        for (TextFragment fragment : this) {
            max = Math.max(max, fragment.getHeight());
        }
        return max;
    }

    protected float getAscent() throws IOException {
        float max = 0.0f;
        for (TextFragment fragment : this) {
            float ascent = fragment.getFontDescriptor().getSize() * fragment.getFontDescriptor().getFont().getFontDescriptor().getAscent() / 1000.0f;
            max = Math.max(max, ascent);
        }
        return max;
    }

    @Override
    public void drawText(PDPageContentStream contentStream, Position upperLeft, Alignment alignment) throws IOException {
        contentStream.saveGraphicsState();
        contentStream.beginText();
        float x = upperLeft.getX();
        float y = upperLeft.getY() - this.getAscent();
        CompatibilityHelper.setTextTranslation(contentStream, x, y);
        FontDescriptor lastFontDesc = null;
        Color lastColor = null;
        for (StyledText styledText : this.styledTextList) {
            if (!styledText.getFontDescriptor().equals(lastFontDesc)) {
                lastFontDesc = styledText.getFontDescriptor();
                contentStream.setFont(lastFontDesc.getFont(), lastFontDesc.getSize());
            }
            if (!styledText.getColor().equals(lastColor)) {
                lastColor = styledText.getColor();
                contentStream.setNonStrokingColor(lastColor);
            }
            CompatibilityHelper.showText(contentStream, styledText.getText());
        }
        contentStream.endText();
        contentStream.restoreGraphicsState();
    }

    public String toString() {
        return "TextLine [styledText=" + this.styledTextList + ", newLine=" + this.newLine + "]";
    }

    private static class TextLineIterator
    implements Iterator<TextFragment> {
        private Iterator<StyledText> styledText;
        private NewLine newLine;

        public TextLineIterator(Iterator<StyledText> styledText, NewLine newLine) {
            this.styledText = styledText;
            this.newLine = newLine;
        }

        @Override
        public boolean hasNext() {
            return this.styledText.hasNext() || this.newLine != null;
        }

        @Override
        public TextFragment next() {
            TextFragment next = null;
            if (this.styledText.hasNext()) {
                next = this.styledText.next();
            } else if (this.newLine != null) {
                next = this.newLine;
                this.newLine = null;
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

