/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextLine;
import rst.pdfbox.layout.text.TextSequence;

public class StyledText
implements TextFragment {
    private final String text;
    private final FontDescriptor fontDescriptor;
    private Color color = Color.black;

    public StyledText(String text, float size, PDFont font) {
        this(text, new FontDescriptor(font, size));
    }

    public StyledText(String text, FontDescriptor fontDescriptor) {
        if (text.contains("\n")) {
            throw new IllegalArgumentException("StyledText must not contain line breaks, use TextFragment.LINEBREAK for that");
        }
        this.text = text;
        this.fontDescriptor = fontDescriptor;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public FontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }

    @Override
    public float getWidth() throws IOException {
        return this.getFontDescriptor().getSize() * this.getFontDescriptor().getFont().getStringWidth(this.getText()) / 1000.0f;
    }

    @Override
    public float getHeight() throws IOException {
        return this.getFontDescriptor().getSize();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public TextSequence asSequence() {
        TextLine line = new TextLine();
        line.add(this);
        return line;
    }

    public String toString() {
        return "StyledText [text=" + this.text + ", fontDescriptor=" + this.fontDescriptor + ", color=" + this.color + "]";
    }
}

