/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements.render;

import java.io.Closeable;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import rst.pdfbox.layout.elements.Document;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.util.CompatibilityHelper;

public class RenderContext
implements Closeable {
    private final Document document;
    private final PDDocument pdDocument;
    private PDPage page;
    private int pageIndex = 0;
    private PDPageContentStream contentStream;
    private Position currentPosition;

    public RenderContext(Document document, PDDocument pdDocument) throws IOException {
        this.document = document;
        this.pdDocument = pdDocument;
        this.newPage();
    }

    public Position getUpperLeft() {
        return new Position(this.document.getMarginLeft(), this.page.getMediaBox().getHeight() - this.document.getMarginTop());
    }

    public Position getCurrentPosition() {
        return this.currentPosition;
    }

    public void movePositionBy(float x, float y) {
        this.currentPosition = this.currentPosition.add(x, y);
    }

    public float getWidth() {
        return this.page.getMediaBox().getWidth() - this.document.getMarginLeft() - this.document.getMarginRight();
    }

    public float getHeight() {
        return this.page.getMediaBox().getHeight() - this.document.getMarginTop() - this.document.getMarginBottom();
    }

    public float getRemainingHeight() {
        return this.getCurrentPosition().getY() - this.document.getMarginBottom();
    }

    public Document getDocument() {
        return this.document;
    }

    public PDDocument getPdDocument() {
        return this.pdDocument;
    }

    public PDPage getPage() {
        return this.page;
    }

    public PDPageContentStream getContentStream() {
        return this.contentStream;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void newPage() throws IOException {
        if (this.closePage()) {
            ++this.pageIndex;
        }
        this.page = new PDPage(this.document.getMediaBox());
        this.pdDocument.addPage(this.page);
        this.contentStream = CompatibilityHelper.createAppendablePDPageContentStream(this.pdDocument, this.page);
        this.currentPosition = this.getUpperLeft();
        this.document.beforePage(this);
    }

    public boolean closePage() throws IOException {
        if (this.contentStream != null) {
            this.document.afterPage(this);
            this.contentStream.close();
            this.contentStream = null;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.closePage();
    }
}

