/*
 * Decompiled with CFR 0.152.
 */
package com.github.rahatarmanahmed.cpv;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.github.rahatarmanahmed.cpv.CircularProgressViewListener;
import com.github.rahatarmanahmed.cpv.R;
import java.util.ArrayList;
import java.util.List;

public class CircularProgressView
extends View {
    private static final float INDETERMINANT_MIN_SWEEP = 15.0f;
    private Paint paint;
    private int size = 0;
    private RectF bounds;
    private boolean isIndeterminate;
    private boolean autostartAnimation;
    private float currentProgress;
    private float maxProgress;
    private float indeterminateSweep;
    private float indeterminateRotateOffset;
    private int thickness;
    private int color;
    private int animDuration;
    private int animSwoopDuration;
    private int animSyncDuration;
    private int animSteps;
    private List<CircularProgressViewListener> listeners;
    private float startAngle;
    private float actualProgress;
    private ValueAnimator startAngleRotate;
    private ValueAnimator progressAnimator;
    private AnimatorSet indeterminateAnimator;
    private float initialStartAngle;

    public CircularProgressView(Context context) {
        super(context);
        this.init(null, 0);
    }

    public CircularProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public CircularProgressView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    protected void init(AttributeSet attrs, int defStyle) {
        this.listeners = new ArrayList<CircularProgressViewListener>();
        this.initAttributes(attrs, defStyle);
        this.paint = new Paint(1);
        this.updatePaint();
        this.bounds = new RectF();
    }

    private void initAttributes(AttributeSet attrs, int defStyle) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.CircularProgressView, defStyle, 0);
        Resources resources = this.getResources();
        this.currentProgress = a.getFloat(R.styleable.CircularProgressView_cpv_progress, (float)resources.getInteger(R.integer.cpv_default_progress));
        this.maxProgress = a.getFloat(R.styleable.CircularProgressView_cpv_maxProgress, (float)resources.getInteger(R.integer.cpv_default_max_progress));
        this.thickness = a.getDimensionPixelSize(R.styleable.CircularProgressView_cpv_thickness, resources.getDimensionPixelSize(R.dimen.cpv_default_thickness));
        this.isIndeterminate = a.getBoolean(R.styleable.CircularProgressView_cpv_indeterminate, resources.getBoolean(R.bool.cpv_default_is_indeterminate));
        this.autostartAnimation = a.getBoolean(R.styleable.CircularProgressView_cpv_animAutostart, resources.getBoolean(R.bool.cpv_default_anim_autostart));
        this.startAngle = this.initialStartAngle = a.getFloat(R.styleable.CircularProgressView_cpv_startAngle, (float)resources.getInteger(R.integer.cpv_default_start_angle));
        int accentColor = this.getContext().getResources().getIdentifier("colorAccent", "attr", this.getContext().getPackageName());
        if (a.hasValue(R.styleable.CircularProgressView_cpv_color)) {
            this.color = a.getColor(R.styleable.CircularProgressView_cpv_color, resources.getColor(R.color.cpv_default_color));
        } else if (accentColor != 0) {
            TypedValue t = new TypedValue();
            this.getContext().getTheme().resolveAttribute(accentColor, t, true);
            this.color = t.data;
        } else if (Build.VERSION.SDK_INT >= 21) {
            TypedArray t = this.getContext().obtainStyledAttributes(new int[]{16843829});
            this.color = t.getColor(0, resources.getColor(R.color.cpv_default_color));
        } else {
            this.color = resources.getColor(R.color.cpv_default_color);
        }
        this.animDuration = a.getInteger(R.styleable.CircularProgressView_cpv_animDuration, resources.getInteger(R.integer.cpv_default_anim_duration));
        this.animSwoopDuration = a.getInteger(R.styleable.CircularProgressView_cpv_animSwoopDuration, resources.getInteger(R.integer.cpv_default_anim_swoop_duration));
        this.animSyncDuration = a.getInteger(R.styleable.CircularProgressView_cpv_animSyncDuration, resources.getInteger(R.integer.cpv_default_anim_sync_duration));
        this.animSteps = a.getInteger(R.styleable.CircularProgressView_cpv_animSteps, resources.getInteger(R.integer.cpv_default_anim_steps));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int xPad = this.getPaddingLeft() + this.getPaddingRight();
        int yPad = this.getPaddingTop() + this.getPaddingBottom();
        int width = this.getMeasuredWidth() - xPad;
        int height = this.getMeasuredHeight() - yPad;
        this.size = width < height ? width : height;
        this.setMeasuredDimension(this.size + xPad, this.size + yPad);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.size = w < h ? w : h;
        this.updateBounds();
    }

    private void updateBounds() {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        this.bounds.set((float)(paddingLeft + this.thickness), (float)(paddingTop + this.thickness), (float)(this.size - paddingLeft - this.thickness), (float)(this.size - paddingTop - this.thickness));
    }

    private void updatePaint() {
        this.paint.setColor(this.color);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth((float)this.thickness);
        this.paint.setStrokeCap(Paint.Cap.BUTT);
    }

    protected void onDraw(Canvas canvas) {
        float sweepAngle;
        super.onDraw(canvas);
        float f = sweepAngle = this.isInEditMode() ? this.currentProgress / this.maxProgress * 360.0f : this.actualProgress / this.maxProgress * 360.0f;
        if (!this.isIndeterminate) {
            canvas.drawArc(this.bounds, this.startAngle, sweepAngle, false, this.paint);
        } else {
            canvas.drawArc(this.bounds, this.startAngle + this.indeterminateRotateOffset, this.indeterminateSweep, false, this.paint);
        }
    }

    public boolean isIndeterminate() {
        return this.isIndeterminate;
    }

    public void setIndeterminate(boolean isIndeterminate) {
        boolean old = this.isIndeterminate;
        boolean reset = this.isIndeterminate == isIndeterminate;
        this.isIndeterminate = isIndeterminate;
        if (reset) {
            this.resetAnimation();
        }
        if (old != isIndeterminate) {
            for (CircularProgressViewListener listener : this.listeners) {
                listener.onModeChanged(isIndeterminate);
            }
        }
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.thickness = thickness;
        this.updatePaint();
        this.updateBounds();
        this.invalidate();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color2) {
        this.color = color2;
        this.updatePaint();
        this.invalidate();
    }

    public float getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(float maxProgress) {
        this.maxProgress = maxProgress;
        this.invalidate();
    }

    public float getProgress() {
        return this.currentProgress;
    }

    public void setProgress(final float currentProgress) {
        this.currentProgress = currentProgress;
        if (!this.isIndeterminate) {
            if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
                this.progressAnimator.cancel();
            }
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, currentProgress});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CircularProgressView.this.actualProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.progressAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    for (CircularProgressViewListener listener : CircularProgressView.this.listeners) {
                        listener.onProgressUpdateEnd(currentProgress);
                    }
                }
            });
            this.progressAnimator.start();
        }
        this.invalidate();
        for (CircularProgressViewListener listener : this.listeners) {
            listener.onProgressUpdate(currentProgress);
        }
    }

    public void addListener(CircularProgressViewListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(CircularProgressViewListener listener) {
        this.listeners.remove(listener);
    }

    public void startAnimation() {
        this.resetAnimation();
    }

    public void resetAnimation() {
        if (this.startAngleRotate != null && this.startAngleRotate.isRunning()) {
            this.startAngleRotate.cancel();
        }
        if (this.progressAnimator != null && this.progressAnimator.isRunning()) {
            this.progressAnimator.cancel();
        }
        if (this.indeterminateAnimator != null && this.indeterminateAnimator.isRunning()) {
            this.indeterminateAnimator.cancel();
        }
        if (!this.isIndeterminate) {
            this.startAngle = this.initialStartAngle;
            this.startAngleRotate = ValueAnimator.ofFloat((float[])new float[]{this.startAngle, this.startAngle + 360.0f});
            this.startAngleRotate.setDuration((long)this.animSwoopDuration);
            this.startAngleRotate.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
            this.startAngleRotate.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CircularProgressView.this.startAngle = ((Float)animation.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.startAngleRotate.start();
            this.actualProgress = 0.0f;
            this.progressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.actualProgress, this.currentProgress});
            this.progressAnimator.setDuration((long)this.animSyncDuration);
            this.progressAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.progressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    CircularProgressView.this.actualProgress = ((Float)animation.getAnimatedValue()).floatValue();
                    CircularProgressView.this.invalidate();
                }
            });
            this.progressAnimator.start();
        } else {
            this.indeterminateSweep = 15.0f;
            this.indeterminateAnimator = new AnimatorSet();
            AnimatorSet prevSet = null;
            for (int k = 0; k < this.animSteps; ++k) {
                AnimatorSet nextSet = this.createIndeterminateAnimator(k);
                AnimatorSet.Builder builder = this.indeterminateAnimator.play((Animator)nextSet);
                if (prevSet != null) {
                    builder.after((Animator)prevSet);
                }
                prevSet = nextSet;
            }
            this.indeterminateAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                boolean wasCancelled = false;

                public void onAnimationCancel(Animator animation) {
                    this.wasCancelled = true;
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.wasCancelled) {
                        CircularProgressView.this.resetAnimation();
                    }
                }
            });
            this.indeterminateAnimator.start();
            for (CircularProgressViewListener listener : this.listeners) {
                listener.onAnimationReset();
            }
        }
    }

    public void stopAnimation() {
        if (this.startAngleRotate != null) {
            this.startAngleRotate.cancel();
            this.startAngleRotate = null;
        }
        if (this.progressAnimator != null) {
            this.progressAnimator.cancel();
            this.progressAnimator = null;
        }
        if (this.indeterminateAnimator != null) {
            this.indeterminateAnimator.cancel();
            this.indeterminateAnimator = null;
        }
    }

    private AnimatorSet createIndeterminateAnimator(float step) {
        final float maxSweep = 360.0f * (float)(this.animSteps - 1) / (float)this.animSteps + 15.0f;
        final float start = -90.0f + step * (maxSweep - 15.0f);
        ValueAnimator frontEndExtend = ValueAnimator.ofFloat((float[])new float[]{15.0f, maxSweep});
        frontEndExtend.setDuration((long)(this.animDuration / this.animSteps / 2));
        frontEndExtend.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        frontEndExtend.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularProgressView.this.indeterminateSweep = ((Float)animation.getAnimatedValue()).floatValue();
                CircularProgressView.this.invalidate();
            }
        });
        ValueAnimator rotateAnimator1 = ValueAnimator.ofFloat((float[])new float[]{step * 720.0f / (float)this.animSteps, (step + 0.5f) * 720.0f / (float)this.animSteps});
        rotateAnimator1.setDuration((long)(this.animDuration / this.animSteps / 2));
        rotateAnimator1.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimator1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularProgressView.this.indeterminateRotateOffset = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        ValueAnimator backEndRetract = ValueAnimator.ofFloat((float[])new float[]{start, start + maxSweep - 15.0f});
        backEndRetract.setDuration((long)(this.animDuration / this.animSteps / 2));
        backEndRetract.setInterpolator((TimeInterpolator)new DecelerateInterpolator(1.0f));
        backEndRetract.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularProgressView.this.startAngle = ((Float)animation.getAnimatedValue()).floatValue();
                CircularProgressView.this.indeterminateSweep = maxSweep - CircularProgressView.this.startAngle + start;
                CircularProgressView.this.invalidate();
            }
        });
        ValueAnimator rotateAnimator2 = ValueAnimator.ofFloat((float[])new float[]{(step + 0.5f) * 720.0f / (float)this.animSteps, (step + 1.0f) * 720.0f / (float)this.animSteps});
        rotateAnimator2.setDuration((long)(this.animDuration / this.animSteps / 2));
        rotateAnimator2.setInterpolator((TimeInterpolator)new LinearInterpolator());
        rotateAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CircularProgressView.this.indeterminateRotateOffset = ((Float)animation.getAnimatedValue()).floatValue();
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.play((Animator)frontEndExtend).with((Animator)rotateAnimator1);
        set.play((Animator)backEndRetract).with((Animator)rotateAnimator2).after((Animator)rotateAnimator1);
        return set;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.autostartAnimation) {
            this.startAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public void setVisibility(int visibility) {
        int currentVisibility = this.getVisibility();
        super.setVisibility(visibility);
        if (visibility != currentVisibility) {
            if (visibility == 0) {
                this.resetAnimation();
            } else if (visibility == 8 || visibility == 4) {
                this.stopAnimation();
            }
        }
    }
}

