/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.github.qwazer.markdown.confluence.core.ConfluenceConfig;
import com.github.qwazer.markdown.confluence.core.ConfluenceException;
import com.github.qwazer.markdown.confluence.core.model.ConfluencePage;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ConfluenceService {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceService.class);
    private static final String EXPAND = "expand";
    private static final String ID = "id";
    private static final String SPACE_KEY = "spaceKey";
    private static final String TITLE = "title";
    private final RestTemplate restTemplate;
    private ConfluenceConfig confluenceConfig;
    private HttpHeaders httpHeaders;
    private HttpHeaders httpHeadersForAttachment;

    @Autowired
    public ConfluenceService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setConfluenceConfig(ConfluenceConfig confluenceConfig) {
        this.confluenceConfig = confluenceConfig;
        this.httpHeaders = ConfluenceService.buildHttpHeaders(confluenceConfig);
        this.httpHeadersForAttachment = ConfluenceService.buildHttpHeadersForAttachment(confluenceConfig);
    }

    private static HttpHeaders buildHttpHeaders(ConfluenceConfig config) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", config.getAuthenticationType().getAuthorizationHeader(config));
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return headers;
    }

    private static HttpHeaders buildHttpHeadersForAttachment(ConfluenceConfig config) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", config.getAuthenticationType().getAuthorizationHeader(config));
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        headers.set("X-Atlassian-Token", "no-check");
        return headers;
    }

    public ConfluencePage findPageByTitle(String title) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpHeaders);
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content").queryParam(SPACE_KEY, new Object[]{this.confluenceConfig.getSpaceKey()}).queryParam(TITLE, new Object[]{title}).queryParam(EXPAND, new Object[]{"body.storage,version,ancestors"}).build(false).encode().toUri();
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.GET, requestEntity, String.class);
        ConfluencePage confluencePage = ConfluenceService.parseResponseEntityToConfluencePage((ResponseEntity<String>)responseEntity);
        return confluencePage;
    }

    public ConfluencePage findSpaceHomePage(String spaceKey) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpHeaders);
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content").queryParam(SPACE_KEY, new Object[]{this.confluenceConfig.getSpaceKey()}).queryParam(EXPAND, new Object[]{"body.storage,version,ancestors"}).build(false).encode().toUri();
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.GET, requestEntity, String.class);
        ConfluencePage confluencePage = ConfluenceService.parseResponseEntityToConfluencePage((ResponseEntity<String>)responseEntity);
        return confluencePage;
    }

    public void updatePage(ConfluencePage page) {
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path(String.format("/content/%s", page.getId())).build().toUri();
        JSONObject postVersionObject = new JSONObject();
        postVersionObject.put((Object)"number", (Object)(page.getVersion() + 1));
        JSONObject postBody = this.buildPostBody(page);
        postBody.put((Object)ID, (Object)page.getId());
        postBody.put((Object)"version", (Object)postVersionObject);
        HttpEntity requestEntity = new HttpEntity((Object)postBody.toJSONString(), (MultiValueMap)this.httpHeaders);
        LOG.debug("Request of updating page: {}", (Object)postBody);
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.PUT, requestEntity, String.class);
        LOG.debug("Response of updating page: {}", responseEntity.getBody());
    }

    public Long createPage(ConfluencePage page) {
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content").build().toUri();
        String jsonPostBody = this.buildPostBody(page).toJSONString();
        LOG.debug("Request of creating page: {}", (Object)jsonPostBody);
        HttpEntity requestEntity = new HttpEntity((Object)jsonPostBody, (MultiValueMap)this.httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.POST, requestEntity, String.class);
        LOG.debug("Response of creating page: {}", responseEntity.getBody());
        return ConfluenceService.parsePageIdFromResponse((HttpEntity<String>)responseEntity);
    }

    public void addLabels(Long pageId, Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return;
        }
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content/{id}/label").buildAndExpand(new Object[]{pageId}).toUri();
        String jsonPostBody = ConfluenceService.buildAddLabelsPostBody(labels);
        LOG.debug("Request of adding labels: {}", (Object)jsonPostBody);
        HttpEntity requestEntity = new HttpEntity((Object)jsonPostBody, (MultiValueMap)this.httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.POST, requestEntity, String.class);
        LOG.debug("Response of adding labels: {}", responseEntity.getBody());
    }

    private static String buildAddLabelsPostBody(Collection<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return null;
        }
        JSONArray jsonArray = new JSONArray();
        for (String s : labels) {
            if (s == null || s.isEmpty()) continue;
            JSONObject label = new JSONObject();
            label.put((Object)"prefix", (Object)"global");
            label.put((Object)"name", (Object)s);
            jsonArray.add((Object)label);
        }
        return jsonArray.toJSONString();
    }

    protected static ConfluencePage parseResponseEntityToConfluencePage(ResponseEntity<String> responseEntity) {
        String jsonBody = (String)responseEntity.getBody();
        try {
            LOG.debug("Try to parse response: {}", (Object)jsonBody);
            String id = (String)JsonPath.read((String)jsonBody, (String)"$.results[0].id", (Predicate[])new Predicate[0]);
            Integer version = (Integer)JsonPath.read((String)jsonBody, (String)"$.results[0].version.number", (Predicate[])new Predicate[0]);
            JSONArray ancestors = (JSONArray)JsonPath.read((String)jsonBody, (String)"$.results[0].ancestors", (Predicate[])new Predicate[0]);
            ConfluencePage confluencePage = new ConfluencePage();
            if (!ancestors.isEmpty()) {
                Map lastAncestor = (Map)ancestors.get(ancestors.size() - 1);
                Long ancestorId = Long.valueOf((String)lastAncestor.get(ID));
                LOG.debug("ancestors: {} : {}, choose -> {}", new Object[]{ancestors.getClass().getName(), ancestors, ancestorId});
                confluencePage.setAncestorId(ancestorId);
            }
            confluencePage.setId(Long.parseLong(id));
            confluencePage.setVersion(version);
            return confluencePage;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    private JSONObject buildPostBody(ConfluencePage confluencePage) {
        JSONObject jsonSpaceObject = new JSONObject();
        jsonSpaceObject.put((Object)"key", (Object)this.confluenceConfig.getSpaceKey());
        JSONObject jsonStorageObject = new JSONObject();
        jsonStorageObject.put((Object)"value", (Object)confluencePage.getContent());
        jsonStorageObject.put((Object)"representation", (Object)"wiki");
        JSONObject jsonBodyObject = new JSONObject();
        jsonBodyObject.put((Object)"storage", (Object)jsonStorageObject);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"type", (Object)"page");
        jsonObject.put((Object)TITLE, (Object)confluencePage.getTitle());
        jsonObject.put((Object)"space", (Object)jsonSpaceObject);
        jsonObject.put((Object)"body", (Object)jsonBodyObject);
        if (confluencePage.getAncestorId() != null) {
            JSONObject ancestor = new JSONObject();
            ancestor.put((Object)"type", (Object)"page");
            ancestor.put((Object)ID, (Object)confluencePage.getAncestorId());
            JSONArray ancestors = new JSONArray();
            ancestors.add((Object)ancestor);
            jsonObject.put((Object)"ancestors", (Object)ancestors);
        }
        return jsonObject;
    }

    public Long findAncestorId(String title) {
        LOG.info("Try to find ancestorId by title {}", (Object)title);
        ConfluencePage page = this.findPageByTitle(title);
        if (page != null) {
            return page.getId();
        }
        LOG.info("Try to use page home id as ancestorId", (Object)this.confluenceConfig.getSpaceKey());
        ConfluencePage spaceHome = this.findSpaceHomePage(this.confluenceConfig.getSpaceKey());
        return spaceHome.getId();
    }

    private static Long parsePageIdFromResponse(HttpEntity<String> responseEntity) {
        String responseJson = (String)responseEntity.getBody();
        JSONParser jsonParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        try {
            JSONObject response = (JSONObject)jsonParser.parse(responseJson, JSONObject.class);
            return Long.valueOf((String)response.get((Object)ID));
        }
        catch (ParseException e) {
            throw new ConfluenceException("Error Parsing JSON Response from Confluence!", e);
        }
    }

    private static String parseAttachmentIdFromResponse(HttpEntity<String> responseEntity) {
        String jsonBody = (String)responseEntity.getBody();
        try {
            return (String)JsonPath.read((String)jsonBody, (String)"$.results[0].id", (Predicate[])new Predicate[0]);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public String getAttachmentId(Long pageId, String attachmentFilename) {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)this.httpHeaders);
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content/{id}/child/attachment").queryParam("filename", new Object[]{attachmentFilename}).buildAndExpand(new Object[]{pageId}).toUri();
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.GET, requestEntity, String.class);
        LOG.debug("Response of creating attachment: {}", responseEntity.getBody());
        return ConfluenceService.parseAttachmentIdFromResponse((HttpEntity<String>)responseEntity);
    }

    public void createAttachment(Long pageId, String filePath) {
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content/{id}/child/attachment").buildAndExpand(new Object[]{pageId}).toUri();
        this.postAttachment(targetUrl, filePath);
    }

    public void updateAttachment(Long pageId, String attachmentId, String filePath) {
        URI targetUrl = UriComponentsBuilder.fromUriString((String)this.confluenceConfig.getRestApiUrl()).path("/content/{pageId}/child/attachment/{attachmentId}/data").buildAndExpand(new Object[]{pageId, attachmentId}).toUri();
        this.postAttachment(targetUrl, filePath);
    }

    public void postAttachment(URI targetUrl, String filePath) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"file", (Object)new FileSystemResource(filePath));
        HttpEntity multiValueMapHttpEntity = new HttpEntity((Object)body, (MultiValueMap)this.httpHeadersForAttachment);
        ResponseEntity responseEntity = this.restTemplate.exchange(targetUrl, HttpMethod.POST, multiValueMapHttpEntity, String.class);
        LOG.debug("Response of adding attachment: {}", responseEntity.getBody());
    }

    HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }
}

