/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.github.qwazer.markdown.confluence.core.ConfluenceConfig;
import com.github.qwazer.markdown.confluence.core.service.AttachmentService;
import com.github.qwazer.markdown.confluence.core.service.ConfluenceService;
import com.github.qwazer.markdown.confluence.core.service.FileReaderService;
import com.github.qwazer.markdown.confluence.core.service.MarkdownService;
import com.github.qwazer.markdown.confluence.core.service.PageService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MainService {
    private final FileReaderService fileReaderService;
    private MarkdownService markdownService;
    private final PageService pageService;
    private final AttachmentService attachmentService;
    private final ConfluenceService confluenceService;

    @Autowired
    public MainService(FileReaderService fileReaderService, MarkdownService markdownService, PageService pageService, AttachmentService attachmentService, ConfluenceService confluenceService) {
        this.fileReaderService = fileReaderService;
        this.markdownService = markdownService;
        this.pageService = pageService;
        this.attachmentService = attachmentService;
        this.confluenceService = confluenceService;
    }

    public void processAll(ConfluenceConfig confluenceConfig) throws IOException {
        this.confluenceService.setConfluenceConfig(confluenceConfig);
        if (confluenceConfig.getParseTimeout() != 2000L) {
            this.markdownService = new MarkdownService(confluenceConfig.getParseTimeout());
        }
        List<ConfluenceConfig.Page> orderedList = MainService.order(confluenceConfig.getPages());
        for (ConfluenceConfig.Page page : orderedList) {
            String markdownText = this.fileReaderService.readFile(page);
            String wikiText = this.markdownService.convertMarkdown2Wiki(markdownText, confluenceConfig);
            HashMap<String, Path> imageURIToFilePathMap = new HashMap<String, Path>();
            wikiText = this.processInlineImages(markdownText, wikiText, page.getSrcFile(), imageURIToFilePathMap);
            Long pageId = this.pageService.postWikiPageToConfluence(page, wikiText);
            for (Map.Entry entry : imageURIToFilePathMap.entrySet()) {
                this.attachmentService.postAttachmentToPage(pageId, (Path)entry.getValue());
            }
        }
    }

    private String processInlineImages(String markdownText, String wikiText, File srcFile, Map<String, Path> imageURIToFilePathMap) {
        String regex = "!\\[(.*)\\]\\(([^\\s]+)(.*)\\)";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(markdownText);
        String directory = srcFile.getParent();
        while (matcher.find()) {
            String uri = matcher.group(2);
            if (uri.startsWith("http") || uri.startsWith("/")) continue;
            Path path = uri.startsWith("/") ? Paths.get(uri, new String[0]) : Paths.get(directory + "/" + uri, new String[0]);
            imageURIToFilePathMap.put(uri, path);
        }
        String adjustedWikiTest = wikiText;
        for (Map.Entry<String, Path> entry : imageURIToFilePathMap.entrySet()) {
            adjustedWikiTest = adjustedWikiTest.replaceAll(entry.getKey(), entry.getValue().getFileName().toString());
        }
        return adjustedWikiTest;
    }

    public static List<ConfluenceConfig.Page> order(Collection<ConfluenceConfig.Page> pages) {
        if (pages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap group = new HashMap();
        ArrayList<ConfluenceConfig.Page> roots = new ArrayList<ConfluenceConfig.Page>();
        ArrayList<ConfluenceConfig.Page> childs = new ArrayList<ConfluenceConfig.Page>();
        for (ConfluenceConfig.Page page : pages) {
            if (MainService.hasParent(page, pages)) {
                childs.add(page);
                continue;
            }
            roots.add(page);
        }
        LinkedList<ConfluenceConfig.Page> linkedList = new LinkedList<ConfluenceConfig.Page>();
        linkedList.addAll(roots);
        linkedList.addAll(MainService.order(childs));
        return linkedList;
    }

    private static boolean hasParent(ConfluenceConfig.Page page, Collection<ConfluenceConfig.Page> pages) {
        boolean res = false;
        for (ConfluenceConfig.Page curr : pages) {
            if (!curr.getTitle().equals(page.getParentTitle())) continue;
            return true;
        }
        return res;
    }
}

