/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.spotlight.shape;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.RectF;
import android.view.animation.DecelerateInterpolator;
import com.takusemba.spotlight.shape.Shape;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%BG\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020$H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/takusemba/spotlight/shape/RoundedRectangle;", "Lcom/takusemba/spotlight/shape/Shape;", "height", "", "width", "radius", "type", "Lcom/takusemba/spotlight/shape/Shape$ShapeType;", "duration", "", "interpolator", "Landroid/animation/TimeInterpolator;", "clickable", "", "(FFFLcom/takusemba/spotlight/shape/Shape$ShapeType;JLandroid/animation/TimeInterpolator;Z)V", "getClickable", "()Z", "setClickable", "(Z)V", "getDuration", "()J", "getHeight", "()F", "getInterpolator", "()Landroid/animation/TimeInterpolator;", "getType", "()Lcom/takusemba/spotlight/shape/Shape$ShapeType;", "getWidth", "draw", "", "canvas", "Landroid/graphics/Canvas;", "point", "Landroid/graphics/PointF;", "value", "paint", "Landroid/graphics/Paint;", "Companion", "spotlight_release"})
public final class RoundedRectangle
implements Shape {
    private final float height;
    private final float width;
    private final float radius;
    @NotNull
    private final Shape.ShapeType type;
    private final long duration;
    @NotNull
    private final TimeInterpolator interpolator;
    private boolean clickable;
    private static final long DEFAULT_DURATION;
    @NotNull
    private static final DecelerateInterpolator DEFAULT_INTERPOLATOR;
    @NotNull
    public static final Companion Companion;

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull PointF point, float value, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        float halfWidth = this.getWidth() / (float)2 * value;
        float halfHeight = this.getHeight() / (float)2 * value;
        float left = point.x - halfWidth;
        float top = point.y - halfHeight;
        float right = point.x + halfWidth;
        float bottom = point.y + halfHeight;
        RectF rect = new RectF(left, top, right, bottom);
        canvas.drawRoundRect(rect, this.radius, this.radius, paint);
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    @NotNull
    public Shape.ShapeType getType() {
        return this.type;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public TimeInterpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public boolean getClickable() {
        return this.clickable;
    }

    @Override
    public void setClickable(boolean bl) {
        this.clickable = bl;
    }

    @JvmOverloads
    public RoundedRectangle(float height, float width, float radius, @NotNull Shape.ShapeType type, long duration, @NotNull TimeInterpolator interpolator, boolean clickable) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.height = height;
        this.width = width;
        this.radius = radius;
        this.type = type;
        this.duration = duration;
        this.interpolator = interpolator;
        this.clickable = clickable;
    }

    public /* synthetic */ RoundedRectangle(float f, float f2, float f3, Shape.ShapeType shapeType, long l, TimeInterpolator timeInterpolator, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            shapeType = Shape.ShapeType.ROUNDED_RECTANGLE;
        }
        if ((n & 0x10) != 0) {
            l = DEFAULT_DURATION;
        }
        if ((n & 0x20) != 0) {
            timeInterpolator = (TimeInterpolator)DEFAULT_INTERPOLATOR;
        }
        if ((n & 0x40) != 0) {
            bl = true;
        }
        this(f, f2, f3, shapeType, l, timeInterpolator, bl);
    }

    @JvmOverloads
    public RoundedRectangle(float height, float width, float radius, @NotNull Shape.ShapeType type, long duration, @NotNull TimeInterpolator interpolator) {
        this(height, width, radius, type, duration, interpolator, false, 64, null);
    }

    @JvmOverloads
    public RoundedRectangle(float height, float width, float radius, @NotNull Shape.ShapeType type, long duration) {
        this(height, width, radius, type, duration, null, false, 96, null);
    }

    @JvmOverloads
    public RoundedRectangle(float height, float width, float radius, @NotNull Shape.ShapeType type) {
        this(height, width, radius, type, 0L, null, false, 112, null);
    }

    @JvmOverloads
    public RoundedRectangle(float height, float width, float radius) {
        this(height, width, radius, null, 0L, null, false, 120, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_DURATION = TimeUnit.MILLISECONDS.toMillis(500L);
        DEFAULT_INTERPOLATOR = new DecelerateInterpolator(2.0f);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/takusemba/spotlight/shape/RoundedRectangle$Companion;", "", "()V", "DEFAULT_DURATION", "", "getDEFAULT_DURATION", "()J", "DEFAULT_INTERPOLATOR", "Landroid/view/animation/DecelerateInterpolator;", "getDEFAULT_INTERPOLATOR", "()Landroid/view/animation/DecelerateInterpolator;", "spotlight_release"})
    public static final class Companion {
        public final long getDEFAULT_DURATION() {
            return DEFAULT_DURATION;
        }

        @NotNull
        public final DecelerateInterpolator getDEFAULT_INTERPOLATOR() {
            return DEFAULT_INTERPOLATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

