/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.spotlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import com.takusemba.spotlight.OverlayAlignment;
import com.takusemba.spotlight.SpotlightView;
import com.takusemba.spotlight.SpotlightView$WhenMappings;
import com.takusemba.spotlight.Target;
import com.takusemba.spotlight.shape.Circle;
import com.takusemba.spotlight.shape.RoundedRectangle;
import com.takusemba.spotlight.shape.Shape;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*H\u0014J\u0012\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u001e\u0010/\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u000e\u00100\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0019\u0010\rR\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/takusemba/spotlight/SpotlightView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "backgroundColor", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "backgroundPaint", "Landroid/graphics/Paint;", "getBackgroundPaint", "()Landroid/graphics/Paint;", "backgroundPaint$delegate", "Lkotlin/Lazy;", "effectAnimator", "Landroid/animation/ValueAnimator;", "effectPaint", "getEffectPaint", "effectPaint$delegate", "invalidator", "Landroid/animation/ValueAnimator$AnimatorUpdateListener;", "shapeAnimator", "shapePaint", "getShapePaint", "shapePaint$delegate", "space16Dp", "target", "Lcom/takusemba/spotlight/Target;", "cleanup", "", "finishSpotlight", "duration", "", "interpolator", "Landroid/animation/TimeInterpolator;", "listener", "Landroid/animation/Animator$AnimatorListener;", "finishTarget", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "startSpotlight", "startTarget", "spotlight_release"})
public final class SpotlightView
extends FrameLayout {
    private final Lazy backgroundPaint$delegate;
    private final Lazy shapePaint$delegate;
    private final Lazy effectPaint$delegate;
    private final ValueAnimator.AnimatorUpdateListener invalidator;
    private ValueAnimator shapeAnimator;
    private ValueAnimator effectAnimator;
    private Target target;
    private final int space16Dp;

    private final Paint getBackgroundPaint() {
        Lazy lazy = this.backgroundPaint$delegate;
        SpotlightView spotlightView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Paint)lazy.getValue();
    }

    private final Paint getShapePaint() {
        Lazy lazy = this.shapePaint$delegate;
        SpotlightView spotlightView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Paint)lazy.getValue();
    }

    private final Paint getEffectPaint() {
        Lazy lazy = this.effectPaint$delegate;
        SpotlightView spotlightView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Paint)lazy.getValue();
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        MotionEvent motionEvent = event;
        if (motionEvent != null) {
            int n = motionEvent.getAction();
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (it == 0) {
                Object object;
                Object object2 = this.target;
                if ((object2 != null && (object2 = ((Target)object2).getShape()) != null ? object2.getType() : null) == Shape.ShapeType.CIRCLE) {
                    Float yAnchor;
                    Target target = this.target;
                    Shape shape = target != null ? target.getShape() : null;
                    if (shape == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.takusemba.spotlight.shape.Circle");
                    }
                    Circle shape2 = (Circle)shape;
                    float radius = shape2.getRadius();
                    Target target2 = this.target;
                    Float xAnchor = target2 != null && (target2 = target2.getAnchor()) != null ? Float.valueOf(((PointF)target2).x) : null;
                    Target target3 = this.target;
                    Float f = target3 != null && (target3 = target3.getAnchor()) != null ? Float.valueOf(((PointF)target3).y) : (yAnchor = null);
                    if (xAnchor != null && yAnchor != null) {
                        float leftX = xAnchor.floatValue() - radius / (float)2;
                        float rightX = xAnchor.floatValue() + radius / (float)2;
                        float topY = yAnchor.floatValue() - radius / (float)2;
                        float bottomY = yAnchor.floatValue() + radius / (float)2;
                        float f2 = x;
                        if (f2 >= leftX && f2 <= rightX && (f2 = (float)y) >= topY && f2 <= bottomY) {
                            return false;
                        }
                    }
                }
                if (((object = this.target) != null && (object = ((Target)object).getShape()) != null ? object.getType() : null) == Shape.ShapeType.ROUNDED_RECTANGLE) {
                    ValueAnimator valueAnimator = this.shapeAnimator;
                    Object object3 = valueAnimator != null ? valueAnimator.getAnimatedValue() : null;
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    float value = ((Float)object3).floatValue();
                    Target target = this.target;
                    if (target != null && (target = target.getAnchor()) != null) {
                        Target target4 = target;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Target it2 = target4;
                        boolean bl6 = false;
                        Target target5 = this.target;
                        Shape shape = target5 != null ? target5.getShape() : null;
                        if (shape == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.takusemba.spotlight.shape.RoundedRectangle");
                        }
                        RoundedRectangle shape3 = (RoundedRectangle)shape;
                        float halfWidth = shape3.getWidth() / (float)2 * value;
                        float halfHeight = shape3.getHeight() / (float)2 * value;
                        float left = ((PointF)it2).x - halfWidth;
                        float top = ((PointF)it2).y - halfHeight;
                        float right = ((PointF)it2).x + halfWidth;
                        float bottom = ((PointF)it2).y + halfHeight;
                        float f = x;
                        if (f >= left && f <= right && (f = (float)y) >= top && f <= bottom) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.getBackgroundPaint());
        Target currentTarget = this.target;
        ValueAnimator currentShapeAnimator = this.shapeAnimator;
        ValueAnimator currentEffectAnimator = this.effectAnimator;
        if (currentTarget != null && currentEffectAnimator != null && currentShapeAnimator != null && !currentShapeAnimator.isRunning()) {
            Object object = currentEffectAnimator.getAnimatedValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            currentTarget.getEffect().draw(canvas, currentTarget.getAnchor(), ((Float)object).floatValue(), this.getEffectPaint());
        }
        if (currentTarget != null && currentShapeAnimator != null) {
            Object object = currentShapeAnimator.getAnimatedValue();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            currentTarget.getShape().draw(canvas, currentTarget.getAnchor(), ((Float)object).floatValue(), this.getShapePaint());
        }
    }

    public final void startSpotlight(long duration, @NotNull TimeInterpolator interpolator, @NotNull Animator.AnimatorListener listener) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        boolean bl = false;
        boolean bl2 = false;
        ObjectAnimator $this$apply = objectAnimator;
        boolean bl3 = false;
        $this$apply.setDuration(duration);
        $this$apply.setInterpolator(interpolator);
        $this$apply.addListener(listener);
        ObjectAnimator objectAnimator2 = objectAnimator;
        objectAnimator2.start();
    }

    public final void finishSpotlight(long duration, @NotNull TimeInterpolator interpolator, @NotNull Animator.AnimatorListener listener) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        boolean bl = false;
        boolean bl2 = false;
        ObjectAnimator $this$apply = objectAnimator;
        boolean bl3 = false;
        $this$apply.setDuration(duration);
        $this$apply.setInterpolator(interpolator);
        $this$apply.addListener(listener);
        ObjectAnimator objectAnimator2 = objectAnimator;
        objectAnimator2.start();
    }

    public final void startTarget(@NotNull Target target) {
        block21: {
            Target $this$apply;
            View overlayView;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.removeAllViews();
            View view = overlayView = target.getOverlay();
            if (view != null) {
                view.measure(0, 0);
            }
            float shapeWidth = target.getShape().getWidth();
            float shapeHeight = target.getShape().getHeight();
            View view2 = overlayView;
            if (view2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            int overlayWidth = ((ViewGroup)view2).getMeasuredWidth();
            int overlayHeight = ((ViewGroup)overlayView).getMeasuredHeight();
            float shapeXStart = target.getAnchor().x - shapeWidth / (float)2;
            float shapeYStart = target.getAnchor().y - shapeHeight / (float)2;
            float shapeXEnd = shapeXStart + shapeWidth;
            float shapeYEnd = shapeYStart + shapeHeight;
            float overlayX = shapeXStart;
            float overlayY = shapeYStart;
            switch (SpotlightView$WhenMappings.$EnumSwitchMapping$0[target.getOverlayAlignment().ordinal()]) {
                case 1: {
                    this.addView(target.getOverlay(), -1, -1);
                    break;
                }
                case 2: {
                    overlayX = shapeXStart + target.getOffset().x;
                    overlayY = shapeYStart - (float)overlayHeight - target.getVerticalMargin() + target.getOffset().y;
                    break;
                }
                case 3: {
                    overlayX = target.getAnchor().x - (float)(overlayWidth / 2) + target.getOffset().x;
                    overlayY = shapeYStart - (float)overlayHeight - target.getVerticalMargin() + target.getOffset().y;
                    break;
                }
                case 4: {
                    overlayX = shapeXEnd - (float)overlayWidth + target.getOffset().x;
                    overlayY = shapeYStart - (float)overlayHeight - target.getVerticalMargin() + target.getOffset().y;
                    break;
                }
                case 5: {
                    overlayX = shapeXStart + target.getOffset().x;
                    overlayY = shapeYEnd + target.getVerticalMargin() + target.getOffset().y;
                    break;
                }
                case 6: {
                    overlayX = target.getAnchor().x - (float)(overlayWidth / 2) + target.getOffset().x;
                    overlayY = shapeYEnd + target.getVerticalMargin() + target.getOffset().y;
                    break;
                }
                case 7: {
                    overlayX = shapeXEnd - (float)overlayWidth + target.getOffset().x;
                    overlayY = shapeYEnd + target.getVerticalMargin() + target.getOffset().y;
                    break;
                }
                case 8: {
                    ((ViewGroup)overlayView).setY(shapeYEnd + target.getVerticalMargin() + target.getOffset().y);
                    ((ViewGroup)overlayView).setX(target.getOffset().x);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
                    layoutParams.setMargins(this.space16Dp, 0, this.space16Dp, 0);
                    this.addView(overlayView, (ViewGroup.LayoutParams)layoutParams);
                    break;
                }
                case 9: {
                    ((ViewGroup)overlayView).setY(shapeYStart - (float)overlayHeight - target.getVerticalMargin() + target.getOffset().y);
                    ((ViewGroup)overlayView).setX(target.getOffset().x);
                    FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
                    layoutParams.setMargins(this.space16Dp, 0, this.space16Dp, 0);
                    this.addView(overlayView, (ViewGroup.LayoutParams)layoutParams);
                    break;
                }
            }
            if (target.getOverlayAlignment() != OverlayAlignment.DEFAULT && target.getOverlayAlignment() != OverlayAlignment.DEFAULT_BOTTOM_CENTER && target.getOverlayAlignment() != OverlayAlignment.DEFAULT_TOP_CENTER) {
                ((ViewGroup)overlayView).setX(overlayX);
                ((ViewGroup)overlayView).setY(overlayY);
                this.addView(overlayView);
            }
            Target target2 = target;
            boolean bl = false;
            boolean bl2 = false;
            Target target3 = target2;
            SpotlightView spotlightView = this;
            boolean bl3 = false;
            int[] location = new int[2];
            this.getLocationInWindow(location);
            PointF offset = new PointF((float)location[0], (float)location[1]);
            $this$apply.getAnchor().offset(-offset.x, -offset.y);
            Unit unit = Unit.INSTANCE;
            spotlightView.target = target2;
            ValueAnimator valueAnimator = this.shapeAnimator;
            if (valueAnimator != null) {
                valueAnimator.removeAllListeners();
            }
            ValueAnimator valueAnimator2 = this.shapeAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllUpdateListeners();
            }
            ValueAnimator valueAnimator3 = this.shapeAnimator;
            if (valueAnimator3 != null) {
                valueAnimator3.cancel();
            }
            target2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            bl = false;
            bl2 = false;
            $this$apply = target2;
            spotlightView = this;
            boolean bl4 = false;
            $this$apply.setDuration(target.getShape().getDuration());
            $this$apply.setInterpolator(target.getShape().getInterpolator());
            $this$apply.addUpdateListener(this.invalidator);
            $this$apply.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((ValueAnimator)$this$apply){
                final /* synthetic */ ValueAnimator $this_apply;

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$this_apply.removeAllListeners();
                    this.$this_apply.removeAllUpdateListeners();
                }

                public void onAnimationCancel(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$this_apply.removeAllListeners();
                    this.$this_apply.removeAllUpdateListeners();
                }
                {
                    this.$this_apply = $receiver;
                }
            });
            unit = Unit.INSTANCE;
            spotlightView.shapeAnimator = target2;
            ValueAnimator valueAnimator4 = this.effectAnimator;
            if (valueAnimator4 != null) {
                valueAnimator4.removeAllListeners();
            }
            ValueAnimator valueAnimator5 = this.effectAnimator;
            if (valueAnimator5 != null) {
                valueAnimator5.removeAllUpdateListeners();
            }
            ValueAnimator valueAnimator6 = this.effectAnimator;
            if (valueAnimator6 != null) {
                valueAnimator6.cancel();
            }
            target2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            bl = false;
            bl2 = false;
            $this$apply = target2;
            spotlightView = this;
            boolean bl5 = false;
            $this$apply.setStartDelay(target.getShape().getDuration());
            $this$apply.setDuration(target.getEffect().getDuration());
            $this$apply.setInterpolator(target.getEffect().getInterpolator());
            $this$apply.setRepeatMode(target.getEffect().getRepeatMode());
            $this$apply.setRepeatCount(-1);
            $this$apply.addUpdateListener(this.invalidator);
            $this$apply.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((ValueAnimator)$this$apply){
                final /* synthetic */ ValueAnimator $this_apply;

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$this_apply.removeAllListeners();
                    this.$this_apply.removeAllUpdateListeners();
                }

                public void onAnimationCancel(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$this_apply.removeAllListeners();
                    this.$this_apply.removeAllUpdateListeners();
                }
                {
                    this.$this_apply = $receiver;
                }
            });
            unit = Unit.INSTANCE;
            spotlightView.effectAnimator = target2;
            ValueAnimator valueAnimator7 = this.shapeAnimator;
            if (valueAnimator7 != null) {
                valueAnimator7.start();
            }
            ValueAnimator valueAnimator8 = this.effectAnimator;
            if (valueAnimator8 == null) break block21;
            valueAnimator8.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void finishTarget(@NotNull Animator.AnimatorListener listener) {
        block9: {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Target target = this.target;
            if (target == null) {
                return;
            }
            Target currentTarget = target;
            Object object = this.shapeAnimator;
            if (object == null || (object = object.getAnimatedValue()) == null) {
                return;
            }
            Object currentAnimatedValue = object;
            ValueAnimator valueAnimator = this.shapeAnimator;
            if (valueAnimator != null) {
                valueAnimator.removeAllListeners();
            }
            ValueAnimator valueAnimator2 = this.shapeAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.removeAllUpdateListeners();
            }
            ValueAnimator valueAnimator3 = this.shapeAnimator;
            if (valueAnimator3 != null) {
                valueAnimator3.cancel();
            }
            float[] fArray = new float[2];
            Object object2 = currentAnimatedValue;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
            }
            fArray[0] = ((Float)object2).floatValue();
            fArray[1] = 0.0f;
            ValueAnimator valueAnimator4 = ValueAnimator.ofFloat((float[])fArray);
            boolean bl = false;
            boolean bl2 = false;
            ValueAnimator valueAnimator5 = valueAnimator4;
            SpotlightView spotlightView = this;
            boolean bl3 = false;
            $this$apply.setDuration(currentTarget.getShape().getDuration());
            $this$apply.setInterpolator(currentTarget.getShape().getInterpolator());
            $this$apply.addUpdateListener(this.invalidator);
            $this$apply.addListener(listener);
            $this$apply.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((ValueAnimator)$this$apply){
                final /* synthetic */ ValueAnimator $this_apply;

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$this_apply.removeAllListeners();
                    this.$this_apply.removeAllUpdateListeners();
                }

                public void onAnimationCancel(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    this.$this_apply.removeAllListeners();
                    this.$this_apply.removeAllUpdateListeners();
                }
                {
                    this.$this_apply = $receiver;
                }
            });
            Unit unit = Unit.INSTANCE;
            spotlightView.shapeAnimator = valueAnimator4;
            ValueAnimator valueAnimator6 = this.effectAnimator;
            if (valueAnimator6 != null) {
                valueAnimator6.removeAllListeners();
            }
            ValueAnimator valueAnimator7 = this.effectAnimator;
            if (valueAnimator7 != null) {
                valueAnimator7.removeAllUpdateListeners();
            }
            ValueAnimator valueAnimator8 = this.effectAnimator;
            if (valueAnimator8 != null) {
                valueAnimator8.cancel();
            }
            this.effectAnimator = null;
            ValueAnimator valueAnimator9 = this.shapeAnimator;
            if (valueAnimator9 == null) break block9;
            valueAnimator9.start();
        }
    }

    public final void cleanup() {
        ValueAnimator valueAnimator = this.effectAnimator;
        if (valueAnimator != null) {
            valueAnimator.removeAllListeners();
        }
        ValueAnimator valueAnimator2 = this.effectAnimator;
        if (valueAnimator2 != null) {
            valueAnimator2.removeAllUpdateListeners();
        }
        ValueAnimator valueAnimator3 = this.effectAnimator;
        if (valueAnimator3 != null) {
            valueAnimator3.cancel();
        }
        this.effectAnimator = null;
        ValueAnimator valueAnimator4 = this.shapeAnimator;
        if (valueAnimator4 != null) {
            valueAnimator4.removeAllListeners();
        }
        ValueAnimator valueAnimator5 = this.shapeAnimator;
        if (valueAnimator5 != null) {
            valueAnimator5.removeAllUpdateListeners();
        }
        ValueAnimator valueAnimator6 = this.shapeAnimator;
        if (valueAnimator6 != null) {
            valueAnimator6.cancel();
        }
        this.shapeAnimator = null;
        this.removeAllViews();
    }

    @JvmOverloads
    public SpotlightView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @ColorInt int backgroundColor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.backgroundPaint$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Paint>(backgroundColor){
            final /* synthetic */ int $backgroundColor;

            @NotNull
            public final Paint invoke() {
                Paint paint = new Paint();
                boolean bl = false;
                boolean bl2 = false;
                Paint $this$apply = paint;
                boolean bl3 = false;
                $this$apply.setColor(this.$backgroundColor);
                return paint;
            }
            {
                this.$backgroundColor = n;
                super(0);
            }
        }));
        this.shapePaint$delegate = LazyKt.lazy((Function0)shapePaint.2.INSTANCE);
        this.effectPaint$delegate = LazyKt.lazy((Function0)effectPaint.2.INSTANCE);
        this.invalidator = new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SpotlightView this$0;

            public final void onAnimationUpdate(ValueAnimator it) {
                this.this$0.invalidate();
            }
            {
                this.this$0 = spotlightView;
            }
        };
        Resources resources = this.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        this.space16Dp = (int)TypedValue.applyDimension((int)1, (float)16.0f, (DisplayMetrics)resources.getDisplayMetrics());
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
    }

    public /* synthetic */ SpotlightView(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public SpotlightView(@NotNull Context context, @Nullable AttributeSet attrs, @ColorInt int backgroundColor) {
        this(context, attrs, 0, backgroundColor, 4, null);
    }

    @JvmOverloads
    public SpotlightView(@NotNull Context context, @ColorInt int backgroundColor) {
        this(context, null, 0, backgroundColor, 6, null);
    }
}

