/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.spotlight;

import android.graphics.PointF;
import android.view.View;
import com.takusemba.spotlight.OnTargetListener;
import com.takusemba.spotlight.OverlayAlignment;
import com.takusemba.spotlight.effet.Effect;
import com.takusemba.spotlight.effet.EmptyEffect;
import com.takusemba.spotlight.shape.Circle;
import com.takusemba.spotlight.shape.Shape;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0011\u0018\u00002\u00020\u0001:\u0001\u001fBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/takusemba/spotlight/Target;", "", "anchor", "Landroid/graphics/PointF;", "shape", "Lcom/takusemba/spotlight/shape/Shape;", "effect", "Lcom/takusemba/spotlight/effet/Effect;", "overlay", "Landroid/view/View;", "listener", "Lcom/takusemba/spotlight/OnTargetListener;", "overlayAlignment", "Lcom/takusemba/spotlight/OverlayAlignment;", "verticalMargin", "", "(Landroid/graphics/PointF;Lcom/takusemba/spotlight/shape/Shape;Lcom/takusemba/spotlight/effet/Effect;Landroid/view/View;Lcom/takusemba/spotlight/OnTargetListener;Lcom/takusemba/spotlight/OverlayAlignment;F)V", "getAnchor", "()Landroid/graphics/PointF;", "getEffect", "()Lcom/takusemba/spotlight/effet/Effect;", "getListener", "()Lcom/takusemba/spotlight/OnTargetListener;", "getOverlay", "()Landroid/view/View;", "getOverlayAlignment", "()Lcom/takusemba/spotlight/OverlayAlignment;", "getShape", "()Lcom/takusemba/spotlight/shape/Shape;", "getVerticalMargin", "()F", "Builder", "spotlight_release"})
public final class Target {
    @NotNull
    private final PointF anchor;
    @NotNull
    private final Shape shape;
    @NotNull
    private final Effect effect;
    @Nullable
    private final View overlay;
    @Nullable
    private final OnTargetListener listener;
    @NotNull
    private final OverlayAlignment overlayAlignment;
    private final float verticalMargin;

    @NotNull
    public final PointF getAnchor() {
        return this.anchor;
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    @NotNull
    public final Effect getEffect() {
        return this.effect;
    }

    @Nullable
    public final View getOverlay() {
        return this.overlay;
    }

    @Nullable
    public final OnTargetListener getListener() {
        return this.listener;
    }

    @NotNull
    public final OverlayAlignment getOverlayAlignment() {
        return this.overlayAlignment;
    }

    public final float getVerticalMargin() {
        return this.verticalMargin;
    }

    public Target(@NotNull PointF anchor, @NotNull Shape shape, @NotNull Effect effect, @Nullable View overlay, @Nullable OnTargetListener listener, @NotNull OverlayAlignment overlayAlignment, float verticalMargin) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        Intrinsics.checkNotNullParameter((Object)((Object)overlayAlignment), (String)"overlayAlignment");
        this.anchor = anchor;
        this.shape = shape;
        this.effect = effect;
        this.overlay = overlay;
        this.listener = listener;
        this.overlayAlignment = overlayAlignment;
        this.verticalMargin = verticalMargin;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010J&\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/takusemba/spotlight/Target$Builder;", "", "()V", "anchor", "Landroid/graphics/PointF;", "effect", "Lcom/takusemba/spotlight/effet/Effect;", "listener", "Lcom/takusemba/spotlight/OnTargetListener;", "overlay", "Landroid/view/View;", "overlayAlignment", "Lcom/takusemba/spotlight/OverlayAlignment;", "shape", "Lcom/takusemba/spotlight/shape/Shape;", "verticalMargin", "", "build", "Lcom/takusemba/spotlight/Target;", "getXAndY", "Lkotlin/Pair;", "view", "setAnchor", "x", "y", "setAnchors", "view1", "view2", "xOffset", "yOffset", "setEffect", "setOnTargetListener", "setOverlay", "setOverlayAlignment", "setShape", "setVerticalMargin", "Companion", "spotlight_release"})
    public static final class Builder {
        private PointF anchor = DEFAULT_ANCHOR;
        private Shape shape = DEFAULT_SHAPE;
        private Effect effect = DEFAULT_EFFECT;
        private View overlay;
        private OnTargetListener listener;
        private OverlayAlignment overlayAlignment = OverlayAlignment.DEFAULT;
        private float verticalMargin;
        private static final PointF DEFAULT_ANCHOR;
        private static final Circle DEFAULT_SHAPE;
        private static final EmptyEffect DEFAULT_EFFECT;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final Builder setAnchor(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            int[] location = new int[2];
            view.getLocationInWindow(location);
            float x = (float)location[0] + (float)view.getWidth() / 2.0f;
            float y = (float)location[1] + (float)view.getHeight() / 2.0f;
            $this$apply.setAnchor(x, y);
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder setAnchors(@NotNull View view1, @NotNull View view2, float xOffset, float yOffset) {
            void x2;
            void x1;
            Intrinsics.checkNotNullParameter((Object)view1, (String)"view1");
            Intrinsics.checkNotNullParameter((Object)view2, (String)"view2");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Pair<Float, Float> pair = $this$apply.getXAndY(view1);
            float f = ((Number)pair.component1()).floatValue();
            float y1 = ((Number)pair.component2()).floatValue();
            Pair<Float, Float> pair2 = $this$apply.getXAndY(view2);
            float f2 = ((Number)pair2.component1()).floatValue();
            float y2 = ((Number)pair2.component2()).floatValue();
            $this$apply.setAnchor((float)((x1 + x2) / (float)2 - xOffset), (y1 + y2) / (float)2 - yOffset);
            return builder;
        }

        private final Pair<Float, Float> getXAndY(View view) {
            int[] location1 = new int[2];
            view.getLocationInWindow(location1);
            float x = (float)location1[0] + (float)view.getWidth() / 2.0f;
            float y = (float)location1[1] + (float)view.getHeight() / 2.0f;
            return new Pair((Object)Float.valueOf(x), (Object)Float.valueOf(y));
        }

        @NotNull
        public final Builder setAnchor(float x, float y) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.setAnchor(new PointF(x, y));
            return builder;
        }

        @NotNull
        public final Builder setAnchor(@NotNull PointF anchor) {
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.anchor = anchor;
            return builder;
        }

        @NotNull
        public final Builder setShape(@NotNull Shape shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.shape = shape;
            return builder;
        }

        @NotNull
        public final Builder setEffect(@NotNull Effect effect) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.effect = effect;
            return builder;
        }

        @NotNull
        public final Builder setOverlay(@NotNull View overlay) {
            Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlay = overlay;
            return builder;
        }

        @NotNull
        public final Builder setOverlayAlignment(@NotNull OverlayAlignment overlayAlignment) {
            Intrinsics.checkNotNullParameter((Object)((Object)overlayAlignment), (String)"overlayAlignment");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.overlayAlignment = overlayAlignment;
            return builder;
        }

        @NotNull
        public final Builder setVerticalMargin(float verticalMargin) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.verticalMargin = verticalMargin;
            return builder;
        }

        @NotNull
        public final Builder setOnTargetListener(@NotNull OnTargetListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.listener = listener;
            return builder;
        }

        @NotNull
        public final Target build() {
            return new Target(this.anchor, this.shape, this.effect, this.overlay, this.listener, this.overlayAlignment, this.verticalMargin);
        }

        static {
            Companion = new Companion(null);
            DEFAULT_ANCHOR = new PointF(0.0f, 0.0f);
            DEFAULT_SHAPE = new Circle(100.0f, null, 0L, null, 0.0f, 0.0f, 62, null);
            DEFAULT_EFFECT = new EmptyEffect(0L, null, 0, 7, null);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/takusemba/spotlight/Target$Builder$Companion;", "", "()V", "DEFAULT_ANCHOR", "Landroid/graphics/PointF;", "DEFAULT_EFFECT", "Lcom/takusemba/spotlight/effet/EmptyEffect;", "DEFAULT_SHAPE", "Lcom/takusemba/spotlight/shape/Circle;", "spotlight_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

