/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.spotlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import com.takusemba.spotlight.OnSpotlightListener;
import com.takusemba.spotlight.OnTargetListener;
import com.takusemba.spotlight.SpotlightView;
import com.takusemba.spotlight.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eB?\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0014J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0011J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\u0006\u0010\u001b\u001a\u00020\u0014J\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/takusemba/spotlight/Spotlight;", "", "spotlight", "Lcom/takusemba/spotlight/SpotlightView;", "targets", "", "Lcom/takusemba/spotlight/Target;", "duration", "", "interpolator", "Landroid/animation/TimeInterpolator;", "container", "Landroid/view/ViewGroup;", "spotlightListener", "Lcom/takusemba/spotlight/OnSpotlightListener;", "(Lcom/takusemba/spotlight/SpotlightView;[Lcom/takusemba/spotlight/Target;JLandroid/animation/TimeInterpolator;Landroid/view/ViewGroup;Lcom/takusemba/spotlight/OnSpotlightListener;)V", "currentIndex", "", "[Lcom/takusemba/spotlight/Target;", "finish", "", "finishSpotlight", "next", "previous", "show", "index", "showTarget", "start", "startSpotlight", "Builder", "Companion", "spotlight_release"})
public final class Spotlight {
    private int currentIndex;
    private final SpotlightView spotlight;
    private final Target[] targets;
    private final long duration;
    private final TimeInterpolator interpolator;
    private final ViewGroup container;
    private final OnSpotlightListener spotlightListener;
    private static final int NO_POSITION = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void start() {
        this.startSpotlight();
    }

    public final void show(int index) {
        this.showTarget(index);
    }

    public final void next() {
        this.showTarget(this.currentIndex + 1);
    }

    public final void previous() {
        this.showTarget(this.currentIndex - 1);
    }

    public final void finish() {
        this.finishSpotlight();
    }

    private final void startSpotlight() {
        this.spotlight.startSpotlight(this.duration, this.interpolator, (Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ Spotlight this$0;

            public void onAnimationStart(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    OnSpotlightListener onSpotlightListener = Spotlight.access$getSpotlightListener$p(this.this$0);
                    if (onSpotlightListener == null) break block0;
                    onSpotlightListener.onStarted();
                }
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                Spotlight.access$showTarget(this.this$0, 0);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void showTarget(int index) {
        if (this.currentIndex == -1) {
            Target target = this.targets[index];
            this.currentIndex = index;
            this.spotlight.startTarget(target);
            OnTargetListener onTargetListener = target.getListener();
            if (onTargetListener != null) {
                onTargetListener.onStarted();
            }
        } else {
            this.spotlight.finishTarget((Animator.AnimatorListener)new AnimatorListenerAdapter(this, index){
                final /* synthetic */ Spotlight this$0;
                final /* synthetic */ int $index;

                public void onAnimationEnd(@NotNull Animator animation) {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    int previousIndex = Spotlight.access$getCurrentIndex$p(this.this$0);
                    Target previousTarget = Spotlight.access$getTargets$p(this.this$0)[previousIndex];
                    OnTargetListener onTargetListener = previousTarget.getListener();
                    if (onTargetListener != null) {
                        onTargetListener.onEnded();
                    }
                    if (this.$index < Spotlight.access$getTargets$p(this.this$0).length) {
                        Target target = Spotlight.access$getTargets$p(this.this$0)[this.$index];
                        Spotlight.access$setCurrentIndex$p(this.this$0, this.$index);
                        Spotlight.access$getSpotlight$p(this.this$0).startTarget(target);
                        OnTargetListener onTargetListener2 = target.getListener();
                        if (onTargetListener2 != null) {
                            onTargetListener2.onStarted();
                        }
                    } else {
                        Spotlight.access$finishSpotlight(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$index = $captured_local_variable$1;
                }
            });
        }
    }

    private final void finishSpotlight() {
        this.spotlight.finishSpotlight(this.duration, this.interpolator, (Animator.AnimatorListener)new AnimatorListenerAdapter(this){
            final /* synthetic */ Spotlight this$0;

            public void onAnimationEnd(@NotNull Animator animation) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    Spotlight.access$getSpotlight$p(this.this$0).cleanup();
                    Spotlight.access$getContainer$p(this.this$0).removeView((View)Spotlight.access$getSpotlight$p(this.this$0));
                    OnSpotlightListener onSpotlightListener = Spotlight.access$getSpotlightListener$p(this.this$0);
                    if (onSpotlightListener == null) break block0;
                    onSpotlightListener.onEnded();
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private Spotlight(SpotlightView spotlight, Target[] targets, long duration, TimeInterpolator interpolator, ViewGroup container, OnSpotlightListener spotlightListener) {
        this.spotlight = spotlight;
        this.targets = targets;
        this.duration = duration;
        this.interpolator = interpolator;
        this.container = container;
        this.spotlightListener = spotlightListener;
        this.currentIndex = -1;
        this.container.addView((View)this.spotlight, -1, -1);
    }

    public /* synthetic */ Spotlight(SpotlightView spotlight, Target[] targets, long duration, TimeInterpolator interpolator, ViewGroup container, OnSpotlightListener spotlightListener, DefaultConstructorMarker $constructor_marker) {
        this(spotlight, targets, duration, interpolator, container, spotlightListener);
    }

    public static final /* synthetic */ OnSpotlightListener access$getSpotlightListener$p(Spotlight $this) {
        return $this.spotlightListener;
    }

    public static final /* synthetic */ void access$showTarget(Spotlight $this, int index) {
        $this.showTarget(index);
    }

    public static final /* synthetic */ int access$getCurrentIndex$p(Spotlight $this) {
        return $this.currentIndex;
    }

    public static final /* synthetic */ void access$setCurrentIndex$p(Spotlight $this, int n) {
        $this.currentIndex = n;
    }

    public static final /* synthetic */ Target[] access$getTargets$p(Spotlight $this) {
        return $this.targets;
    }

    public static final /* synthetic */ SpotlightView access$getSpotlight$p(Spotlight $this) {
        return $this.spotlight;
    }

    public static final /* synthetic */ void access$finishSpotlight(Spotlight $this) {
        $this.finishSpotlight();
    }

    public static final /* synthetic */ ViewGroup access$getContainer$p(Spotlight $this) {
        return $this.container;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0017\u001a\u00020\u00002\b\b\u0001\u0010\u0018\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u001f\u0010\u001c\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010\u001c\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/takusemba/spotlight/Spotlight$Builder;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "backgroundColor", "", "container", "Landroid/view/ViewGroup;", "duration", "", "interpolator", "Landroid/animation/TimeInterpolator;", "listener", "Lcom/takusemba/spotlight/OnSpotlightListener;", "targets", "", "Lcom/takusemba/spotlight/Target;", "[Lcom/takusemba/spotlight/Target;", "build", "Lcom/takusemba/spotlight/Spotlight;", "setAnimation", "setBackgroundColor", "setBackgroundColorRes", "backgroundColorRes", "setContainer", "setDuration", "setOnSpotlightListener", "setTargets", "([Lcom/takusemba/spotlight/Target;)Lcom/takusemba/spotlight/Spotlight$Builder;", "", "Companion", "spotlight_release"})
    public static final class Builder {
        private Target[] targets;
        private long duration;
        private TimeInterpolator interpolator;
        @ColorInt
        private int backgroundColor;
        private ViewGroup container;
        private OnSpotlightListener listener;
        private final Activity activity;
        private static final long DEFAULT_DURATION;
        private static final DecelerateInterpolator DEFAULT_ANIMATION;
        @ColorInt
        private static final int DEFAULT_OVERLAY_COLOR;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final Builder setTargets(Target ... targets) {
            Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Target[] targetArray = targets;
            boolean bl4 = false;
            Target[] targetArray2 = targetArray;
            boolean bl5 = false;
            boolean bl6 = !(targetArray2.length == 0);
            bl4 = false;
            boolean bl7 = false;
            if (!bl6) {
                boolean bl8 = false;
                String string = "targets should not be empty. ";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            $this$apply.targets = Arrays.copyOf(targets, targets.length);
            return builder;
        }

        @NotNull
        public final Builder setTargets(@NotNull List<Target> targets) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            Collection collection = targets;
            boolean bl4 = false;
            boolean bl5 = !collection.isEmpty();
            bl4 = false;
            boolean bl6 = false;
            if (!bl5) {
                boolean bl7 = false;
                String string = "targets should not be empty. ";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Collection $this$toTypedArray$iv = targets;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Target[] targetArray = thisCollection$iv.toArray(new Target[0]);
            if (targetArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            $this$apply.targets = targetArray;
            return builder;
        }

        @NotNull
        public final Builder setDuration(long duration) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.duration = duration;
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColorRes(@ColorRes int backgroundColorRes) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = ContextCompat.getColor((Context)((Context)$this$apply.activity), (int)backgroundColorRes);
            return builder;
        }

        @NotNull
        public final Builder setBackgroundColor(@ColorInt int backgroundColor) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.backgroundColor = backgroundColor;
            return builder;
        }

        @NotNull
        public final Builder setAnimation(@NotNull TimeInterpolator interpolator) {
            Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.interpolator = interpolator;
            return builder;
        }

        @NotNull
        public final Builder setContainer(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.container = container;
            return builder;
        }

        @NotNull
        public final Builder setOnSpotlightListener(@NotNull OnSpotlightListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.listener = listener;
            return builder;
        }

        @NotNull
        public final Spotlight build() {
            SpotlightView spotlight = new SpotlightView((Context)this.activity, null, 0, this.backgroundColor);
            Target[] targetArray = this.targets;
            boolean bl = false;
            boolean bl2 = false;
            if (targetArray == null) {
                boolean bl3 = false;
                String string = "targets should not be null. ";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Target[] targets = targetArray;
            ViewGroup viewGroup = this.container;
            if (viewGroup == null) {
                Window window = this.activity.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
                View view = window.getDecorView();
                if (view == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup");
                }
                viewGroup = (ViewGroup)view;
            }
            ViewGroup container = viewGroup;
            return new Spotlight(spotlight, targets, this.duration, this.interpolator, container, this.listener, null);
        }

        public Builder(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.duration = DEFAULT_DURATION;
            this.interpolator = (TimeInterpolator)DEFAULT_ANIMATION;
            this.backgroundColor = DEFAULT_OVERLAY_COLOR;
        }

        static {
            Companion = new Companion(null);
            DEFAULT_DURATION = TimeUnit.SECONDS.toMillis(1L);
            DEFAULT_ANIMATION = new DecelerateInterpolator(2.0f);
            DEFAULT_OVERLAY_COLOR = 0x6000000;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/takusemba/spotlight/Spotlight$Builder$Companion;", "", "()V", "DEFAULT_ANIMATION", "Landroid/view/animation/DecelerateInterpolator;", "DEFAULT_DURATION", "", "DEFAULT_OVERLAY_COLOR", "", "spotlight_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/takusemba/spotlight/Spotlight$Companion;", "", "()V", "NO_POSITION", "", "spotlight_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

