/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.strategy;

import com.github.pwittchen.reactivenetwork.library.rx2.Preconditions;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.InternetObservingStrategy;
import com.github.pwittchen.reactivenetwork.library.rx2.internet.observing.error.ErrorHandler;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class WalledGardenInternetObservingStrategy
implements InternetObservingStrategy {
    private static final String DEFAULT_HOST = "https://clients3.google.com/generate_204";

    @Override
    public String getDefaultPingHost() {
        return DEFAULT_HOST;
    }

    @Override
    public Observable<Boolean> observeInternetConnectivity(int initialIntervalInMs, int intervalInMs, String host, final int port, final int timeoutInMs, final int httpResponse, final ErrorHandler errorHandler) {
        Preconditions.checkGreaterOrEqualToZero(initialIntervalInMs, "initialIntervalInMs is not a positive number");
        Preconditions.checkGreaterThanZero(intervalInMs, "intervalInMs is not a positive number");
        this.checkGeneralPreconditions(host, port, timeoutInMs, httpResponse, errorHandler);
        final String adjustedHost = this.adjustHost(host);
        return Observable.interval((long)initialIntervalInMs, (long)intervalInMs, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.io()).map((Function)new Function<Long, Boolean>(){

            public Boolean apply(@NonNull Long tick) {
                return WalledGardenInternetObservingStrategy.this.isConnected(adjustedHost, port, timeoutInMs, httpResponse, errorHandler);
            }
        }).distinctUntilChanged();
    }

    @Override
    public Single<Boolean> checkInternetConnectivity(final String host, final int port, final int timeoutInMs, final int httpResponse, final ErrorHandler errorHandler) {
        this.checkGeneralPreconditions(host, port, timeoutInMs, httpResponse, errorHandler);
        return Single.create((SingleOnSubscribe)new SingleOnSubscribe<Boolean>(){

            public void subscribe(@NonNull SingleEmitter<Boolean> emitter) {
                emitter.onSuccess((Object)WalledGardenInternetObservingStrategy.this.isConnected(host, port, timeoutInMs, httpResponse, errorHandler));
            }
        });
    }

    protected String adjustHost(String host) {
        return host;
    }

    private void checkGeneralPreconditions(String host, int port, int timeoutInMs, int httpResponse, ErrorHandler errorHandler) {
        Preconditions.checkNotNullOrEmpty(host, "host is null or empty");
        Preconditions.checkGreaterThanZero(port, "port is not a positive number");
        Preconditions.checkGreaterThanZero(timeoutInMs, "timeoutInMs is not a positive number");
        Preconditions.checkNotNull(errorHandler, "errorHandler is null");
        Preconditions.checkNotNull(httpResponse, "httpResponse is null");
        Preconditions.checkGreaterThanZero(httpResponse, "httpResponse is not a positive number");
    }

    protected Boolean isConnected(String host, int port, int timeoutInMs, int httpResponse, ErrorHandler errorHandler) {
        try {
            Response response = this.createResponse(host, port, timeoutInMs);
            return response.code() == httpResponse;
        }
        catch (IOException e) {
            errorHandler.handleError(e, "Could not establish connection with WalledGardenStrategy");
            return Boolean.FALSE;
        }
    }

    protected Response createResponse(String host, int port, int timeoutInMs) throws IOException {
        HttpUrl httpUrl = new HttpUrl.Builder().host(host).port(port).build();
        Request request = new Request.Builder().url(host).url(httpUrl).build();
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)timeoutInMs, TimeUnit.MILLISECONDS).build();
        Call call = client.newCall(request);
        Response response = call.execute();
        return response;
    }
}

