/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.utils;

import android.content.res.Configuration;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.onegravity.rteditor.api.RTApi;
import com.onegravity.rteditor.utils.io.IOUtils;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.Bidi;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class Helper {
    private static float sDensity = Float.MAX_VALUE;
    private static float sDensity4Fonts = Float.MAX_VALUE;
    private static final int LEADING_MARGIN = 28;
    private static int sLeadingMarging = -1;

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float getDisplayDensity() {
        Class<Helper> clazz = Helper.class;
        synchronized (Helper.class) {
            if (sDensity == Float.MAX_VALUE) {
                sDensity = Helper.getDisplayMetrics().density;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDensity;
        }
    }

    public static int convertPxToSp(int pxSize) {
        return Math.round((float)pxSize * Helper.getDisplayDensity4Fonts());
    }

    public static int convertSpToPx(int spSize) {
        return Math.round((float)spSize / Helper.getDisplayDensity4Fonts());
    }

    private static DisplayMetrics getDisplayMetrics() {
        Display display = ((WindowManager)RTApi.getApplicationContext().getSystemService("window")).getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float getDisplayDensity4Fonts() {
        Class<Helper> clazz = Helper.class;
        synchronized (Helper.class) {
            if (sDensity4Fonts == Float.MAX_VALUE) {
                sDensity4Fonts = Helper.getDisplayMetrics().density * Helper.getFontScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDensity4Fonts;
        }
    }

    private static float getFontScale() {
        Configuration config = RTApi.getApplicationContext().getResources().getConfiguration();
        return config.fontScale;
    }

    public static int getLeadingMarging() {
        if (sLeadingMarging == -1) {
            float density = Helper.getDisplayDensity();
            sLeadingMarging = Math.round(28.0f * density);
        }
        return sLeadingMarging;
    }

    public static String encodeUrl(String url) {
        Uri uri = Uri.parse((String)url);
        try {
            Map<String, List<String>> splitQuery = Helper.splitQuery(uri);
            StringBuilder encodedQuery = new StringBuilder();
            for (String key : splitQuery.keySet()) {
                for (String value : splitQuery.get(key)) {
                    if (encodedQuery.length() > 0) {
                        encodedQuery.append("&");
                    }
                    encodedQuery.append(key + "=" + URLEncoder.encode(value, "UTF-8"));
                }
            }
            String queryString = encodedQuery != null && encodedQuery.length() > 0 ? "?" + encodedQuery : "";
            URI baseUri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment());
            return baseUri + queryString;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri.toString();
    }

    public static String decodeQuery(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return url;
        }
    }

    private static Map<String, List<String>> splitQuery(Uri uri) throws UnsupportedEncodingException {
        String[] pairs;
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        String query = uri.getQuery();
        if (query == null) {
            return query_pairs;
        }
        for (String pair : pairs = query.split("&")) {
            String key;
            int idx = pair.indexOf("=");
            String string2 = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            if (!query_pairs.containsKey(key)) {
                query_pairs.put(key, new LinkedList());
            }
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : "";
            ((List)query_pairs.get(key)).add(value);
        }
        return query_pairs;
    }

    public static boolean isRTL(CharSequence s, int start, int end) {
        if (s == null || s.length() == 0) {
            return Helper.isRTL(Locale.getDefault());
        }
        if (start == end) {
            --start;
            if ((start = Math.max(0, start)) == end) {
                ++end;
                end = Math.min(s.length(), end);
            }
        }
        try {
            Bidi bidi = new Bidi(s.subSequence(start, end).toString(), -2);
            return !bidi.baseIsLeftToRight();
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private static boolean isRTL(Locale locale) {
        byte directionality = Character.getDirectionality(locale.getDisplayName().charAt(0));
        return directionality == 1 || directionality == 2;
    }
}

