/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.crop;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.onegravity.rteditor.media.crop.CropImageActivity;
import com.onegravity.rteditor.media.crop.HighlightView;
import com.onegravity.rteditor.media.crop.ImageViewTouchBase;
import java.util.ArrayList;

class CropImageView
extends ImageViewTouchBase {
    ArrayList<HighlightView> mHighlightViews = new ArrayList();
    HighlightView mMotionHighlightView = null;
    float mLastX;
    float mLastY;
    int mMotionEdge;
    private Context mContext;

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mBitmapDisplayed.getBitmap() != null) {
            for (HighlightView hv : this.mHighlightViews) {
                hv.mMatrix.set(this.getImageMatrix());
                hv.invalidate();
                if (!hv.mIsFocused) continue;
                this.centerBasedOnHighlightView(hv);
            }
        }
    }

    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    @Override
    protected void zoomTo(float scale, float centerX, float centerY) {
        super.zoomTo(scale, centerX, centerY);
        for (HighlightView hv : this.mHighlightViews) {
            hv.mMatrix.set(this.getImageMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void zoomIn() {
        super.zoomIn();
        for (HighlightView hv : this.mHighlightViews) {
            hv.mMatrix.set(this.getImageMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void zoomOut() {
        super.zoomOut();
        for (HighlightView hv : this.mHighlightViews) {
            hv.mMatrix.set(this.getImageMatrix());
            hv.invalidate();
        }
    }

    @Override
    protected void postTranslate(float deltaX, float deltaY) {
        super.postTranslate(deltaX, deltaY);
        for (int i = 0; i < this.mHighlightViews.size(); ++i) {
            HighlightView hv = this.mHighlightViews.get(i);
            hv.mMatrix.postTranslate(deltaX, deltaY);
            hv.invalidate();
        }
    }

    private void recomputeFocus(MotionEvent event) {
        HighlightView hv;
        int i;
        for (i = 0; i < this.mHighlightViews.size(); ++i) {
            hv = this.mHighlightViews.get(i);
            hv.setFocus(false);
            hv.invalidate();
        }
        for (i = 0; i < this.mHighlightViews.size(); ++i) {
            hv = this.mHighlightViews.get(i);
            int edge = hv.getHit(event.getX(), event.getY());
            if (edge == 1) continue;
            if (hv.hasFocus()) break;
            hv.setFocus(true);
            hv.invalidate();
            break;
        }
        this.invalidate();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        CropImageActivity cropImage = (CropImageActivity)this.mContext;
        if (cropImage.mSaving) {
            return false;
        }
        block0 : switch (event.getAction()) {
            case 0: {
                if (cropImage.mWaitingToPick) {
                    this.recomputeFocus(event);
                    break;
                }
                for (int i = 0; i < this.mHighlightViews.size(); ++i) {
                    HighlightView hv = this.mHighlightViews.get(i);
                    int edge = hv.getHit(event.getX(), event.getY());
                    if (edge == 1) continue;
                    this.mMotionEdge = edge;
                    this.mMotionHighlightView = hv;
                    this.mLastX = event.getX();
                    this.mLastY = event.getY();
                    this.mMotionHighlightView.setMode(edge == 32 ? HighlightView.ModifyMode.Move : HighlightView.ModifyMode.Grow);
                    break block0;
                }
                break;
            }
            case 1: {
                if (cropImage.mWaitingToPick) {
                    for (int i = 0; i < this.mHighlightViews.size(); ++i) {
                        HighlightView hv = this.mHighlightViews.get(i);
                        if (!hv.hasFocus()) continue;
                        cropImage.mCrop = hv;
                        for (int j = 0; j < this.mHighlightViews.size(); ++j) {
                            if (j == i) continue;
                            this.mHighlightViews.get(j).setHidden(true);
                        }
                        this.centerBasedOnHighlightView(hv);
                        ((CropImageActivity)this.mContext).mWaitingToPick = false;
                        return true;
                    }
                } else if (this.mMotionHighlightView != null) {
                    this.centerBasedOnHighlightView(this.mMotionHighlightView);
                    this.mMotionHighlightView.setMode(HighlightView.ModifyMode.None);
                }
                this.mMotionHighlightView = null;
                break;
            }
            case 2: {
                if (cropImage.mWaitingToPick) {
                    this.recomputeFocus(event);
                    break;
                }
                if (this.mMotionHighlightView == null) break;
                this.mMotionHighlightView.handleMotion(this.mMotionEdge, event.getX() - this.mLastX, event.getY() - this.mLastY);
                this.mLastX = event.getX();
                this.mLastY = event.getY();
                this.ensureVisible(this.mMotionHighlightView);
            }
        }
        switch (event.getAction()) {
            case 1: {
                this.center(true, true);
                break;
            }
            case 2: {
                if (this.getScale() != 1.0f) break;
                this.center(true, true);
            }
        }
        return true;
    }

    private void ensureVisible(HighlightView hv) {
        int panDeltaY;
        Rect r = hv.mDrawRect;
        int panDeltaX1 = Math.max(0, this.mLeft - r.left);
        int panDeltaX2 = Math.min(0, this.mRight - r.right);
        int panDeltaY1 = Math.max(0, this.mTop - r.top);
        int panDeltaY2 = Math.min(0, this.mBottom - r.bottom);
        int panDeltaX = panDeltaX1 != 0 ? panDeltaX1 : panDeltaX2;
        int n = panDeltaY = panDeltaY1 != 0 ? panDeltaY1 : panDeltaY2;
        if (panDeltaX != 0 || panDeltaY != 0) {
            this.panBy(panDeltaX, panDeltaY);
        }
    }

    private void centerBasedOnHighlightView(HighlightView hv) {
        Rect drawRect = hv.mDrawRect;
        float width = drawRect.width();
        float height = drawRect.height();
        float thisWidth = this.getWidth();
        float thisHeight = this.getHeight();
        float z1 = thisWidth / width * 0.8f;
        float z2 = thisHeight / height * 0.8f;
        float zoom = Math.min(z1, z2);
        zoom *= this.getScale();
        if ((double)(Math.abs((zoom = Math.max(1.0f, zoom)) - this.getScale()) / zoom) > 0.1) {
            float[] coordinates = new float[]{hv.mCropRect.centerX(), hv.mCropRect.centerY()};
            this.getImageMatrix().mapPoints(coordinates);
            this.zoomTo(zoom, coordinates[0], coordinates[1], 300.0f);
        }
        this.ensureVisible(hv);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.mHighlightViews.size(); ++i) {
            this.mHighlightViews.get(i).draw(canvas);
        }
    }

    public void add(HighlightView hv) {
        this.mHighlightViews.add(hv);
        this.invalidate();
    }
}

