/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.io.FilenameUtils;
import java.io.Closeable;
import java.io.File;
import java.util.Calendar;

public class MediaUtils {
    public static File createUniqueFile(File targetFolder, String originalFile, boolean keepOriginal) {
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(originalFile);
        return MediaUtils.createUniqueFile(targetFolder, originalFile, mimeType, keepOriginal);
    }

    public static File createUniqueFile(File targetFolder, String originalFile, String mimeType, boolean keepOriginal) {
        String extension = FilenameUtils.getExtension(originalFile);
        if (MediaUtils.isNullOrEmpty(extension)) {
            extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
        }
        String random = Long.toString(Math.round(Math.random() * 2.147483647E9));
        long timestamp = Calendar.getInstance().getTimeInMillis();
        if (keepOriginal) {
            String baseName = FilenameUtils.getBaseName(originalFile);
            return new File(targetFolder + File.separator + baseName + "_" + random + "_" + timestamp + "." + extension);
        }
        return new File(targetFolder + File.separator + random + "_" + timestamp + "." + extension);
    }

    public static Uri createFileUri(String path) {
        if (path.startsWith("file://")) {
            return Uri.parse((String)path);
        }
        return Uri.fromFile((File)new File(path));
    }

    public static String determineOriginalFile(Context context, Uri uri) throws IllegalArgumentException {
        String originalFile = null;
        if (uri != null) {
            if (uri.getScheme().startsWith("content")) {
                originalFile = MediaUtils.getPathFromUri(context, uri);
            }
            if (uri.toString().matches("https?://\\w+\\.googleusercontent\\.com/.+")) {
                originalFile = uri.toString();
            }
            if (uri.getScheme().startsWith("file")) {
                originalFile = uri.toString().substring(7);
            }
            if (MediaUtils.isNullOrEmpty(originalFile)) {
                throw new IllegalArgumentException("File path was null");
            }
        } else {
            throw new IllegalArgumentException("Image Uri was null!");
        }
        return originalFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getPathFromUri(Context context, Uri imageUri) {
        String filePath = "";
        if (imageUri.toString().startsWith("content://com.android.gallery3d.provider")) {
            imageUri = Uri.parse((String)imageUri.toString().replace("com.android.gallery3d", "com.google.android.gallery3d"));
        }
        Cursor cursor = null;
        try {
            String column = "_data";
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(imageUri, proj, null, null, null);
            cursor.moveToFirst();
            filePath = imageUri.toString().startsWith("content://com.google.android.gallery3d") ? imageUri.toString() : cursor.getString(cursor.getColumnIndexOrThrow(column));
        }
        catch (Exception exception) {
            Helper.closeQuietly(cursor);
            catch (Throwable throwable) {
                Helper.closeQuietly(cursor);
                throw throwable;
            }
        }
        Helper.closeQuietly((Closeable)cursor);
        if (MediaUtils.isNullOrEmpty(filePath) || !new File(filePath).exists() || imageUri.toString().startsWith("content://com.google.android.gallery3d")) {
            filePath = imageUri.toString();
        }
        return filePath;
    }

    private static boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }
}

