/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.fonts;

import android.content.res.AssetManager;
import com.onegravity.rteditor.fonts.TTFAssetInputStream;
import com.onegravity.rteditor.fonts.TTFInputStream;
import com.onegravity.rteditor.fonts.TTFRandomAccessFile;
import com.onegravity.rteditor.utils.io.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

abstract class TTFAnalyzer {
    TTFAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFontName(String filePath) {
        TTFRandomAccessFile in = null;
        try {
            RandomAccessFile file = new RandomAccessFile(filePath, "r");
            in = new TTFRandomAccessFile(file);
            String string2 = TTFAnalyzer.getTTFFontName(in, filePath);
            IOUtils.closeQuietly(in);
            return string2;
        }
        catch (IOException e) {
            String string3 = null;
            return string3;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static String getFontName(AssetManager assets, String filePath) {
        TTFAssetInputStream in = null;
        try {
            InputStream file = assets.open(filePath, 1);
            in = new TTFAssetInputStream(file);
            String string2 = TTFAnalyzer.getTTFFontName(in, filePath);
            IOUtils.closeQuietly(in);
            return string2;
        }
        catch (FileNotFoundException e) {
            String string3 = null;
            return string3;
        }
        catch (IOException e2) {
            String string4 = null;
            return string4;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private static String getTTFFontName(TTFInputStream in, String fontFilename) {
        try {
            int version = TTFAnalyzer.readDword(in);
            if (version != 1953658213 && version != 65536 && version != 0x4F54544F) {
                return null;
            }
            int numTables = TTFAnalyzer.readWord(in);
            TTFAnalyzer.readWord(in);
            TTFAnalyzer.readWord(in);
            TTFAnalyzer.readWord(in);
            for (int i = 0; i < numTables; ++i) {
                int tag = TTFAnalyzer.readDword(in);
                TTFAnalyzer.readDword(in);
                int offset = TTFAnalyzer.readDword(in);
                int length = TTFAnalyzer.readDword(in);
                if (tag != 1851878757) continue;
                byte[] table = new byte[length];
                in.seek(offset);
                TTFAnalyzer.read(in, table);
                int count = TTFAnalyzer.getWord(table, 2);
                int string_offset = TTFAnalyzer.getWord(table, 4);
                for (int record = 0; record < count; ++record) {
                    int nameid_offset = record * 12 + 6;
                    int platformID = TTFAnalyzer.getWord(table, nameid_offset);
                    int nameid_value = TTFAnalyzer.getWord(table, nameid_offset + 6);
                    if (nameid_value != 4 || platformID != 1) continue;
                    int name_length = TTFAnalyzer.getWord(table, nameid_offset + 8);
                    int name_offset = TTFAnalyzer.getWord(table, nameid_offset + 10);
                    if ((name_offset += string_offset) < 0 || name_offset + name_length >= table.length) continue;
                    return new String(table, name_offset, name_length);
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static int readByte(TTFInputStream in) throws IOException {
        return in.read() & 0xFF;
    }

    private static int readWord(TTFInputStream in) throws IOException {
        int b1 = TTFAnalyzer.readByte(in);
        int b2 = TTFAnalyzer.readByte(in);
        return b1 << 8 | b2;
    }

    private static int readDword(TTFInputStream in) throws IOException {
        int b1 = TTFAnalyzer.readByte(in);
        int b2 = TTFAnalyzer.readByte(in);
        int b3 = TTFAnalyzer.readByte(in);
        int b4 = TTFAnalyzer.readByte(in);
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    private static void read(TTFInputStream in, byte[] array) throws IOException {
        if (in.read(array) != array.length) {
            throw new IOException();
        }
    }

    private static int getWord(byte[] array, int offset) {
        int b1 = array[offset] & 0xFF;
        int b2 = array[offset + 1] & 0xFF;
        return b1 << 8 | b2;
    }
}

