/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Editable;
import android.text.Spannable;
import android.widget.EditText;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.effects.SpanCollector;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Selection;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class Effect<V, C extends RTSpan<V>> {
    private SpanCollector<V> mSpanCollector;

    public final boolean existsInSelection(RTEditText editor) {
        Selection selection = this.getSelection(editor);
        List<RTSpan<V>> spans = this.getSpans((Spannable)editor.getText(), selection, SpanCollectMode.SPAN_FLAGS);
        return !spans.isEmpty();
    }

    public final List<V> valuesInSelection(RTEditText editor) {
        ArrayList<V> result = new ArrayList<V>();
        Selection selection = this.getSelection(editor);
        List<RTSpan<V>> spans = this.getSpans((Spannable)editor.getText(), selection, SpanCollectMode.SPAN_FLAGS);
        for (RTSpan<V> span : spans) {
            result.add(span.getValue());
        }
        return result;
    }

    public final void clearFormattingInSelection(RTEditText editor) {
        Editable text = editor.getText();
        Selection selection = new Selection((EditText)editor);
        selection = selection.isEmpty() ? new Selection(0, text.length()) : this.getSelection(editor);
        List<RTSpan<V>> spans = this.getSpans((Spannable)text, selection, SpanCollectMode.EXACT);
        for (RTSpan<V> span : spans) {
            editor.getText().removeSpan(span);
        }
    }

    public final List<RTSpan<V>> getSpans(Spannable str, Selection selection, SpanCollectMode mode) {
        if (this.mSpanCollector == null) {
            Type[] types = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
            Class spanClazz = (Class)types[types.length - 1];
            this.mSpanCollector = this.newSpanCollector(spanClazz);
        }
        return this.mSpanCollector.getSpans(str, selection, mode);
    }

    protected abstract SpanCollector<V> newSpanCollector(Class<? extends RTSpan<V>> var1);

    protected abstract Selection getSelection(RTEditText var1);

    public abstract void applyToSelection(RTEditText var1, V var2);
}

