/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Editable;
import android.text.Spannable;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.Effects;
import com.onegravity.rteditor.effects.ParagraphEffect;
import com.onegravity.rteditor.effects.ParagraphSpanProcessor;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.spans.BulletSpan;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.List;

public class BulletEffect
extends ParagraphEffect<Boolean, BulletSpan> {
    private ParagraphSpanProcessor<Boolean> mSpans2Process = new ParagraphSpanProcessor();

    @Override
    public synchronized void applyToSelection(RTEditText editor, Selection selectedParagraphs, Boolean enable) {
        Editable str = editor.getText();
        this.mSpans2Process.clear();
        ArrayList<Paragraph> paragraphs = editor.getParagraphs();
        int size = paragraphs.size();
        for (int i = 0; i < size; ++i) {
            boolean hasBullet;
            Paragraph paragraph = paragraphs.get(i);
            List existingSpans = this.getSpans((Spannable)str, paragraph, SpanCollectMode.SPAN_FLAGS);
            this.mSpans2Process.removeSpans(existingSpans, paragraph);
            boolean hasExistingSpans = !existingSpans.isEmpty();
            boolean bl = hasBullet = paragraph.isSelected(selectedParagraphs) ? enable : hasExistingSpans;
            if (!hasBullet) continue;
            int margin = Helper.getLeadingMarging();
            BulletSpan bulletSpan = new BulletSpan(margin, paragraph.isEmpty(), paragraph.isFirst(), paragraph.isLast());
            this.mSpans2Process.addSpan(bulletSpan, paragraph);
            Effects.NUMBER.findSpans2Remove((Spannable)str, paragraph, this.mSpans2Process);
        }
        this.mSpans2Process.process((Spannable)str);
    }
}

