/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter.tagsoup;

import android.text.util.Linkify;
import com.onegravity.rteditor.converter.tagsoup.Patterns;
import com.onegravity.rteditor.converter.tagsoup.util.StringEscapeUtils;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public class HTMLWriter
extends XMLFilterImpl
implements LexicalHandler {
    private static Map<String, Map<String, String>> mTags2Ignore = new HashMap<String, Map<String, String>>();
    public static final String CDATA_SECTION_ELEMENTS = "cdata-section-elements";
    public static final String DOCTYPE_PUBLIC = "doctype-public";
    public static final String DOCTYPE_SYSTEM = "doctype-system";
    public static final String ENCODING = "encoding";
    public static final String INDENT = "indent";
    public static final String MEDIA_TYPE = "media-type";
    public static final String METHOD = "method";
    public static final String OMIT_XML_DECLARATION = "omit-xml-declaration";
    public static final String STANDALONE = "standalone";
    public static final String VERSION = "version";
    private Hashtable<String, String> prefixTable;
    private Hashtable<String, Boolean> forcedDeclTable;
    private Hashtable<String, String> doneDeclTable;
    private int elementLevel = 0;
    private Writer output;
    private NamespaceSupport nsSupport;
    private int prefixCounter = 0;
    private Properties outputProperties;
    private String outputEncoding = "";
    private boolean htmlMode = false;
    private boolean forceDTD = false;
    private boolean hasOutputDTD = false;
    private String overridePublic = null;
    private String overrideSystem = null;
    private String version = null;
    private String standalone = null;
    private boolean cdataElement = false;
    private boolean mOmitXHTMLNamespace;
    private Stack<String> mIgnoredTags;
    private String[] booleans = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
    private static final String[] LINK_SCHEMAS;
    private static final Linkify.MatchFilter URL_MATCH_FILTER;
    private boolean mIgnoreChars;
    private StringBuffer mLastText4Links = new StringBuffer();

    public HTMLWriter(boolean omitXHTMLNamespace) {
        this.nsSupport = new NamespaceSupport();
        this.prefixTable = new Hashtable();
        this.forcedDeclTable = new Hashtable();
        this.doneDeclTable = new Hashtable();
        this.outputProperties = new Properties();
        this.setOutputProperty(METHOD, "html");
        this.setOutputProperty(OMIT_XML_DECLARATION, "yes");
        this.mOmitXHTMLNamespace = omitXHTMLNamespace;
        this.mIgnoredTags = new Stack();
    }

    public void reset() throws SAXException {
        this.writeText4Links();
        this.elementLevel = 0;
        this.prefixCounter = 0;
        this.nsSupport.reset();
    }

    public void flush() throws IOException, SAXException {
        this.writeText4Links();
        this.output.flush();
    }

    public void setOutput(Writer writer) {
        this.output = writer == null ? new OutputStreamWriter(System.out) : writer;
    }

    public void setPrefix(String uri, String prefix) {
        this.prefixTable.put(uri, prefix);
    }

    public String getPrefix(String uri) {
        return this.prefixTable.get(uri);
    }

    public void forceNSDecl(String uri) {
        this.forcedDeclTable.put(uri, Boolean.TRUE);
    }

    public void forceNSDecl(String uri, String prefix) {
        this.setPrefix(uri, prefix);
        this.forceNSDecl(uri);
    }

    @Override
    public void startDocument() throws SAXException {
        this.writeText4Links();
        this.reset();
        if (!"yes".equals(this.outputProperties.getProperty(OMIT_XML_DECLARATION, "no"))) {
            this.write("<?xml");
            if (this.version == null) {
                this.write(" version=\"1.0\"");
            } else {
                this.write(" version=\"");
                this.write(this.version);
                this.write("\"");
            }
            if (this.outputEncoding != null && this.outputEncoding != "") {
                this.write(" encoding=\"");
                this.write(this.outputEncoding);
                this.write("\"");
            }
            if (this.standalone == null) {
                this.write(" standalone=\"yes\"?>\n");
            } else {
                this.write(" standalone=\"");
                this.write(this.standalone);
                this.write("\"");
            }
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.writeText4Links();
        this.write('\n');
        super.endDocument();
        try {
            this.flush();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.writeText4Links();
        if (!this.ignoreElement(uri, localName, qName, atts)) {
            ++this.elementLevel;
            this.nsSupport.pushContext();
            if (this.forceDTD && !this.hasOutputDTD) {
                this.startDTD(localName == null ? qName : localName, "", "");
            }
            this.write('<');
            this.writeName(uri, localName, qName, true);
            this.writeAttributes(atts);
            if (this.elementLevel == 1) {
                this.forceNSDecls();
            }
            if (!this.mOmitXHTMLNamespace || !"html".equalsIgnoreCase(localName)) {
                this.writeNSDecls();
            }
            this.write('>');
            if (this.htmlMode && (qName.equals("script") || qName.equals("style"))) {
                this.cdataElement = true;
            }
            if (this.htmlMode && localName.equals("a")) {
                this.mIgnoreChars = true;
            }
            super.startElement(uri, localName, qName, atts);
        }
    }

    private boolean ignoreElement(String uri, String localName, String qName, Attributes atts) {
        Map<String, String> tagAttrs = mTags2Ignore.get(qName.toLowerCase(Locale.US));
        if (tagAttrs != null) {
            for (String attrKey : tagAttrs.keySet()) {
                for (String attrValue : tagAttrs.get(attrKey).split("#")) {
                    String value = atts.getValue(attrKey);
                    if (this.isNullOrEmpty(value) || !attrValue.equalsIgnoreCase(value)) continue;
                    this.mIgnoredTags.push(qName);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isNullOrEmpty(String string2) {
        return string2 == null || string2.length() == 0;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.writeText4Links();
        if (!this.mIgnoredTags.isEmpty() && this.mIgnoredTags.peek().equalsIgnoreCase(qName)) {
            this.mIgnoredTags.pop();
        } else {
            if (!(this.htmlMode && (uri.equals("http://www.w3.org/1999/xhtml") || uri.equals("")) && (qName.equals("area") || qName.equals("base") || qName.equals("basefont") || qName.equals("br") || qName.equals("col") || qName.equals("frame") || qName.equals("hr") || qName.equals("img") || qName.equals("input") || qName.equals("isindex") || qName.equals("link") || qName.equals("meta") || qName.equals("param")))) {
                this.write("</");
                this.writeName(uri, localName, qName, true);
                this.write('>');
            }
            if (this.elementLevel == 1) {
                this.write('\n');
            }
            if (this.htmlMode && localName.equals("a")) {
                this.mIgnoreChars = false;
            }
            this.cdataElement = false;
            super.endElement(uri, localName, qName);
            this.nsSupport.popContext();
            --this.elementLevel;
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        if (!this.cdataElement) {
            if (this.mIgnoreChars) {
                this.writeText4Links();
                this.writeEscUTF16(new String(ch), start, len, false);
            } else {
                this.collectText4Links(ch, start, len);
            }
        } else {
            this.writeText4Links();
            for (int i = start; i < start + len; ++i) {
                this.write(ch[i]);
            }
        }
        super.characters(ch, start, len);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.writeText4Links();
        this.writeEscUTF16(new String(ch), start, length, false);
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.writeText4Links();
        this.write("<?");
        this.write(target);
        this.write(' ');
        this.write(data);
        this.write("?>");
        if (this.elementLevel < 1) {
            this.write('\n');
        }
        super.processingInstruction(target, data);
    }

    private void forceNSDecls() {
        Enumeration<String> prefixes = this.forcedDeclTable.keys();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            this.doPrefix(prefix, null, true);
        }
    }

    private String doPrefix(String uri, String qName, boolean isElement) {
        String defaultNS = this.nsSupport.getURI("");
        if ("".equals(uri)) {
            if (isElement && defaultNS != null) {
                this.nsSupport.declarePrefix("", "");
            }
            return null;
        }
        String prefix = isElement && defaultNS != null && uri.equals(defaultNS) ? "" : this.nsSupport.getPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.doneDeclTable.get(uri);
        if (prefix != null && ((!isElement || defaultNS != null) && "".equals(prefix) || this.nsSupport.getURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && (prefix = this.prefixTable.get(uri)) != null && ((!isElement || defaultNS != null) && "".equals(prefix) || this.nsSupport.getURI(prefix) != null)) {
            prefix = null;
        }
        if (prefix == null && qName != null && !"".equals(qName)) {
            int i = qName.indexOf(58);
            if (i == -1) {
                if (isElement && defaultNS == null) {
                    prefix = "";
                }
            } else {
                prefix = qName.substring(0, i);
            }
        }
        while (prefix == null || this.nsSupport.getURI(prefix) != null) {
            prefix = "__NS" + ++this.prefixCounter;
        }
        this.nsSupport.declarePrefix(prefix, uri);
        this.doneDeclTable.put(uri, prefix);
        return prefix;
    }

    private void write(char c) throws SAXException {
        try {
            this.output.write(c);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void write(String s) throws SAXException {
        try {
            this.output.write(s);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void writeAttributes(Attributes atts) throws SAXException {
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            this.write(' ');
            this.writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
            if (this.htmlMode && this.booleanAttribute(atts.getLocalName(i), atts.getQName(i), atts.getValue(i))) break;
            this.write("=\"");
            String s = atts.getValue(i);
            this.writeEscUTF16(s, 0, s.length(), true);
            this.write('\"');
        }
    }

    private boolean booleanAttribute(String localName, String qName, String value) {
        int i;
        String name = localName;
        if (name == null && (i = qName.indexOf(58)) != -1) {
            name = qName.substring(i + 1, qName.length());
        }
        if (!name.equals(value)) {
            return false;
        }
        for (int j = 0; j < this.booleans.length; ++j) {
            if (!name.equals(this.booleans[j])) continue;
            return true;
        }
        return false;
    }

    private void writeEscUTF16(String s, int start, int length, boolean isAttVal) throws SAXException {
        String subString = s.substring(start, start + length);
        this.write(StringEscapeUtils.escapeHtml4(subString));
    }

    private void writeNSDecls() throws SAXException {
        Enumeration<String> prefixes = this.nsSupport.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement();
            String uri = this.nsSupport.getURI(prefix);
            if (uri == null) {
                uri = "";
            }
            this.write(' ');
            if ("".equals(prefix)) {
                this.write("xmlns=\"");
            } else {
                this.write("xmlns:");
                this.write(prefix);
                this.write("=\"");
            }
            this.writeEscUTF16(uri, 0, uri.length(), true);
            this.write('\"');
        }
    }

    private void writeName(String uri, String localName, String qName, boolean isElement) throws SAXException {
        String prefix = this.doPrefix(uri, qName, isElement);
        if (prefix != null && !"".equals(prefix)) {
            this.write(prefix);
            this.write(':');
        }
        if (localName != null && !"".equals(localName)) {
            this.write(localName);
        } else {
            int i = qName.indexOf(58);
            this.write(qName.substring(i + 1, qName.length()));
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.write("<!--");
        for (int i = start; i < start + length; ++i) {
            this.write(ch[i]);
            if (ch[i] != '-' || i + 1 > start + length || ch[i + 1] != '-') continue;
            this.write(' ');
        }
        this.write("-->");
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicid, String systemid) throws SAXException {
        char sysquote;
        if (name == null) {
            return;
        }
        if (this.hasOutputDTD) {
            return;
        }
        this.hasOutputDTD = true;
        this.write("<!DOCTYPE ");
        this.write(name);
        if (systemid == null) {
            systemid = "";
        }
        if (this.overrideSystem != null) {
            systemid = this.overrideSystem;
        }
        char c = sysquote = systemid.indexOf(34) != -1 ? (char)'\'' : '\"';
        if (this.overridePublic != null) {
            publicid = this.overridePublic;
        }
        if (publicid != null && !"".equals(publicid)) {
            char pubquote = publicid.indexOf(34) != -1 ? (char)'\'' : '\"';
            this.write(" PUBLIC ");
            this.write(pubquote);
            this.write(publicid);
            this.write(pubquote);
            this.write(' ');
        } else {
            this.write(" SYSTEM ");
        }
        this.write(sysquote);
        this.write(systemid);
        this.write(sysquote);
        this.write(">\n");
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    public String getOutputProperty(String key) {
        return this.outputProperties.getProperty(key);
    }

    public void setOutputProperty(String key, String value) {
        this.outputProperties.setProperty(key, value);
        if (key.equals(ENCODING)) {
            this.outputEncoding = value;
        } else if (key.equals(METHOD)) {
            this.htmlMode = value.equals("html");
        } else if (key.equals(DOCTYPE_PUBLIC)) {
            this.overridePublic = value;
            this.forceDTD = true;
        } else if (key.equals(DOCTYPE_SYSTEM)) {
            this.overrideSystem = value;
            this.forceDTD = true;
        } else if (key.equals(VERSION)) {
            this.version = value;
        } else if (key.equals(STANDALONE)) {
            this.standalone = value;
        }
    }

    private void collectText4Links(char[] ch, int start, int len) throws SAXException {
        this.mLastText4Links.append(String.valueOf(ch, start, len));
    }

    private void writeText4Links() throws SAXException {
        if (this.mLastText4Links.length() > 0) {
            String text2Write = this.mLastText4Links.toString();
            Writer tmp = this.output;
            this.output = new StringWriter();
            Matcher m = Patterns.WEB_URL.matcher(this.mLastText4Links);
            int lastLinkEnd = 0;
            while (m.find()) {
                if (URL_MATCH_FILTER != null && !URL_MATCH_FILTER.acceptMatch((CharSequence)this.mLastText4Links, m.start(), m.start())) continue;
                this.writeEscUTF16(text2Write, lastLinkEnd, m.start() - lastLinkEnd, false);
                try {
                    String linkText = m.group(0);
                    String link = this.makeUrl(linkText, LINK_SCHEMAS, m);
                    this.output.append("<a href=\"" + link + "\">");
                    this.writeEscUTF16(linkText, 0, linkText.length(), false);
                    this.output.append("</a>");
                }
                catch (IOException linkText) {
                    // empty catch block
                }
                lastLinkEnd = m.end();
            }
            if (lastLinkEnd < text2Write.length()) {
                this.writeEscUTF16(text2Write, lastLinkEnd, text2Write.length() - lastLinkEnd, false);
            }
            String text2WriteString = this.output.toString();
            this.output = tmp;
            this.write(text2WriteString);
            this.mLastText4Links.setLength(0);
        }
    }

    private String makeUrl(String url, String[] prefixes, Matcher m) {
        boolean hasPrefix = false;
        for (int i = 0; i < prefixes.length; ++i) {
            if (!url.regionMatches(true, 0, prefixes[i], 0, prefixes[i].length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefixes[i], 0, prefixes[i].length())) break;
            url = prefixes[i] + url.substring(prefixes[i].length());
            break;
        }
        if (!hasPrefix) {
            url = prefixes[0] + url;
        }
        return url.replace("\u00a0", "");
    }

    static {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("http-equiv", "Refresh");
        mTags2Ignore.put("meta", attributes);
        mTags2Ignore.put("iframe", attributes);
        attributes = new HashMap();
        attributes.put("autoplay", "autoplay#true");
        mTags2Ignore.put("audio", attributes);
        mTags2Ignore.put("video", attributes);
        LINK_SCHEMAS = new String[]{"http://", "https://", "rtsp://"};
        URL_MATCH_FILTER = new Linkify.MatchFilter(){

            public final boolean acceptMatch(CharSequence s, int start, int end) {
                return start == 0 || s.charAt(start - 1) != '@';
            }
        };
    }
}

