/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter;

import android.text.style.ParagraphStyle;
import com.onegravity.rteditor.converter.ParagraphType;
import com.onegravity.rteditor.spans.IndentationSpan;
import com.onegravity.rteditor.utils.Helper;

public class SingleParagraphStyle
implements ParagraphStyle {
    private final ParagraphType mType;
    private final ParagraphStyle mStyle;

    public SingleParagraphStyle(ParagraphType type, ParagraphStyle style) {
        this.mType = type;
        this.mStyle = style;
    }

    public int getIndentation() {
        if (this.mType.isIndentation()) {
            float margin = Helper.getLeadingMarging();
            float indentation = ((IndentationSpan)this.mStyle).getValue().intValue();
            return Math.round(indentation / margin);
        }
        if (this.mType.isBullet() || this.mType.isNumbering()) {
            return 1;
        }
        return 0;
    }

    public ParagraphType getType() {
        return this.mType;
    }

    public ParagraphStyle getStyle() {
        return this.mStyle;
    }

    public String toString() {
        return this.mType.name() + " - " + this.mStyle.getClass().getSimpleName();
    }
}

