/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter;

import android.text.TextUtils;
import android.util.Patterns;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.format.RTHtml;
import com.onegravity.rteditor.api.format.RTPlainText;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConverterTextToHtml {
    private static final int TEXT_TO_HTML_EXTRA_BUFFER_LENGTH = 512;
    private static final String BITCOIN_URI_PATTERN = "bitcoin:[1-9a-km-zA-HJ-NP-Z]{27,34}(\\?[a-zA-Z0-9$\\-_.+!*'(),%:@&=]*)?";
    private static final boolean USE_REPLACE_ALL = false;

    public static RTHtml<RTImage, RTAudio, RTVideo> convert(RTPlainText input) {
        String text = input.getText();
        String result = ConverterTextToHtml.convert(text);
        return new RTHtml<RTImage, RTAudio, RTVideo>(RTFormat.HTML, (CharSequence)result);
    }

    public static String convert(String text) {
        String htmlified = text == null ? "" : TextUtils.htmlEncode((String)text);
        StringBuffer linkified = new StringBuffer(htmlified.length() + 512);
        ConverterTextToHtml.linkifyText(htmlified, linkified);
        String result = linkified.toString().replace("\n", "<br>\n").replace("&apos;", "&#39;");
        return result;
    }

    private static void linkifyText(String text, StringBuffer outputBuffer) {
        String prepared = ConverterTextToHtml.replaceAll(text, BITCOIN_URI_PATTERN, "<a href=\"$0\">$0</a>");
        Matcher m = Patterns.WEB_URL.matcher(prepared);
        while (m.find()) {
            int start = m.start();
            if (start == 0 || start != 0 && text.charAt(start - 1) != '@') {
                if (m.group().indexOf(58) > 0) {
                    m.appendReplacement(outputBuffer, "<a href=\"$0\">$0</a>");
                    continue;
                }
                m.appendReplacement(outputBuffer, "<a href=\"http://$0\">$0</a>");
                continue;
            }
            m.appendReplacement(outputBuffer, "$0");
        }
        m.appendTail(outputBuffer);
    }

    private static String replaceAll(String source, String search, String replace) {
        Pattern p = Pattern.compile(search);
        Matcher m = p.matcher(source);
        StringBuffer sb = new StringBuffer();
        boolean atLeastOneFound = false;
        while (m.find()) {
            m.appendReplacement(sb, replace);
            atLeastOneFound = true;
        }
        if (atLeastOneFound) {
            m.appendTail(sb);
            return sb.toString();
        }
        return source;
    }
}

