/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.api.media;

import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.util.Log;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.media.RTMedia;
import com.onegravity.rteditor.utils.io.FilenameUtils;
import java.io.File;

public abstract class RTMediaImpl
implements RTMedia {
    private static final long serialVersionUID = 5098840799124458004L;
    private String mFilePath;

    public RTMediaImpl(String filePath) {
        this.mFilePath = filePath;
    }

    @Override
    public String getFilePath(RTFormat textFormat) {
        return this.mFilePath;
    }

    @Override
    public String getFileExtension() {
        return FilenameUtils.getExtension(this.mFilePath);
    }

    @Override
    public String getFileName() {
        return FilenameUtils.getName(this.mFilePath);
    }

    @Override
    public boolean exists() {
        return this.mFilePath != null && new File(this.mFilePath).exists();
    }

    @Override
    public void remove() {
        this.removeFile(this.mFilePath);
    }

    @Override
    public long getSize() {
        if (this.mFilePath != null) {
            File file = new File(this.mFilePath);
            return file.length();
        }
        return 0L;
    }

    @Override
    public int getWidth() {
        return this.getWidth(this.getFilePath(RTFormat.SPANNED));
    }

    @Override
    public int getHeight() {
        return this.getHeight(this.getFilePath(RTFormat.SPANNED));
    }

    protected String getFilePath() {
        return this.mFilePath;
    }

    protected void setFilePath(String filePath) {
        this.mFilePath = filePath;
    }

    protected void removeFile(String path) {
        if (path != null) {
            File file = new File(path);
            file.delete();
        }
    }

    protected int getWidth(String filePath) {
        int width = 0;
        try {
            ExifInterface exif = new ExifInterface(filePath);
            String w = exif.getAttribute("ImageWidth");
            width = w.equals("0") ? this.getDimension(filePath, true) : Integer.parseInt(w);
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
        }
        return width;
    }

    protected int getHeight(String filePath) {
        int height = 0;
        try {
            ExifInterface exif = new ExifInterface(filePath);
            String h = exif.getAttribute("ImageLength");
            height = h.equals("0") ? this.getDimension(filePath, false) : Integer.parseInt(h);
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage(), (Throwable)e);
        }
        return height;
    }

    private int getDimension(String path, boolean width) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.outWidth = 0;
        options.outHeight = 0;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return width ? options.outWidth : options.outHeight;
    }
}

