/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.api;

import android.app.DialogFragment;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.util.AndroidRuntimeException;
import android.widget.Toast;
import androidx.annotation.AttrRes;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.RTProxy;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTMediaSource;
import com.onegravity.rteditor.api.media.RTVideo;

public class RTApi
implements RTProxy,
RTMediaFactory<RTImage, RTAudio, RTVideo> {
    private static final long serialVersionUID = -3877685955074371741L;
    private static final Object sTheLock = new Object();
    private static Context sAppContext;
    private static boolean sDarkTheme;
    private final transient RTProxy mRTProxy;
    private final RTMediaFactory<RTImage, RTAudio, RTVideo> mMediaFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context getApplicationContext() {
        Object object = sTheLock;
        synchronized (object) {
            if (sAppContext == null) {
                throw new IncorrectInitializationException("Create an RTApi object before calling RTApi.getApplicationContext()");
            }
            return sAppContext;
        }
    }

    public static boolean useDarkTheme() {
        return sDarkTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTApi(Context context, RTProxy rtProxy, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory) {
        Object object = sTheLock;
        synchronized (object) {
            sAppContext = context.getApplicationContext();
        }
        sDarkTheme = this.resolveBoolean(context, R.attr.rte_darkTheme, false);
        this.mRTProxy = rtProxy;
        this.mMediaFactory = mediaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resolveBoolean(Context context, @AttrRes int attr2, boolean fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
        try {
            boolean bl = a.getBoolean(0, fallback);
            return bl;
        }
        finally {
            a.recycle();
        }
    }

    public RTProxy getRTProxy() {
        return this.mRTProxy;
    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        this.mRTProxy.startActivityForResult(intent, requestCode);
    }

    @Override
    public void runOnUiThread(Runnable action) {
        this.mRTProxy.runOnUiThread(action);
    }

    @Override
    public Toast makeText(int resId, int duration) {
        return this.mRTProxy.makeText(resId, duration);
    }

    @Override
    public Toast makeText(CharSequence text, int duration) {
        return this.mRTProxy.makeText(text, duration);
    }

    @Override
    public void openDialogFragment(String fragmentTag, DialogFragment fragment) {
        this.mRTProxy.openDialogFragment(fragmentTag, fragment);
    }

    @Override
    public void removeFragment(String fragmentTag) {
        this.mRTProxy.removeFragment(fragmentTag);
    }

    public RTMediaFactory<RTImage, RTAudio, RTVideo> getMediaFactory() {
        return this.mMediaFactory;
    }

    @Override
    public RTImage createImage(RTMediaSource mediaSource) {
        return this.mMediaFactory.createImage(mediaSource);
    }

    @Override
    public RTAudio createAudio(RTMediaSource mediaSource) {
        return this.mMediaFactory.createAudio(mediaSource);
    }

    @Override
    public RTVideo createVideo(RTMediaSource mediaSource) {
        return this.mMediaFactory.createVideo(mediaSource);
    }

    @Override
    public RTImage createImage(String path) {
        return this.mMediaFactory.createImage(path);
    }

    @Override
    public RTAudio createAudio(String path) {
        return this.mMediaFactory.createAudio(path);
    }

    @Override
    public RTVideo createVideo(String path) {
        return this.mMediaFactory.createVideo(path);
    }

    private static final class IncorrectInitializationException
    extends AndroidRuntimeException {
        private static final long serialVersionUID = 327389536289485672L;

        IncorrectInitializationException(String msg) {
            super(msg);
        }
    }
}

