/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.ArrowKeyMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.LeadingMarginSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;

public class RTEditorMovementMethod
extends ArrowKeyMovementMethod {
    private static RTEditorMovementMethod sInstance;
    private static Rect sLineBounds;

    public static synchronized MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new RTEditorMovementMethod();
        }
        return sInstance;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        ClickableSpan[] link;
        int index;
        int action = event.getAction();
        if ((action == 1 || action == 0) && (index = this.getCharIndexAt(widget, event)) != -1 && (link = (ClickableSpan[])buffer.getSpans(index, index, ClickableSpan.class)).length != 0) {
            if (action == 1) {
                link[0].onClick((View)widget);
            } else if (action == 0) {
                Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
            }
            return true;
        }
        return super.onTouchEvent(widget, buffer, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCharIndexAt(TextView textView, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= textView.getTotalPaddingLeft();
        y -= textView.getTotalPaddingTop();
        x += textView.getScrollX();
        Layout layout2 = textView.getLayout();
        int line = layout2.getLineForVertical(y += textView.getScrollY());
        Rect rect = sLineBounds;
        synchronized (rect) {
            layout2.getLineBounds(line, sLineBounds);
            if (!sLineBounds.contains(x, y)) {
                return -1;
            }
        }
        Spanned text = (Spanned)textView.getText();
        int lineStart = layout2.getLineStart(line);
        int lineEnd = layout2.getLineEnd(line);
        int lineLength = lineEnd - lineStart;
        if (lineLength == 0) {
            return -1;
        }
        Spanned lineText = (Spanned)text.subSequence(lineStart, lineEnd);
        int margin = 0;
        LeadingMarginSpan[] marginSpans = (LeadingMarginSpan[])lineText.getSpans(0, lineLength, LeadingMarginSpan.class);
        if (marginSpans != null) {
            for (LeadingMarginSpan span : marginSpans) {
                margin += span.getLeadingMargin(true);
            }
        }
        x -= margin;
        float[] widths = new float[lineLength];
        TextPaint paint = textView.getPaint();
        paint.getTextWidths((CharSequence)lineText, 0, lineLength, widths);
        float defaultSize = textView.getTextSize();
        float scaleFactor = 1.0f;
        AbsoluteSizeSpan[] absSpans = (AbsoluteSizeSpan[])lineText.getSpans(0, lineLength, AbsoluteSizeSpan.class);
        if (absSpans != null) {
            for (AbsoluteSizeSpan span : absSpans) {
                int spanStart = lineText.getSpanStart((Object)span);
                int spanEnd = lineText.getSpanEnd((Object)span);
                scaleFactor = (float)span.getSize() / defaultSize;
                int start = Math.max(lineStart, spanStart);
                int end = Math.min(lineEnd, spanEnd);
                int i = start;
                while (i < end) {
                    int n = i++;
                    widths[n] = widths[n] * scaleFactor;
                }
            }
        }
        float startChar = 0.0f;
        float endChar = 0.0f;
        for (int i = 0; i < lineLength; ++i) {
            startChar = endChar;
            if (!((endChar += widths[i]) >= (float)x)) continue;
            int index = lineStart + ((float)x - startChar < endChar - (float)x ? i : i + 1);
            return index;
        }
        return -1;
    }

    static {
        sLineBounds = new Rect();
    }
}

