/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003%&'B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0018\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0010H\u0002J\u0014\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ldroidninja/filepicker/adapters/FolderGridAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Ldroidninja/filepicker/adapters/FolderGridAdapter$PhotoViewHolder;", "context", "Landroid/content/Context;", "glide", "Lcom/bumptech/glide/RequestManager;", "items", "", "Ldroidninja/filepicker/models/PhotoDirectory;", "showCamera", "", "(Landroid/content/Context;Lcom/bumptech/glide/RequestManager;Ljava/util/List;Z)V", "folderGridAdapterListener", "Ldroidninja/filepicker/adapters/FolderGridAdapter$FolderGridAdapterListener;", "imageSize", "", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "getItemCount", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setColumnNumber", "columnNum", "setData", "newItems", "setFolderGridAdapterListener", "onClickListener", "Companion", "FolderGridAdapterListener", "PhotoViewHolder", "filepicker_release"})
public final class FolderGridAdapter
extends RecyclerView.Adapter<PhotoViewHolder> {
    private int imageSize;
    private FolderGridAdapterListener folderGridAdapterListener;
    private final Context context;
    private final RequestManager glide;
    @NotNull
    private List<PhotoDirectory> items;
    private final boolean showCamera;
    private static final int ITEM_TYPE_CAMERA;
    private static final int ITEM_TYPE_PHOTO;
    public static final Companion Companion;

    @NotNull
    public PhotoViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        View itemView;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_folder_layout, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
        return new PhotoViewHolder(view);
    }

    public int getItemViewType(int position) {
        return this.showCamera ? (position == 0 ? ITEM_TYPE_CAMERA : ITEM_TYPE_PHOTO) : ITEM_TYPE_PHOTO;
    }

    public void onBindViewHolder(@NotNull PhotoViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (this.getItemViewType(position) == ITEM_TYPE_PHOTO) {
            PhotoDirectory photoDirectory = this.items.get(this.showCamera ? position - 1 : position);
            if (AndroidLifecycleUtils.INSTANCE.canLoadImage(holder.getImageView().getContext())) {
                this.glide.load(photoDirectory.getCoverPath()).apply(((RequestOptions)RequestOptions.centerCropTransform().override(this.imageSize, this.imageSize)).placeholder(R.drawable.image_placeholder)).thumbnail(0.5f).into(holder.getImageView());
            }
            holder.getFolderTitle().setText((CharSequence)photoDirectory.getName());
            holder.getFolderCount().setText((CharSequence)String.valueOf(photoDirectory.getMedias().size()));
            holder.itemView.setOnClickListener(new View.OnClickListener(this, photoDirectory){
                final /* synthetic */ FolderGridAdapter this$0;
                final /* synthetic */ PhotoDirectory $photoDirectory;

                public final void onClick(View it) {
                    block0: {
                        FolderGridAdapterListener folderGridAdapterListener = FolderGridAdapter.access$getFolderGridAdapterListener$p(this.this$0);
                        if (folderGridAdapterListener == null) break block0;
                        folderGridAdapterListener.onFolderClicked(this.$photoDirectory);
                    }
                }
                {
                    this.this$0 = folderGridAdapter;
                    this.$photoDirectory = photoDirectory;
                }
            });
            holder.getBottomOverlay().setVisibility(0);
        } else {
            holder.getImageView().setImageResource(PickerManager.INSTANCE.getCameraDrawable());
            holder.itemView.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ FolderGridAdapter this$0;

                public final void onClick(View it) {
                    block0: {
                        FolderGridAdapterListener folderGridAdapterListener = FolderGridAdapter.access$getFolderGridAdapterListener$p(this.this$0);
                        if (folderGridAdapterListener == null) break block0;
                        folderGridAdapterListener.onCameraClicked();
                    }
                }
                {
                    this.this$0 = folderGridAdapter;
                }
            });
            holder.getBottomOverlay().setVisibility(8);
        }
    }

    public final void setData(@NotNull List<PhotoDirectory> newItems) {
        Intrinsics.checkNotNullParameter(newItems, (String)"newItems");
        this.items = newItems;
    }

    private final void setColumnNumber(Context context, int columnNum) {
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        this.imageSize = widthPixels / columnNum;
    }

    public int getItemCount() {
        return this.showCamera ? this.items.size() + 1 : this.items.size();
    }

    public final void setFolderGridAdapterListener(@NotNull FolderGridAdapterListener onClickListener) {
        Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
        this.folderGridAdapterListener = onClickListener;
    }

    @NotNull
    public final List<PhotoDirectory> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<PhotoDirectory> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.items = list;
    }

    public FolderGridAdapter(@NotNull Context context, @NotNull RequestManager glide, @NotNull List<PhotoDirectory> items, boolean showCamera) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)glide, (String)"glide");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.context = context;
        this.glide = glide;
        this.items = items;
        this.showCamera = showCamera;
        this.setColumnNumber(this.context, 3);
    }

    static {
        Companion = new Companion(null);
        ITEM_TYPE_CAMERA = 100;
        ITEM_TYPE_PHOTO = 101;
    }

    public static final /* synthetic */ FolderGridAdapterListener access$getFolderGridAdapterListener$p(FolderGridAdapter $this) {
        return $this.folderGridAdapterListener;
    }

    public static final /* synthetic */ void access$setFolderGridAdapterListener$p(FolderGridAdapter $this, FolderGridAdapterListener folderGridAdapterListener) {
        $this.folderGridAdapterListener = folderGridAdapterListener;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Ldroidninja/filepicker/adapters/FolderGridAdapter$FolderGridAdapterListener;", "", "onCameraClicked", "", "onFolderClicked", "photoDirectory", "Ldroidninja/filepicker/models/PhotoDirectory;", "filepicker_release"})
    public static interface FolderGridAdapterListener {
        public void onCameraClicked();

        public void onFolderClicked(@NotNull PhotoDirectory var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0007\"\u0004\b\u001a\u0010\u0004\u00a8\u0006\u001b"}, d2={"Ldroidninja/filepicker/adapters/FolderGridAdapter$PhotoViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "bottomOverlay", "getBottomOverlay", "()Landroid/view/View;", "setBottomOverlay", "folderCount", "Landroid/widget/TextView;", "getFolderCount", "()Landroid/widget/TextView;", "setFolderCount", "(Landroid/widget/TextView;)V", "folderTitle", "getFolderTitle", "setFolderTitle", "imageView", "Landroid/widget/ImageView;", "getImageView", "()Landroid/widget/ImageView;", "setImageView", "(Landroid/widget/ImageView;)V", "selectBg", "getSelectBg", "setSelectBg", "filepicker_release"})
    public static final class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private ImageView imageView;
        @NotNull
        private TextView folderTitle;
        @NotNull
        private TextView folderCount;
        @NotNull
        private View bottomOverlay;
        @NotNull
        private View selectBg;

        @NotNull
        public final ImageView getImageView() {
            return this.imageView;
        }

        public final void setImageView(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.imageView = imageView;
        }

        @NotNull
        public final TextView getFolderTitle() {
            return this.folderTitle;
        }

        public final void setFolderTitle(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.folderTitle = textView;
        }

        @NotNull
        public final TextView getFolderCount() {
            return this.folderCount;
        }

        public final void setFolderCount(@NotNull TextView textView) {
            Intrinsics.checkNotNullParameter((Object)textView, (String)"<set-?>");
            this.folderCount = textView;
        }

        @NotNull
        public final View getBottomOverlay() {
            return this.bottomOverlay;
        }

        public final void setBottomOverlay(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.bottomOverlay = view;
        }

        @NotNull
        public final View getSelectBg() {
            return this.selectBg;
        }

        public final void setSelectBg(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.selectBg = view;
        }

        public PhotoViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.iv_photo);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            this.imageView = (ImageView)view;
            View view2 = itemView.findViewById(R.id.folder_title);
            if (view2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.folderTitle = (TextView)view2;
            View view3 = itemView.findViewById(R.id.folder_count);
            if (view3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            this.folderCount = (TextView)view3;
            View view4 = itemView.findViewById(R.id.bottomOverlay);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"itemView.findViewById(R.id.bottomOverlay)");
            this.bottomOverlay = view4;
            View view5 = itemView.findViewById(R.id.transparent_bg);
            Intrinsics.checkNotNullExpressionValue((Object)view5, (String)"itemView.findViewById(R.id.transparent_bg)");
            this.selectBg = view5;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ldroidninja/filepicker/adapters/FolderGridAdapter$Companion;", "", "()V", "ITEM_TYPE_CAMERA", "", "getITEM_TYPE_CAMERA", "()I", "ITEM_TYPE_PHOTO", "getITEM_TYPE_PHOTO", "filepicker_release"})
    public static final class Companion {
        public final int getITEM_TYPE_CAMERA() {
            return ITEM_TYPE_CAMERA;
        }

        public final int getITEM_TYPE_PHOTO() {
            return ITEM_TYPE_PHOTO;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

