/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.net.Uri;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.R;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.FileType;
import droidninja.filepicker.models.sort.SortingTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\"2\u0006\u0010F\u001a\u00020\u0004J\u001c\u0010C\u001a\u00020D2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\"0H2\u0006\u0010F\u001a\u00020\u0004J\u0006\u0010I\u001a\u00020DJ\u000e\u0010J\u001a\u00020D2\u0006\u0010K\u001a\u00020\rJ\u0006\u0010L\u001a\u00020DJ\u0014\u0010M\u001a\u00020D2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\"0HJ\u000e\u0010N\u001a\u00020D2\u0006\u0010(\u001a\u00020\u0012J\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\r0!J\u0006\u0010P\u001a\u00020\u0004J\u001a\u0010Q\u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020S0!J\u0006\u0010T\u001a\u00020\u0012J\u0018\u0010U\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\"2\u0006\u0010F\u001a\u00020\u0004J\u0006\u0010V\u001a\u00020DJ\u000e\u0010W\u001a\u00020D2\u0006\u0010X\u001a\u00020\u0004J\u000e\u0010Y\u001a\u00020D2\u0006\u0010'\u001a\u00020\u0012J\u000e\u0010Z\u001a\u00020D2\u0006\u0010)\u001a\u00020\u0012J\u0006\u0010[\u001a\u00020\u0012J\u0006\u0010'\u001a\u00020\u0012J\u0006\u0010\\\u001a\u00020\u0012R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u001c\u0010\u0011\u001a\u00020\u00128FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001a\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u00020\u00048FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0!\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u000e\u0010'\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R&\u00100\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u000401X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0006\"\u0004\b9\u0010\bR\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u0006\"\u0004\bB\u0010\b\u00a8\u0006]"}, d2={"Ldroidninja/filepicker/PickerManager;", "", "()V", "cameraDrawable", "", "getCameraDrawable", "()I", "setCameraDrawable", "(I)V", "currentCount", "getCurrentCount", "fileTypes", "Ljava/util/LinkedHashSet;", "Ldroidninja/filepicker/models/FileType;", "imageFileSize", "getImageFileSize", "setImageFileSize", "isDocSupport", "", "()Z", "setDocSupport", "(Z)V", "isEnableCamera", "setEnableCamera", "isShowFolderView", "setShowFolderView", "isShowGif", "setShowGif", "maxCount", "orientation", "getOrientation", "setOrientation", "selectedFiles", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "getSelectedFiles", "()Ljava/util/ArrayList;", "selectedPhotos", "getSelectedPhotos", "showImages", "showSelectAll", "showVideos", "sortingType", "Ldroidninja/filepicker/models/sort/SortingTypes;", "getSortingType", "()Ldroidninja/filepicker/models/sort/SortingTypes;", "setSortingType", "(Ldroidninja/filepicker/models/sort/SortingTypes;)V", "spanTypes", "", "Ldroidninja/filepicker/FilePickerConst$SPAN_TYPE;", "getSpanTypes", "()Ljava/util/Map;", "setSpanTypes", "(Ljava/util/Map;)V", "theme", "getTheme", "setTheme", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "videoFileSize", "getVideoFileSize", "setVideoFileSize", "add", "", "path", "type", "paths", "", "addDocTypes", "addFileType", "fileType", "clearSelections", "deleteMedia", "enableSelectAll", "getFileTypes", "getMaxCount", "getSelectedFilePaths", "files", "Ldroidninja/filepicker/models/BaseFile;", "hasSelectAll", "remove", "reset", "setMaxCount", "count", "setShowImages", "setShowVideos", "shouldAdd", "showVideo", "filepicker_release"})
public final class PickerManager {
    private static int maxCount;
    private static boolean showImages;
    private static int cameraDrawable;
    @NotNull
    private static SortingTypes sortingType;
    @NotNull
    private static final ArrayList<Uri> selectedPhotos;
    @NotNull
    private static final ArrayList<Uri> selectedFiles;
    private static final LinkedHashSet<FileType> fileTypes;
    private static int theme;
    @Nullable
    private static String title;
    private static boolean showVideos;
    private static boolean isShowGif;
    private static boolean showSelectAll;
    private static int imageFileSize;
    private static int videoFileSize;
    private static boolean isDocSupport;
    private static boolean isEnableCamera;
    @NotNull
    private static Map<FilePickerConst.SPAN_TYPE, Integer> spanTypes;
    private static int orientation;
    private static boolean isShowFolderView;
    public static final PickerManager INSTANCE;

    public final int getCameraDrawable() {
        return cameraDrawable;
    }

    public final void setCameraDrawable(int n) {
        cameraDrawable = n;
    }

    @NotNull
    public final SortingTypes getSortingType() {
        return sortingType;
    }

    public final void setSortingType(@NotNull SortingTypes sortingTypes) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortingTypes), (String)"<set-?>");
        sortingType = sortingTypes;
    }

    @NotNull
    public final ArrayList<Uri> getSelectedPhotos() {
        return selectedPhotos;
    }

    @NotNull
    public final ArrayList<Uri> getSelectedFiles() {
        return selectedFiles;
    }

    public final int getTheme() {
        return theme;
    }

    public final void setTheme(int n) {
        theme = n;
    }

    @Nullable
    public final String getTitle() {
        return title;
    }

    public final void setTitle(@Nullable String string2) {
        title = string2;
    }

    public final boolean isShowGif() {
        return isShowGif;
    }

    public final void setShowGif(boolean bl) {
        isShowGif = bl;
    }

    public final int getImageFileSize() {
        return imageFileSize;
    }

    public final void setImageFileSize(int n) {
        imageFileSize = n;
    }

    public final int getVideoFileSize() {
        return videoFileSize;
    }

    public final void setVideoFileSize(int n) {
        videoFileSize = n;
    }

    public final boolean isDocSupport() {
        return isDocSupport;
    }

    public final void setDocSupport(boolean bl) {
        isDocSupport = bl;
    }

    public final boolean isEnableCamera() {
        return isEnableCamera;
    }

    public final void setEnableCamera(boolean bl) {
        isEnableCamera = bl;
    }

    @NotNull
    public final Map<FilePickerConst.SPAN_TYPE, Integer> getSpanTypes() {
        return spanTypes;
    }

    public final void setSpanTypes(@NotNull Map<FilePickerConst.SPAN_TYPE, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        spanTypes = map;
    }

    public final int getOrientation() {
        return orientation;
    }

    public final void setOrientation(int n) {
        orientation = n;
    }

    public final boolean isShowFolderView() {
        return isShowFolderView;
    }

    public final void setShowFolderView(boolean bl) {
        isShowFolderView = bl;
    }

    public final int getCurrentCount() {
        return selectedPhotos.size() + selectedFiles.size();
    }

    public final void setMaxCount(int count) {
        this.reset();
        maxCount = count;
    }

    public final int getMaxCount() {
        return maxCount;
    }

    public final void add(@Nullable Uri path, int type) {
        if (path != null && this.shouldAdd()) {
            if (!selectedPhotos.contains(path) && type == 1) {
                selectedPhotos.add(path);
            } else if (!selectedFiles.contains(path) && type == 2) {
                selectedFiles.add(path);
            } else {
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull List<? extends Uri> paths, int type) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        int n = 0;
        int n2 = ((Collection)paths).size();
        while (n < n2) {
            void index;
            this.add(paths.get((int)index), type);
            ++index;
        }
    }

    public final void remove(@Nullable Uri path, int type) {
        if (type == 1 && CollectionsKt.contains((Iterable)selectedPhotos, (Object)path)) {
            Collection collection = selectedPhotos;
            boolean bl = false;
            Collection collection2 = collection;
            if (collection2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection2).remove(path);
        } else if (type == 2) {
            Collection collection = selectedFiles;
            boolean bl = false;
            Collection collection3 = collection;
            if (collection3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
            }
            TypeIntrinsics.asMutableCollection((Object)collection3).remove(path);
        }
    }

    public final boolean shouldAdd() {
        return maxCount == -1 ? true : this.getCurrentCount() < maxCount;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ArrayList<Uri> getSelectedFilePaths(@NotNull ArrayList<BaseFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ArrayList<Uri> paths = new ArrayList<Uri>();
        int n = 0;
        int n2 = ((Collection)files).size();
        while (n < n2) {
            void index;
            paths.add(files.get((int)index).getPath());
            ++index;
        }
        return paths;
    }

    public final void reset() {
        selectedFiles.clear();
        selectedPhotos.clear();
        fileTypes.clear();
        maxCount = -1;
    }

    public final void clearSelections() {
        selectedPhotos.clear();
        selectedFiles.clear();
    }

    public final void deleteMedia(@NotNull List<? extends Uri> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        selectedPhotos.removeAll((Collection)paths);
    }

    public final boolean showVideo() {
        return showVideos;
    }

    public final void setShowVideos(boolean showVideos) {
        PickerManager.showVideos = showVideos;
    }

    public final boolean showImages() {
        return showImages;
    }

    public final void setShowImages(boolean showImages) {
        PickerManager.showImages = showImages;
    }

    public final void addFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        fileTypes.add(fileType);
    }

    public final void addDocTypes() {
        String[] pdfs = new String[]{"pdf"};
        fileTypes.add(new FileType("PDF", pdfs, R.drawable.icon_file_pdf));
        String[] docs = new String[]{"doc", "docx", "dot", "dotx"};
        fileTypes.add(new FileType("DOC", docs, R.drawable.icon_file_doc));
        String[] ppts = new String[]{"ppt", "pptx"};
        fileTypes.add(new FileType("PPT", ppts, R.drawable.icon_file_ppt));
        String[] xlss = new String[]{"xls", "xlsx"};
        fileTypes.add(new FileType("XLS", xlss, R.drawable.icon_file_xls));
        String[] txts = new String[]{"txt"};
        fileTypes.add(new FileType("TXT", txts, R.drawable.icon_file_unknown));
    }

    @NotNull
    public final ArrayList<FileType> getFileTypes() {
        return new ArrayList<FileType>((Collection)fileTypes);
    }

    public final boolean hasSelectAll() {
        return maxCount == -1 && showSelectAll;
    }

    public final void enableSelectAll(boolean showSelectAll) {
        PickerManager.showSelectAll = showSelectAll;
    }

    private PickerManager() {
    }

    static {
        PickerManager pickerManager;
        INSTANCE = pickerManager = new PickerManager();
        maxCount = -1;
        showImages = true;
        cameraDrawable = R.drawable.ic_camera;
        sortingType = SortingTypes.NONE;
        selectedPhotos = new ArrayList();
        selectedFiles = new ArrayList();
        fileTypes = new LinkedHashSet();
        theme = R.style.LibAppTheme;
        imageFileSize = Integer.MAX_VALUE;
        videoFileSize = Integer.MAX_VALUE;
        isDocSupport = true;
        isEnableCamera = true;
        spanTypes = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)FilePickerConst.SPAN_TYPE.FOLDER_SPAN), (Object)2), TuplesKt.to((Object)((Object)FilePickerConst.SPAN_TYPE.DETAIL_SPAN), (Object)3)});
        orientation = -1;
        isShowFolderView = true;
    }
}

