/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.BaseFilePickerActivity;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.PhotoGridAdapter;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.viewmodels.VMMediaPicker;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0015J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u001bH\u0002J\u0016\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Ldroidninja/filepicker/MediaDetailsActivity;", "Ldroidninja/filepicker/BaseFilePickerActivity;", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "()V", "emptyView", "Landroid/widget/TextView;", "fileType", "", "imageFileSize", "mGlideRequestManager", "Lcom/bumptech/glide/RequestManager;", "photoDirectory", "Ldroidninja/filepicker/models/PhotoDirectory;", "photoGridAdapter", "Ldroidninja/filepicker/adapters/PhotoGridAdapter;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "selectAllItem", "Landroid/view/MenuItem;", "videoFileSize", "viewModel", "Ldroidninja/filepicker/viewmodels/VMMediaPicker;", "getViewModel", "()Ldroidninja/filepicker/viewmodels/VMMediaPicker;", "setViewModel", "(Ldroidninja/filepicker/viewmodels/VMMediaPicker;)V", "initView", "", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onItemSelected", "onOptionsItemSelected", "item", "resumeRequestsIfNotDestroyed", "setTitle", "count", "setUpView", "updateList", "medias", "", "Ldroidninja/filepicker/models/Media;", "Companion", "filepicker_release"})
public final class MediaDetailsActivity
extends BaseFilePickerActivity
implements FileAdapterListener {
    private RecyclerView recyclerView;
    private TextView emptyView;
    private RequestManager mGlideRequestManager;
    private PhotoGridAdapter photoGridAdapter;
    private int fileType;
    private int imageFileSize = Integer.MAX_VALUE;
    private int videoFileSize = Integer.MAX_VALUE;
    private MenuItem selectAllItem;
    private PhotoDirectory photoDirectory;
    @NotNull
    public VMMediaPicker viewModel;
    private static final int SCROLL_THRESHOLD;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public final VMMediaPicker getViewModel() {
        VMMediaPicker vMMediaPicker = this.viewModel;
        if (vMMediaPicker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return vMMediaPicker;
    }

    public final void setViewModel(@NotNull VMMediaPicker vMMediaPicker) {
        Intrinsics.checkNotNullParameter((Object)((Object)vMMediaPicker), (String)"<set-?>");
        this.viewModel = vMMediaPicker;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, R.layout.activity_media_details);
    }

    @Override
    protected void initView() {
        ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelProvider.AndroidViewModelFactory(this.getApplication())).get(VMMediaPicker.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(this, \u2026MMediaPicker::class.java)");
        this.viewModel = (VMMediaPicker)viewModel;
        RequestManager requestManager = Glide.with((FragmentActivity)((FragmentActivity)this));
        Intrinsics.checkNotNullExpressionValue((Object)requestManager, (String)"Glide.with(this)");
        this.mGlideRequestManager = requestManager;
        Intent intent2 = this.getIntent();
        if (intent2 != null) {
            this.fileType = intent2.getIntExtra("EXTRA_FILE_TYPE", 1);
            this.imageFileSize = intent2.getIntExtra("EXTRA_IMAGE_FILE_SIZE", Integer.MAX_VALUE);
            this.videoFileSize = intent2.getIntExtra("EXTRA__VIDEO_FILE_SIZE", Integer.MAX_VALUE);
            this.photoDirectory = (PhotoDirectory)intent2.getParcelableExtra(PhotoDirectory.class.getSimpleName());
            if (this.photoDirectory != null) {
                this.setUpView();
                this.setTitle(0);
            }
        }
    }

    public void setTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            int maxCount = PickerManager.INSTANCE.getMaxCount();
            if (maxCount == -1 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = this.getString(R.string.attachments_num);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.attachments_num)");
                String string3 = string2;
                Object[] objectArray = new Object[]{count};
                boolean bl = false;
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                actionBar.setTitle((CharSequence)string4);
            } else if (maxCount > 0 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string5 = this.getString(R.string.attachments_title_text);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(R.string.attachments_title_text)");
                String string6 = string5;
                Object[] objectArray = new Object[]{count, maxCount};
                boolean bl = false;
                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
                actionBar.setTitle((CharSequence)string7);
            } else {
                PhotoDirectory photoDirectory = this.photoDirectory;
                actionBar.setTitle((CharSequence)(photoDirectory != null ? photoDirectory.getName() : null));
            }
        }
    }

    private final void setUpView() {
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)this.findViewById(R.id.empty_view);
        Integer n = PickerManager.INSTANCE.getSpanTypes().get((Object)FilePickerConst.SPAN_TYPE.DETAIL_SPAN);
        int spanCount = n != null ? n : 3;
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(spanCount, 1);
        layoutManager.setGapStrategy(2);
        RecyclerView recyclerView = this.recyclerView;
        if (recyclerView != null) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        }
        RecyclerView recyclerView2 = this.recyclerView;
        if (recyclerView2 != null) {
            recyclerView2.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        }
        RecyclerView recyclerView3 = this.recyclerView;
        if (recyclerView3 != null) {
            recyclerView3.addOnScrollListener(new RecyclerView.OnScrollListener(this){
                final /* synthetic */ MediaDetailsActivity this$0;

                public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                    Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                    super.onScrolled(recyclerView, dx, dy);
                    if (Math.abs(dy) > MediaDetailsActivity.access$getSCROLL_THRESHOLD$cp()) {
                        MediaDetailsActivity.access$getMGlideRequestManager$p(this.this$0).pauseRequests();
                    } else {
                        MediaDetailsActivity.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }

                public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                    Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                    if (newState == 0) {
                        MediaDetailsActivity.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
        VMMediaPicker vMMediaPicker = this.viewModel;
        if (vMMediaPicker == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        vMMediaPicker.getLvMediaData().observe((LifecycleOwner)this, (Observer)new Observer<List<? extends Media>>(this){
            final /* synthetic */ MediaDetailsActivity this$0;

            public final void onChanged(List<Media> data) {
                List<Media> list = data;
                Intrinsics.checkNotNullExpressionValue(list, (String)"data");
                MediaDetailsActivity.access$updateList(this.this$0, list);
            }
            {
                this.this$0 = mediaDetailsActivity;
            }
        });
        VMMediaPicker vMMediaPicker2 = this.viewModel;
        if (vMMediaPicker2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        PhotoDirectory photoDirectory = this.photoDirectory;
        vMMediaPicker2.getMedia(photoDirectory != null ? photoDirectory.getBucketId() : null, this.fileType, this.imageFileSize, this.videoFileSize);
    }

    private final void updateList(List<Media> medias) {
        Collection collection = medias;
        boolean bl = false;
        if (!collection.isEmpty()) {
            TextView textView = this.emptyView;
            if (textView != null) {
                textView.setVisibility(8);
            }
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setVisibility(0);
            }
        } else {
            TextView textView = this.emptyView;
            if (textView != null) {
                textView.setVisibility(0);
            }
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setVisibility(8);
            }
            return;
        }
        if (this.photoGridAdapter != null) {
            PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
            if (photoGridAdapter != null) {
                photoGridAdapter.setData(medias, (List<Uri>)PickerManager.INSTANCE.getSelectedPhotos());
            }
        } else {
            Context context = (Context)this;
            RequestManager requestManager = this.mGlideRequestManager;
            if (requestManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
            }
            this.photoGridAdapter = new PhotoGridAdapter(context, requestManager, medias, (List<Uri>)PickerManager.INSTANCE.getSelectedPhotos(), false, this);
            RecyclerView recyclerView = this.recyclerView;
            if (recyclerView != null) {
                recyclerView.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            }
        }
        if (PickerManager.INSTANCE.getMaxCount() == -1) {
            if (this.photoGridAdapter != null && this.selectAllItem != null) {
                PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
                PhotoGridAdapter photoGridAdapter2 = this.photoGridAdapter;
                if (Intrinsics.areEqual((Object)(photoGridAdapter != null ? Integer.valueOf(photoGridAdapter.getItemCount()) : null), (Object)(photoGridAdapter2 != null ? Integer.valueOf(photoGridAdapter2.getSelectedItemCount()) : null))) {
                    MenuItem menuItem = this.selectAllItem;
                    if (menuItem != null) {
                        menuItem.setIcon(R.drawable.ic_select_all);
                    }
                    MenuItem menuItem2 = this.selectAllItem;
                    if (menuItem2 != null) {
                        menuItem2.setChecked(true);
                    }
                }
            }
            this.setTitle(PickerManager.INSTANCE.getCurrentCount());
        }
    }

    private final void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.INSTANCE.canLoadImage((Activity)this)) {
            return;
        }
        RequestManager requestManager = this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        requestManager.resumeRequests();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
            this.getMenuInflater().inflate(R.menu.media_detail_menu, menu2);
            MenuItem menuItem = this.selectAllItem = menu2.findItem(R.id.action_select);
            if (menuItem != null) {
                menuItem.setVisible(PickerManager.INSTANCE.hasSelectAll());
            }
            MenuItem menuItem2 = menu2.findItem(R.id.action_done);
            if (menuItem2 == null) break block1;
            menuItem2.setVisible(PickerManager.INSTANCE.getMaxCount() > 1);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int itemId = item.getItemId();
        if (itemId == R.id.action_done) {
            this.setResult(-1, null);
            this.finish();
            return true;
        }
        if (itemId == R.id.action_select) {
            MenuItem menuItem = this.selectAllItem;
            if (menuItem != null) {
                MenuItem menuItem2 = menuItem;
                boolean bl = false;
                boolean bl2 = false;
                MenuItem it = menuItem2;
                boolean bl3 = false;
                PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
                if (photoGridAdapter != null) {
                    PhotoGridAdapter photoGridAdapter2 = photoGridAdapter;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    PhotoGridAdapter adapter = photoGridAdapter2;
                    boolean bl6 = false;
                    if (it.isChecked()) {
                        PickerManager.INSTANCE.deleteMedia(adapter.getSelectedPaths());
                        adapter.clearSelection();
                        it.setIcon(R.drawable.ic_deselect_all);
                    } else {
                        adapter.selectAll();
                        PickerManager.INSTANCE.add(adapter.getSelectedPaths(), 1);
                        it.setIcon(R.drawable.ic_select_all);
                    }
                    it.setChecked(!it.isChecked());
                    this.setTitle(PickerManager.INSTANCE.getCurrentCount());
                }
            }
            return true;
        }
        if (itemId == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemSelected() {
        int maxCount = PickerManager.INSTANCE.getMaxCount();
        if (maxCount == 1) {
            this.setResult(-1, null);
            this.finish();
        }
        this.setTitle(PickerManager.INSTANCE.getCurrentCount());
    }

    public void onBackPressed() {
        this.setResult(0, null);
        this.finish();
    }

    static {
        Companion = new Companion(null);
        SCROLL_THRESHOLD = 30;
    }

    public static final /* synthetic */ int access$getSCROLL_THRESHOLD$cp() {
        return SCROLL_THRESHOLD;
    }

    public static final /* synthetic */ RequestManager access$getMGlideRequestManager$p(MediaDetailsActivity $this) {
        RequestManager requestManager = $this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
        }
        return requestManager;
    }

    public static final /* synthetic */ void access$setMGlideRequestManager$p(MediaDetailsActivity $this, RequestManager requestManager) {
        $this.mGlideRequestManager = requestManager;
    }

    public static final /* synthetic */ void access$resumeRequestsIfNotDestroyed(MediaDetailsActivity $this) {
        $this.resumeRequestsIfNotDestroyed();
    }

    public static final /* synthetic */ void access$updateList(MediaDetailsActivity $this, List medias) {
        $this.updateList(medias);
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldroidninja/filepicker/MediaDetailsActivity$Companion;", "", "()V", "SCROLL_THRESHOLD", "", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

