/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.adapters;

import android.content.Context;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.RequestOptions;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.BaseFile;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.views.SmoothCheckBox;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 &2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002&'BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0003H\u0002J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0013J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0015H\u0002R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ldroidninja/filepicker/adapters/PhotoGridAdapter;", "Ldroidninja/filepicker/adapters/SelectableAdapter;", "Ldroidninja/filepicker/adapters/PhotoGridAdapter$PhotoViewHolder;", "Ldroidninja/filepicker/models/Media;", "context", "Landroid/content/Context;", "glide", "Lcom/bumptech/glide/RequestManager;", "medias", "", "selectedPaths", "", "Landroid/net/Uri;", "showCamera", "", "mListener", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "(Landroid/content/Context;Lcom/bumptech/glide/RequestManager;Ljava/util/List;Ljava/util/List;ZLdroidninja/filepicker/adapters/FileAdapterListener;)V", "cameraOnClickListener", "Landroid/view/View$OnClickListener;", "imageSize", "", "getItemCount", "getItemViewType", "position", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onItemClicked", "media", "setCameraListener", "onClickListener", "setColumnNumber", "columnNum", "Companion", "PhotoViewHolder", "filepicker_release"})
public final class PhotoGridAdapter
extends SelectableAdapter<PhotoViewHolder, Media> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RequestManager glide;
    private final boolean showCamera;
    @Nullable
    private final FileAdapterListener mListener;
    private int imageSize;
    @Nullable
    private View.OnClickListener cameraOnClickListener;
    private static final int ITEM_TYPE_CAMERA = 100;
    private static final int ITEM_TYPE_PHOTO = 101;

    public PhotoGridAdapter(@NotNull Context context, @NotNull RequestManager glide, @NotNull List<Media> medias, @NotNull List<Uri> selectedPaths, boolean showCamera, @Nullable FileAdapterListener mListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)glide, (String)"glide");
        Intrinsics.checkNotNullParameter(medias, (String)"medias");
        Intrinsics.checkNotNullParameter(selectedPaths, (String)"selectedPaths");
        super(medias, selectedPaths);
        this.context = context;
        this.glide = glide;
        this.showCamera = showCamera;
        this.mListener = mListener;
        this.setColumnNumber(this.context, 3);
    }

    @NotNull
    public PhotoViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View itemView = LayoutInflater.from((Context)this.context).inflate(R.layout.item_photo_layout, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemView, (String)"itemView");
        return new PhotoViewHolder(itemView);
    }

    public int getItemViewType(int position) {
        return this.showCamera ? (position == 0 ? ITEM_TYPE_CAMERA : ITEM_TYPE_PHOTO) : ITEM_TYPE_PHOTO;
    }

    public void onBindViewHolder(@NotNull PhotoViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        if (this.getItemViewType(position) == ITEM_TYPE_PHOTO) {
            Media media = (Media)this.getItems().get(this.showCamera ? position - 1 : position);
            if (AndroidLifecycleUtils.INSTANCE.canLoadImage(holder.getImageView().getContext())) {
                this.glide.load(media.getPath()).apply(((RequestOptions)RequestOptions.centerCropTransform().override(this.imageSize, this.imageSize)).placeholder(R.drawable.image_placeholder)).thumbnail(0.5f).into(holder.getImageView());
            }
            if (media.getMediaType() == 3) {
                holder.getVideoIcon().setVisibility(0);
            } else {
                holder.getVideoIcon().setVisibility(8);
            }
            holder.itemView.setOnClickListener(arg_0 -> PhotoGridAdapter.onBindViewHolder$lambda-0(this, holder, media, arg_0));
            holder.getCheckBox().setVisibility(8);
            holder.getCheckBox().setOnCheckedChangeListener(null);
            holder.getCheckBox().setOnClickListener(arg_0 -> PhotoGridAdapter.onBindViewHolder$lambda-1(this, holder, media, arg_0));
            holder.getCheckBox().setChecked(this.isSelected((BaseFile)media));
            holder.getSelectBg().setVisibility(this.isSelected((BaseFile)media) ? 0 : 8);
            holder.getCheckBox().setVisibility(this.isSelected((BaseFile)media) ? 0 : 8);
            holder.getCheckBox().setOnCheckedChangeListener(new SmoothCheckBox.OnCheckedChangeListener(this, media, holder){
                final /* synthetic */ PhotoGridAdapter this$0;
                final /* synthetic */ Media $media;
                final /* synthetic */ PhotoViewHolder $holder;
                {
                    this.this$0 = $receiver;
                    this.$media = $media;
                    this.$holder = $holder;
                }

                public void onCheckedChanged(@NotNull SmoothCheckBox checkBox, boolean isChecked) {
                    Intrinsics.checkNotNullParameter((Object)((Object)checkBox), (String)"checkBox");
                    this.this$0.toggleSelection((BaseFile)this.$media);
                    this.$holder.getSelectBg().setVisibility(isChecked ? 0 : 8);
                    if (isChecked) {
                        this.$holder.getCheckBox().setVisibility(0);
                        PickerManager.INSTANCE.add(this.$media.getPath(), 1);
                    } else {
                        this.$holder.getCheckBox().setVisibility(8);
                        PickerManager.INSTANCE.remove(this.$media.getPath(), 1);
                    }
                    FileAdapterListener fileAdapterListener = PhotoGridAdapter.access$getMListener$p(this.this$0);
                    if (fileAdapterListener != null) {
                        fileAdapterListener.onItemSelected();
                    }
                }
            });
        } else {
            holder.getImageView().setImageResource(PickerManager.INSTANCE.getCameraDrawable());
            holder.getCheckBox().setVisibility(8);
            holder.itemView.setOnClickListener(this.cameraOnClickListener);
            holder.getVideoIcon().setVisibility(8);
        }
    }

    private final void onItemClicked(PhotoViewHolder holder, Media media) {
        if (PickerManager.INSTANCE.getMaxCount() == 1) {
            PickerManager.INSTANCE.add(media.getPath(), 1);
            FileAdapterListener fileAdapterListener = this.mListener;
            if (fileAdapterListener != null) {
                fileAdapterListener.onItemSelected();
            }
        } else if (holder.getCheckBox().isChecked() || PickerManager.INSTANCE.shouldAdd()) {
            holder.getCheckBox().setChecked(!holder.getCheckBox().isChecked(), true);
        }
    }

    private final void setColumnNumber(Context context, int columnNum) {
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        this.imageSize = widthPixels / columnNum;
    }

    public int getItemCount() {
        return this.showCamera ? this.getItems().size() + 1 : this.getItems().size();
    }

    public final void setCameraListener(@NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkNotNullParameter((Object)onClickListener, (String)"onClickListener");
        this.cameraOnClickListener = onClickListener;
    }

    private static final void onBindViewHolder$lambda-0(PhotoGridAdapter this$0, PhotoViewHolder $holder, Media $media, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$holder), (String)"$holder");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.onItemClicked($holder, $media);
    }

    private static final void onBindViewHolder$lambda-1(PhotoGridAdapter this$0, PhotoViewHolder $holder, Media $media, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$holder), (String)"$holder");
        Intrinsics.checkNotNullParameter((Object)$media, (String)"$media");
        this$0.onItemClicked($holder, $media);
    }

    public static final /* synthetic */ FileAdapterListener access$getMListener$p(PhotoGridAdapter $this) {
        return $this.mListener;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0004R\u001a\u0010\u0015\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000e\"\u0004\b\u0017\u0010\u0010\u00a8\u0006\u0018"}, d2={"Ldroidninja/filepicker/adapters/PhotoGridAdapter$PhotoViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "checkBox", "Ldroidninja/filepicker/views/SmoothCheckBox;", "getCheckBox", "()Ldroidninja/filepicker/views/SmoothCheckBox;", "setCheckBox", "(Ldroidninja/filepicker/views/SmoothCheckBox;)V", "imageView", "Landroid/widget/ImageView;", "getImageView", "()Landroid/widget/ImageView;", "setImageView", "(Landroid/widget/ImageView;)V", "selectBg", "getSelectBg", "()Landroid/view/View;", "setSelectBg", "videoIcon", "getVideoIcon", "setVideoIcon", "filepicker_release"})
    public static final class PhotoViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private SmoothCheckBox checkBox;
        @NotNull
        private ImageView imageView;
        @NotNull
        private ImageView videoIcon;
        @NotNull
        private View selectBg;

        public PhotoViewHolder(@NotNull View itemView) {
            Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
            super(itemView);
            View view = itemView.findViewById(R.id.checkbox);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type droidninja.filepicker.views.SmoothCheckBox");
            }
            this.checkBox = (SmoothCheckBox)view;
            view = itemView.findViewById(R.id.iv_photo);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            this.imageView = (ImageView)view;
            view = itemView.findViewById(R.id.video_icon);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            this.videoIcon = (ImageView)view;
            view = itemView.findViewById(R.id.transparent_bg);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView.findViewById(R.id.transparent_bg)");
            this.selectBg = view;
        }

        @NotNull
        public final SmoothCheckBox getCheckBox() {
            return this.checkBox;
        }

        public final void setCheckBox(@NotNull SmoothCheckBox smoothCheckBox) {
            Intrinsics.checkNotNullParameter((Object)((Object)smoothCheckBox), (String)"<set-?>");
            this.checkBox = smoothCheckBox;
        }

        @NotNull
        public final ImageView getImageView() {
            return this.imageView;
        }

        public final void setImageView(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.imageView = imageView;
        }

        @NotNull
        public final ImageView getVideoIcon() {
            return this.videoIcon;
        }

        public final void setVideoIcon(@NotNull ImageView imageView) {
            Intrinsics.checkNotNullParameter((Object)imageView, (String)"<set-?>");
            this.videoIcon = imageView;
        }

        @NotNull
        public final View getSelectBg() {
            return this.selectBg;
        }

        public final void setSelectBg(@NotNull View view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"<set-?>");
            this.selectBg = view;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ldroidninja/filepicker/adapters/PhotoGridAdapter$Companion;", "", "()V", "ITEM_TYPE_CAMERA", "", "getITEM_TYPE_CAMERA", "()I", "ITEM_TYPE_PHOTO", "getITEM_TYPE_PHOTO", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getITEM_TYPE_CAMERA() {
            return ITEM_TYPE_CAMERA;
        }

        public final int getITEM_TYPE_PHOTO() {
            return ITEM_TYPE_PHOTO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

