/*
 * Decompiled with CFR 0.152.
 */
package ch.qoqa.glide.svg;

import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.SimpleResource;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lch/qoqa/glide/svg/SvgInputStreamDecoder;", "Lcom/bumptech/glide/load/ResourceDecoder;", "Ljava/io/InputStream;", "Lcom/caverock/androidsvg/SVG;", "()V", "decode", "Lcom/bumptech/glide/load/engine/Resource;", "source", "width", "", "height", "options", "Lcom/bumptech/glide/load/Options;", "handles", "", "library_release"})
public final class SvgInputStreamDecoder
implements ResourceDecoder<InputStream, SVG> {
    public boolean handles(@NotNull InputStream source, @NotNull Options options) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return true;
    }

    @Nullable
    public Resource<SVG> decode(@NotNull InputStream source, int width, int height, @NotNull Options options) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        try {
            SVG svg;
            SVG sVG = svg = SVG.getFromInputStream((InputStream)source);
            Intrinsics.checkExpressionValueIsNotNull((Object)sVG, (String)"svg");
            if (sVG.getDocumentViewBox() == null) {
                svg.setDocumentViewBox(0.0f, 0.0f, svg.getDocumentWidth(), svg.getDocumentHeight());
            }
            svg.setDocumentWidth((float)width);
            svg.setDocumentHeight((float)height);
            return (Resource)new SimpleResource((Object)svg);
        }
        catch (SVGParseException ex) {
            throw (Throwable)new IOException("Cannot load SVG from stream", ex);
        }
    }
}

