/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.utils;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    private static final Logger log = LoggerFactory.getLogger(ShellUtil.class);

    public static void execShell(String shell) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<String> errList = new ArrayList<String>();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(shell);
            process.waitFor();
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            InputStreamReader err = new InputStreamReader(process.getErrorStream());
            LineNumberReader input = new LineNumberReader(ir);
            LineNumberReader errInput = new LineNumberReader(err);
            while ((line = input.readLine()) != null) {
                strList.add(line);
            }
            while ((line = errInput.readLine()) != null) {
                errList.add(line);
            }
            process.destroy();
            ir.close();
            err.close();
            input.close();
            errInput.close();
        }
        catch (Exception e) {
            log.error("\u8fd0\u884cshell\u811a\u672c\u5931\u8d25:", (Throwable)e);
        }
        log.debug("\u6267\u884c {} ", (Object)shell);
        log.debug("\u6267\u884c\u7ed3\u679c\uff1a{}  ", strList);
        log.debug("\u811a\u672c\u9519\u8bef\u4fe1\u606f\uff1a{}", errList);
    }

    public static void execShellBin(String shell) {
        try {
            Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shell}, null, null);
        }
        catch (Exception e) {
            log.error("\u8fd0\u884cshell\u811a\u672c\u5931\u8d25:", (Throwable)e);
        }
    }

    public static List<String> runShell(String shStr) {
        ArrayList<String> strList = new ArrayList<String>();
        ArrayList<String> errList = new ArrayList<String>();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shStr}, null, null);
            InputStreamReader ir = new InputStreamReader(process.getInputStream());
            InputStreamReader err = new InputStreamReader(process.getErrorStream());
            LineNumberReader input = new LineNumberReader(ir);
            LineNumberReader errInput = new LineNumberReader(err);
            while ((line = input.readLine()) != null) {
                strList.add(line);
            }
            while ((line = errInput.readLine()) != null) {
                errList.add(line);
            }
            process.destroy();
            ir.close();
            err.close();
            input.close();
            errInput.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.debug("\u6267\u884c {} ", (Object)shStr);
        log.debug("\u6267\u884c\u7ed3\u679c\uff1a{}  ", strList);
        log.debug("\u811a\u672c\u9519\u8bef\u4fe1\u606f\uff1a{}", errList);
        return strList;
    }
}

