/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.utils;

import cn.hutool.json.JSONUtil;
import com.tugos.dst.admin.utils.DstConfigData;
import com.tugos.dst.admin.utils.DstConfigDataTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBUtils {
    private static final Logger log = LoggerFactory.getLogger(DBUtils.class);

    public static String readProjectData(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try (FileInputStream inputStream = new FileInputStream(file);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)inputStream).read(buf)) != -1) {
                sb.append(new String(buf, 0, len));
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u9879\u76ee\u76ee\u5f55\u7684\u6587\u4ef6\u5931\u8d25:", (Throwable)e);
        }
        return sb.toString();
    }

    private static void writeProjectData(String fileName, String data) {
        File file = new File(fileName);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            ((OutputStream)outputStream).write(data.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            log.error("\u5199\u5165\u6570\u636e\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static void readDataToCache(String data) {
        try {
            if (StringUtils.isNotBlank((CharSequence)data)) {
                DstConfigDataTable table = (DstConfigDataTable)JSONUtil.toBean((String)data, DstConfigDataTable.class);
                DstConfigData.clearAllData();
                DstConfigData.SCHEDULE_BACKUP_MAP.putAll(table.getSCHEDULE_BACKUP_MAP());
                DstConfigData.SCHEDULE_UPDATE_MAP.putAll(table.getSCHEDULE_UPDATE_MAP());
                BeanUtils.copyProperties((Object)table.getUSER_INFO(), (Object)DstConfigData.USER_INFO);
                DstConfigData.notStartMaster = table.getNotStartMaster();
                DstConfigData.notStartCaves = table.getNotStartCaves();
                DstConfigData.smartUpdate = table.getSmartUpdate();
                DstConfigData.masterPort = table.getMasterPort();
                DstConfigData.groundPort = table.getGroundPort();
                DstConfigData.cavesPort = table.getCavesPort();
                log.info("\u8bfb\u53d6\u6587\u4ef6\u4e2d\u7684\u6570\u636e\u5230\u7f13\u5b58\u4e2d\u6210\u529f\uff1a{}", (Object)data);
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u4e2d\u7684\u6570\u636e\u5230\u7f13\u5b58\u4e2d\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static void saveDataToFile() {
        try {
            DstConfigDataTable table = new DstConfigDataTable();
            table.setSCHEDULE_BACKUP_MAP(DstConfigData.SCHEDULE_BACKUP_MAP);
            table.setSCHEDULE_UPDATE_MAP(DstConfigData.SCHEDULE_UPDATE_MAP);
            table.setUSER_INFO(DstConfigData.USER_INFO);
            table.setNotStartMaster(DstConfigData.notStartMaster);
            table.setNotStartCaves(DstConfigData.notStartCaves);
            table.setSmartUpdate(DstConfigData.smartUpdate);
            table.setMasterPort(DstConfigData.masterPort);
            table.setGroundPort(DstConfigData.groundPort);
            table.setCavesPort(DstConfigData.cavesPort);
            String data = JSONUtil.toJsonStr((Object)table);
            DBUtils.writeProjectData((String)".dst_admin_db.json", (String)data);
        }
        catch (Exception e) {
            log.error("\u5c06\u7f13\u5b58\u4e2d\u7684\u6570\u636e\u4fdd\u5b58\u5230\u672c\u5730\u6587\u4ef6\u4e2d\u5931\u8d25\uff1a", (Throwable)e);
        }
    }
}

