/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.service;

import com.tugos.dst.admin.common.ResultCodeEnum;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.enums.DstLogTypeEnum;
import com.tugos.dst.admin.service.SystemService;
import com.tugos.dst.admin.utils.DstConstant;
import com.tugos.dst.admin.utils.FileUtils;
import com.tugos.dst.admin.utils.ModFileUtil;
import com.tugos.dst.admin.utils.ShellUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShellService {
    private static final Logger log = LoggerFactory.getLogger(ShellService.class);
    public static final int MAX_SLEEP_SECOND = 10;
    private SystemService systemService;

    public boolean getMasterStatus() {
        String masterProcessNum = this.getMasterProcessNum();
        return StringUtils.isNotBlank((CharSequence)masterProcessNum);
    }

    public boolean getCavesStatus() {
        String cavesProcessNum = this.getCavesProcessNum();
        return StringUtils.isNotBlank((CharSequence)cavesProcessNum);
    }

    public String getMasterProcessNum() {
        List result = ShellUtil.runShell((String)" ps -ef | grep -v grep |grep 'Master'|sed -n '1P'|awk '{print $2}' ");
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            return (String)result.get(0);
        }
        return null;
    }

    public String getCavesProcessNum() {
        List result = ShellUtil.runShell((String)" ps -ef | grep -v grep |grep 'Caves'|sed -n '1P'|awk '{print $2}' ");
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            return (String)result.get(0);
        }
        return null;
    }

    @Deprecated
    public void createBackup(String fileName) {
        StringBuilder command = new StringBuilder();
        command.append("cd $HOME/.klei/DoNotStarveTogether ").append(" ; ");
        command.append("tar zcvf ").append(fileName).append(" MyDediServer/");
        ShellUtil.runShell((String)command.toString());
    }

    public void revertBackup(String fileName) {
        StringBuilder command = new StringBuilder();
        command.append("cd ~/.klei/DoNotStarveTogether ").append(" ; ");
        command.append("rm -rf MyDediServer/").append(" ;");
        command.append("tar -xvf ").append(fileName);
        ShellUtil.runShell((String)command.toString());
    }

    public List<String> getBackupList() {
        String backupPath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether";
        File file = new File(backupPath);
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        List files = FileUtils.getFileNames((String)backupPath);
        if (CollectionUtils.isNotEmpty((Collection)files)) {
            return files.stream().filter(e -> e.contains(".tar")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<String> startMaster() {
        ResultVO stringResultVO = this.installModToServer();
        log.info("\u5b89\u88c5mod\uff1a{}", (Object)stringResultVO);
        return ShellUtil.runShell((String)"cd ~/dst/bin/ ; screen -d -m -S \"DST_MASTER\"  ./dontstarve_dedicated_server_nullrenderer -console -cluster MyDediServer -shard Master  ;");
    }

    public List<String> startCaves() {
        return ShellUtil.runShell((String)"cd ~/dst/bin/ ; screen -d -m -S \"DST_CAVES\"  ./dontstarve_dedicated_server_nullrenderer -console -cluster MyDediServer -shard Caves ;");
    }

    public List<String> stopMaster() {
        return ShellUtil.runShell((String)"ps -ef | grep -v grep |grep 'Master' |sed -n '1P'|awk '{print $2}' |xargs kill -9");
    }

    public List<String> stopCaves() {
        return ShellUtil.runShell((String)"ps -ef | grep -v grep |grep 'Caves' |sed -n '1P'|awk '{print $2}' |xargs kill -9");
    }

    public void elegantShutdownMaster() {
        this.shutdownMaster();
        if (this.getMasterStatus()) {
            for (int i = 0; this.getMasterStatus() && i != 10; ++i) {
                this.sleep(1);
            }
        }
        this.stopMaster();
    }

    public void elegantShutdownCaves() {
        this.shutdownCaves();
        if (this.getCavesStatus()) {
            for (int i = 0; this.getCavesStatus() && i != 10; ++i) {
                this.sleep(1);
            }
        }
        this.stopCaves();
    }

    private void shutdownMaster() {
        String shell = "screen -S \"DST_MASTER\" -p 0 -X stuff \"c_shutdown(true)\\n\"";
        ShellUtil.execShellBin((String)shell);
    }

    private void shutdownCaves() {
        String shell = "screen -S \"DST_CAVES\" -p 0 -X stuff \"c_shutdown(true)\\n\"";
        ShellUtil.execShellBin((String)shell);
    }

    public List<String> updateGame() {
        this.elegantShutdownMaster();
        this.elegantShutdownCaves();
        return ShellUtil.runShell((String)"cd ~/steamcmd ; ./steamcmd.sh +login anonymous +force_install_dir ~/dst +app_update 343050 validate +quit");
    }

    public void sleep(int seconds) {
        try {
            TimeUnit.SECONDS.sleep(seconds);
        }
        catch (InterruptedException e) {
            log.error("\u7761\u7720\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void clearScreen() {
        ShellUtil.runShell((String)"screen -wipe ");
    }

    public List<String> delMasterRecord() {
        this.stopMaster();
        return ShellUtil.runShell((String)"rm -r ~/.klei/DoNotStarveTogether/MyDediServer/Master/save");
    }

    public List<String> delCavesRecord() {
        this.stopCaves();
        return ShellUtil.runShell((String)"rm -r ~/.klei/DoNotStarveTogether/MyDediServer/Caves/save");
    }

    public ResultVO<String> installModToServer() {
        String serverModPath;
        log.info("\u5b89\u88c5mod\u5230\u670d\u52a1\u5668.....");
        String myGameModPath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/modoverrides.lua";
        File file = new File(myGameModPath);
        if (!file.exists()) {
            return ResultVO.fail((String)"mod\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        List modConfig = ModFileUtil.readModConfigFile((String)myGameModPath);
        boolean flag = ModFileUtil.writeModConfigFile((List)modConfig, (String)(serverModPath = DstConstant.ROOT_PATH + "/" + "dst/mods/dedicated_server_mods_setup.lua"));
        if (flag) {
            return ResultVO.success();
        }
        return ResultVO.fail((String)"\u5b89\u88c5mod\u5931\u8d25");
    }

    public void sendBroadcast(String message) {
        StringBuilder masterBroadcast = new StringBuilder();
        masterBroadcast.append("screen -S \"DST_MASTER\" -p 0 -X stuff \"c_announce(\\\"");
        masterBroadcast.append(message);
        masterBroadcast.append("\\\")\\n\"");
        ShellUtil.execShellBin((String)masterBroadcast.toString());
    }

    public void kickPlayer(String userId) {
        String masterCMD = "screen -S \"DST_MASTER\" -p 0 -X stuff \"TheNet:Kick(\\\"" + userId + "\\\")\\n\"";
        String cavesCMD = "screen -S \"DST_CAVES\" -p 0 -X stuff \"TheNet:Kick(\\\"" + userId + "\\\")\\n\"";
        ShellUtil.execShellBin((String)masterCMD);
        ShellUtil.execShellBin((String)cavesCMD);
    }

    public void rollback(int dayNum) {
        String masterCMD = "screen -S \"DST_MASTER\" -p 0 -X stuff \"c_rollback(" + dayNum + ")\\n\"";
        String cavesCMD = "screen -S \"DST_CAVES\" -p 0 -X stuff \"c_rollback(" + dayNum + ")\\n\"";
        ShellUtil.execShellBin((String)masterCMD);
        ShellUtil.execShellBin((String)cavesCMD);
    }

    public void regenerate() {
        String masterCMD = "screen -S \"DST_MASTER\" -p 0 -X stuff \"c_regenerateworld()\\n\"";
        String cavesCMD = "screen -S \"DST_CAVES\" -p 0 -X stuff \"c_regenerateworld()\\n\"";
        ShellUtil.execShellBin((String)masterCMD);
        ShellUtil.execShellBin((String)cavesCMD);
    }

    public List<String> getPlayerList() throws Exception {
        String playerPrefix = "KU_";
        String host = "[Host]";
        String timeMillis = System.currentTimeMillis() + "";
        String cmd = "screen -S \"DST_MASTER\" -p 0 -X stuff \"for i, v in ipairs(TheNet:GetClientTable()) do  print(string.format(\\\"playerlist %s [%d] %s %s %s\\\", 99999999, i-1, v.userid, v.name, v.prefab )) end$(printf \\\\r)\"\n".replace("99999999", timeMillis);
        ShellUtil.runShell((String)cmd);
        TimeUnit.SECONDS.sleep(1L);
        List dstLog = this.systemService.getDstLog(DstLogTypeEnum.MASTER_LOG.type, Integer.valueOf(100));
        ArrayList<String> playList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)dstLog)) {
            dstLog.forEach(e -> {
                String tmp;
                if (e.contains(timeMillis) && e.contains(playerPrefix) && !(tmp = e.substring(e.indexOf(playerPrefix))).contains(host)) {
                    playList.add(tmp);
                }
            });
        }
        return playList;
    }

    public void masterConsole(String command) {
        String cmd = "screen -S \"DST_MASTER\" -p 0 -X stuff \"" + command + "\\n\"";
        ShellUtil.execShellBin((String)cmd);
    }

    public void cavesConsole(String command) {
        String cmd = "screen -S \"DST_CAVES\" -p 0 -X stuff \"" + command + "\\n\"";
        ShellUtil.execShellBin((String)cmd);
    }

    public ResultVO<String> playerOperate(String type, String userId) throws Exception {
        String command = "";
        switch (type) {
            case "0": {
                command = "UserToPlayer('%s'):PushEvent('respawnfromghost')";
                break;
            }
            case "1": {
                command = "UserToPlayer('%s'):PushEvent('death')";
                break;
            }
            case "2": {
                command = "c_despawn('%s')";
                List playerList = this.getPlayerList();
                log.info("\u66f4\u6362\u89d2\u8272\uff1a{}", (Object)playerList);
                if (playerList.size() <= 1) break;
                return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.OPERATE_CHANGE_PLAYER_ERROR);
            }
        }
        log.info("\u6267\u884c\u547d\u4ee4\uff1a{}", (Object)String.format(command, userId));
        this.masterConsole(String.format(command, userId));
        this.cavesConsole(String.format(command, userId));
        return ResultVO.success();
    }

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }
}

