/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.service;

import cn.hutool.core.io.FileUtil;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.enums.SettingTypeEnum;
import com.tugos.dst.admin.enums.StartTypeEnum;
import com.tugos.dst.admin.service.HomeService;
import com.tugos.dst.admin.utils.DstConfigData;
import com.tugos.dst.admin.utils.DstConstant;
import com.tugos.dst.admin.utils.FileUtils;
import com.tugos.dst.admin.utils.StrUtils;
import com.tugos.dst.admin.utils.filter.SensitiveFilter;
import com.tugos.dst.admin.vo.GameConfigVO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.ini4j.Wini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class SettingService {
    private static final Logger log = LoggerFactory.getLogger(SettingService.class);
    private HomeService homeService;
    @Value(value="${dst.filter.sensitive:true}")
    private Boolean filterFlag;
    @Value(value="${dst.max.snapshots:6}")
    private String maxSnapshots;
    @Value(value="${dst.master.port:10888}")
    private String masterPort;
    @Value(value="${dst.ground.port:10998}")
    private String groundPort;
    @Value(value="${dst.caves.port:10999}")
    private String cavesPort;

    public ResultVO<String> saveConfig(GameConfigVO vo) throws Exception {
        this.filterSensitiveWords(vo);
        FileUtil.mkdir((String)(DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer"));
        this.createMasterServerIniV2();
        this.createCavesServerIniV2();
        this.createClusterV2(vo);
        this.createToken(vo.getToken().trim());
        this.createMasterMap(vo.getMasterMapData());
        this.createCavesMap(vo.getCavesMapData());
        this.createMod(vo.getModData());
        if (SettingTypeEnum.START_GAME.type.equals(vo.getType())) {
            this.homeService.delRecord();
            this.homeService.start(StartTypeEnum.START_ALL.type);
        }
        if (SettingTypeEnum.SAVE_RESTART.type.equals(vo.getType())) {
            this.homeService.start(StartTypeEnum.START_ALL.type);
        }
        return ResultVO.success();
    }

    private boolean checkConfigIsExists() {
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer";
        File file = new File(filePath);
        return file.exists();
    }

    public GameConfigVO getConfig() throws Exception {
        GameConfigVO gameConfigVO = new GameConfigVO();
        String token = this.getToken();
        gameConfigVO.setToken(token);
        List clusterData = this.getClusterData();
        if (CollectionUtils.isNotEmpty((Collection)clusterData)) {
            for (String e : clusterData) {
                String[] split;
                if (StringUtils.isBlank((CharSequence)e)) continue;
                if (e.contains("game_mode") && StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) {
                    gameConfigVO.setGameMode(split[1].trim());
                }
                if (e.contains("max_players") && StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) {
                    gameConfigVO.setMaxPlayers(Integer.valueOf(split[1].trim()));
                }
                if (e.contains("pvp") && StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) {
                    gameConfigVO.setPvp(Boolean.valueOf(split[1].trim()));
                }
                if (e.contains("cluster_intention") && StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) {
                    gameConfigVO.setClusterIntention(split[1].trim());
                }
                if (e.contains("cluster_password") && StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) {
                    gameConfigVO.setClusterPassword(split[1].trim());
                }
                if (e.contains("cluster_description") && StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) {
                    gameConfigVO.setClusterDescription(split[1].trim());
                }
                if (!e.contains("cluster_name") || !StringUtils.isNotBlank((CharSequence)(split = e.split("="))[1])) continue;
                gameConfigVO.setClusterName(split[1].trim());
            }
        }
        String masterMapData = this.getMasterMapData();
        gameConfigVO.setMasterMapData(masterMapData);
        String cavesMapData = this.getCavesMapData();
        gameConfigVO.setCavesMapData(cavesMapData);
        String modData = this.getModData();
        gameConfigVO.setModData(modData);
        return gameConfigVO;
    }

    @Deprecated
    private boolean checkTokenIsExists() {
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster_token.txt";
        File file = new File(filePath);
        return file.exists();
    }

    public List<String> getClusterData() throws Exception {
        String tmp;
        String filePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/cluster.ini";
        ArrayList<String> configList = new ArrayList<String>();
        File file = new File(filePath);
        if (!file.exists()) {
            return configList;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        while ((tmp = br.readLine()) != null) {
            configList.add(tmp);
        }
        br.close();
        return configList;
    }

    public String getToken() throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster_token.txt";
        return FileUtils.readFile((String)filePath);
    }

    public void createMasterServerIni() throws Exception {
        String basePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "Master";
        FileUtils.mkdirs((String)basePath);
        String finalPath = basePath + "/" + "server.ini";
        log.info("\u751f\u6210\u5730\u9762 server.ini\u6587\u4ef6,{}", (Object)finalPath);
        ArrayList<String> ini = new ArrayList<String>();
        ini.add("[NETWORK]");
        String groundPort = StringUtils.isNotBlank((CharSequence)DstConfigData.groundPort) ? DstConfigData.groundPort : this.groundPort;
        ini.add("server_port = " + groundPort);
        ini.add("");
        ini.add("");
        ini.add("[SHARD]");
        ini.add("is_master = true");
        ini.add("name = Master");
        ini.add("id = 10000");
        ini.add("");
        ini.add("");
        ini.add("[ACCOUNT]");
        ini.add("encode_user_path = true");
        FileUtils.writeLineFile((String)finalPath, ini);
    }

    public void createMasterServerIniV2() throws Exception {
        Map account;
        Wini ini;
        Map network;
        String basePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "Master";
        FileUtils.mkdirs((String)basePath);
        String finalPath = basePath + "/" + "server.ini";
        log.info("\u751f\u6210\u5730\u9762 server.ini\u6587\u4ef6,{}", (Object)finalPath);
        if (!FileUtil.exist((String)finalPath)) {
            FileUtil.writeString((String)"", (File)new File(finalPath), (String)"utf-8");
        }
        if ((network = (Map)(ini = new Wini(new File(finalPath))).get((Object)"NETWORK")) == null) {
            ini.add("NETWORK", "server_port", (Object)StrUtils.ofNULL((Object)DstConfigData.groundPort, (String)this.groundPort));
        } else {
            network.put("server_port", StrUtils.ofNULL((Object)DstConfigData.groundPort, (String)this.groundPort));
        }
        Map shard = (Map)ini.get((Object)"SHARD");
        if (shard == null) {
            ini.add("SHARD", "is_master", (Object)"true");
            ini.add("SHARD", "name", (Object)"Master");
            ini.add("SHARD", "id", (Object)"10000");
        }
        if ((account = (Map)ini.get((Object)"ACCOUNT")) == null) {
            ini.add("ACCOUNT", "encode_user_path", (Object)"true");
        }
        ini.store();
    }

    public void createCavesServerIni() throws Exception {
        String basePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "Caves";
        FileUtils.mkdirs((String)basePath);
        String finalPath = basePath + "/" + "server.ini";
        log.info("\u751f\u6210\u6d1e\u7a74 server.ini\u6587\u4ef6,{}", (Object)finalPath);
        ArrayList<String> ini = new ArrayList<String>();
        ini.add("[NETWORK]");
        String cavesPort = StringUtils.isNotBlank((CharSequence)DstConfigData.cavesPort) ? DstConfigData.cavesPort : this.cavesPort;
        ini.add("server_port = " + cavesPort);
        ini.add("");
        ini.add("");
        ini.add("[SHARD]");
        ini.add("is_master = false");
        ini.add("name = Caves");
        ini.add("id = 10010");
        ini.add("");
        ini.add("");
        ini.add("[ACCOUNT]");
        ini.add("encode_user_path = true");
        ini.add("");
        ini.add("");
        ini.add("[STEAM]");
        ini.add("authentication_port = 8766");
        ini.add("master_server_port = 27016");
        FileUtils.writeLineFile((String)finalPath, ini);
    }

    public void createCavesServerIniV2() throws Exception {
        Map steam;
        Map account;
        Wini ini;
        Map network;
        String basePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "Caves";
        FileUtils.mkdirs((String)basePath);
        String finalPath = basePath + "/" + "server.ini";
        log.info("\u751f\u6210\u6d1e\u7a74 server.ini\u6587\u4ef6,{}", (Object)finalPath);
        if (!FileUtil.exist((String)finalPath)) {
            FileUtil.writeString((String)"", (File)new File(finalPath), (String)"utf-8");
        }
        if ((network = (Map)(ini = new Wini(new File(finalPath))).get((Object)"NETWORK")) == null) {
            ini.add("NETWORK", "server_port", (Object)StrUtils.ofNULL((Object)DstConfigData.cavesPort, (String)this.cavesPort));
        } else {
            network.put("server_port", StrUtils.ofNULL((Object)DstConfigData.cavesPort, (String)this.cavesPort));
        }
        Map shard = (Map)ini.get((Object)"SHARD");
        if (shard == null) {
            ini.add("SHARD", "is_master", (Object)"false");
            ini.add("SHARD", "name", (Object)"Caves");
            ini.add("SHARD", "id", (Object)"10010");
        }
        if ((account = (Map)ini.get((Object)"ACCOUNT")) == null) {
            ini.add("ACCOUNT", "encode_user_path", (Object)"true");
        }
        if ((steam = (Map)ini.get((Object)"STEAM")) == null) {
            ini.add("STEAM", "authentication_port", (Object)"8766");
            ini.add("STEAM", "master_server_port", (Object)"27016");
        }
        ini.store();
    }

    private void createToken(String token) throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster_token.txt";
        log.info("\u751f\u6210cluster_token.txt \u6587\u4ef6,{}", (Object)filePath);
        FileUtils.writeFile((String)filePath, (String)token);
    }

    private void createCluster(GameConfigVO vo) throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster.ini";
        log.info("\u751f\u6210\u6e38\u620f\u914d\u7f6e\u6587\u4ef6 cluster.ini\u6587\u4ef6,{}", (Object)filePath);
        LinkedList<String> list = new LinkedList<String>();
        list.add("[GAMEPLAY]");
        list.add("game_mode = " + vo.getGameMode());
        list.add("max_players = " + vo.getMaxPlayers());
        list.add("pvp = " + vo.getPvp());
        list.add("pause_when_empty = true");
        list.add("");
        list.add("");
        list.add("[NETWORK]");
        list.add("lan_only_cluster = false");
        String clusterPassword = vo.getClusterPassword();
        if (StringUtils.isNotBlank((CharSequence)clusterPassword)) {
            clusterPassword = clusterPassword.trim();
            list.add("cluster_password = " + clusterPassword);
        } else {
            list.add("cluster_password = ");
        }
        String clusterDescription = vo.getClusterDescription();
        if (StringUtils.isNotBlank((CharSequence)clusterDescription)) {
            clusterDescription = clusterDescription.trim();
            list.add("cluster_description = " + clusterDescription);
        } else {
            list.add("cluster_description = ");
        }
        list.add("cluster_name = " + vo.getClusterName());
        list.add("offline_cluster = false");
        Locale locale = LocaleContextHolder.getLocale();
        list.add("cluster_language = " + locale.getLanguage());
        list.add("");
        list.add("[MISC]");
        list.add("console_enabled = true");
        list.add("max_snapshots = " + this.maxSnapshots);
        list.add("");
        list.add("");
        list.add("[SHARD]");
        list.add("shard_enabled = true");
        list.add("bind_ip = 127.0.0.1");
        list.add("master_ip = 127.0.0.1");
        String masterPort = StringUtils.isNotBlank((CharSequence)DstConfigData.masterPort) ? DstConfigData.masterPort : this.masterPort;
        list.add("master_port = " + masterPort);
        list.add("cluster_key = defaultPass");
        StringBuffer sb = new StringBuffer();
        list.forEach(e -> sb.append((String)e).append("\n"));
        FileUtils.writeFile((String)filePath, (String)sb.toString());
    }

    public void createClusterV2(GameConfigVO vo) throws Exception {
        Wini ini;
        Map gameplay;
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster.ini";
        log.info("\u751f\u6210\u6e38\u620f\u914d\u7f6e\u6587\u4ef6 cluster.ini\u6587\u4ef6,{}", (Object)filePath);
        if (!FileUtil.exist((String)filePath)) {
            FileUtil.writeString((String)"", (File)new File(filePath), (String)"utf-8");
        }
        if ((gameplay = (Map)(ini = new Wini(new File(filePath))).get((Object)"GAMEPLAY")) == null) {
            ini.add("GAMEPLAY", "game_mode", (Object)StrUtils.ofNULL((Object)vo.getGameMode()));
            ini.add("GAMEPLAY", "max_players", (Object)StrUtils.ofNULL((Object)vo.getMaxPlayers(), (String)"6"));
            ini.add("GAMEPLAY", "pvp", (Object)StrUtils.ofNULL((Object)vo.getPvp(), (String)"false"));
            ini.add("GAMEPLAY", "pause_when_empty", (Object)"true");
        } else {
            gameplay.put("game_mode", StrUtils.ofNULL((Object)vo.getGameMode()));
            gameplay.put("max_players", StrUtils.ofNULL((Object)vo.getMaxPlayers(), (String)"6"));
            gameplay.put("pvp", StrUtils.ofNULL((Object)vo.getPvp(), (String)"false"));
        }
        Map network = (Map)ini.get((Object)"NETWORK");
        if (network == null) {
            ini.add("NETWORK", "lan_only_cluster", (Object)"false");
            ini.add("NETWORK", "cluster_password", (Object)StrUtils.ofNULL((Object)vo.getClusterPassword()).trim());
            ini.add("NETWORK", "cluster_description", (Object)StrUtils.ofNULL((Object)vo.getClusterDescription()));
            ini.add("NETWORK", "cluster_name", (Object)StrUtils.ofNULL((Object)vo.getClusterName()));
            ini.add("NETWORK", "offline_cluster", (Object)"false");
            ini.add("NETWORK", "cluster_language", (Object)LocaleContextHolder.getLocale().getLanguage());
        } else {
            network.put("cluster_password", StrUtils.ofNULL((Object)vo.getClusterPassword()).trim());
            network.put("cluster_description", StrUtils.ofNULL((Object)vo.getClusterDescription()));
            network.put("cluster_name", StrUtils.ofNULL((Object)vo.getClusterName()));
            network.put("cluster_language", LocaleContextHolder.getLocale().getLanguage());
        }
        Map misc = (Map)ini.get((Object)"MISC");
        if (misc == null) {
            ini.add("MISC", "console_enabled", (Object)"true");
            ini.add("MISC", "max_snapshots", (Object)this.maxSnapshots);
        } else {
            misc.put("max_snapshots", this.maxSnapshots);
        }
        Map shard = (Map)ini.get((Object)"SHARD");
        if (shard == null) {
            ini.add("SHARD", "shard_enabled", (Object)"true");
            ini.add("SHARD", "bind_ip", (Object)"127.0.0.1");
            ini.add("SHARD", "master_ip", (Object)"127.0.0.1");
            ini.add("SHARD", "master_port", (Object)StrUtils.ofNULL((Object)DstConfigData.masterPort, (String)this.masterPort));
            ini.add("SHARD", "cluster_key", (Object)"defaultPass");
        } else {
            shard.put("master_port", StrUtils.ofNULL((Object)DstConfigData.masterPort, (String)this.masterPort));
        }
        ini.store();
    }

    private GameConfigVO filterSensitiveWords(GameConfigVO vo) {
        if (!this.filterFlag.booleanValue()) {
            return vo;
        }
        try {
            String filter;
            SensitiveFilter sensitiveFilter = SensitiveFilter.DEFAULT;
            if (StringUtils.isNotBlank((CharSequence)vo.getClusterName())) {
                filter = sensitiveFilter.filter(vo.getClusterName(), '*');
                vo.setClusterName(filter);
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getClusterDescription())) {
                filter = sensitiveFilter.filter(vo.getClusterDescription(), '*');
                vo.setClusterDescription(filter);
            }
        }
        catch (Exception e) {
            log.error("\u8fc7\u6ee4\u654f\u611f\u8bcd\u9519\u8bef\uff1a", (Throwable)e);
            vo.setClusterName("\u9965\u8352\u4e16\u754c");
            vo.setClusterDescription("");
        }
        return vo;
    }

    public String getModData() throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/modoverrides.lua";
        return FileUtils.readFile((String)filePath);
    }

    public String getMasterMapData() throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/leveldataoverride.lua";
        return FileUtils.readFile((String)filePath);
    }

    public String getCavesMapData() throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Caves/leveldataoverride.lua";
        return FileUtils.readFile((String)filePath);
    }

    public void createMod(String data) throws Exception {
        String masterModeFile = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/modoverrides.lua";
        String cavesModeFile = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Caves/modoverrides.lua";
        if (StringUtils.isNotBlank((CharSequence)data)) {
            FileUtils.writeFile((String)masterModeFile, (String)data);
            FileUtils.writeFile((String)cavesModeFile, (String)data);
        } else {
            FileUtils.writeFile((String)masterModeFile, (String)"");
            FileUtils.writeFile((String)cavesModeFile, (String)"");
        }
    }

    public void createMasterMap(String data) throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/leveldataoverride.lua";
        if (StringUtils.isNotBlank((CharSequence)data)) {
            FileUtils.writeFile((String)filePath, (String)data);
        } else {
            FileUtils.writeFile((String)filePath, (String)"");
        }
    }

    public void createCavesMap(String data) throws Exception {
        String filePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Caves/leveldataoverride.lua";
        if (StringUtils.isNotBlank((CharSequence)data)) {
            FileUtils.writeFile((String)filePath, (String)data);
        } else {
            FileUtils.writeFile((String)filePath, (String)"");
        }
    }

    @Autowired
    public void setHomeService(HomeService homeService) {
        this.homeService = homeService;
    }
}

