/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.config.I18nResourcesConfig;
import com.tugos.dst.admin.entity.Server;
import com.tugos.dst.admin.enums.StartTypeEnum;
import com.tugos.dst.admin.enums.StopTypeEnum;
import com.tugos.dst.admin.service.BackupService;
import com.tugos.dst.admin.service.HomeService;
import com.tugos.dst.admin.service.SettingService;
import com.tugos.dst.admin.service.ShellService;
import com.tugos.dst.admin.utils.DstConstant;
import com.tugos.dst.admin.utils.ModFileUtil;
import com.tugos.dst.admin.vo.DstServerInfoVO;
import com.tugos.dst.admin.vo.GameArchiveVO;
import com.tugos.dst.admin.vo.GameConfigVO;
import com.tugos.dst.admin.vo.GameSnapshotVO;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomeService {
    private static final Logger log = LoggerFactory.getLogger(HomeService.class);
    private ShellService shellService;
    private BackupService backupService;
    private SettingService settingService;

    public ResultVO<String> start(Integer type) {
        if (!this.checkIsInstallDst()) {
            return ResultVO.fail((String)I18nResourcesConfig.getMessage((String)"tip.home.start.error"));
        }
        StartTypeEnum typeEnum = StartTypeEnum.get((Integer)type);
        Objects.requireNonNull(typeEnum);
        switch (1.$SwitchMap$com$tugos$dst$admin$enums$StartTypeEnum[typeEnum.ordinal()]) {
            case 1: {
                this.shellService.stopMaster();
                this.shellService.stopCaves();
                this.shellService.startMaster();
                this.shellService.startCaves();
                break;
            }
            case 2: {
                this.shellService.stopMaster();
                this.shellService.startMaster();
                break;
            }
            case 3: {
                this.shellService.stopCaves();
                this.shellService.startCaves();
                break;
            }
        }
        this.shellService.clearScreen();
        return ResultVO.success();
    }

    public void stopServer() {
        this.shellService.stopMaster();
        this.shellService.stopCaves();
    }

    public ResultVO<String> stop(Integer type) {
        StopTypeEnum typeEnum = StopTypeEnum.get((Integer)type);
        Objects.requireNonNull(typeEnum);
        switch (1.$SwitchMap$com$tugos$dst$admin$enums$StopTypeEnum[typeEnum.ordinal()]) {
            case 1: {
                this.shellService.elegantShutdownMaster();
                this.shellService.elegantShutdownCaves();
                break;
            }
            case 2: {
                this.shellService.elegantShutdownMaster();
                break;
            }
            case 3: {
                this.shellService.elegantShutdownCaves();
                break;
            }
        }
        return ResultVO.success();
    }

    private boolean checkIsInstallDst() {
        String startProgram = DstConstant.ROOT_PATH + "/" + "/dst/bin" + "/" + "dontstarve_dedicated_server_nullrenderer";
        File masterFile = new File(startProgram);
        if (masterFile.exists()) {
            return true;
        }
        log.warn("\u672a\u627e\u5230\u542f\u52a8\u7a0b\u5e8f\uff1a{}", (Object)startProgram);
        return false;
    }

    private boolean checkTokenIsExists() {
        String tokenPath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster_token.txt";
        File file = new File(tokenPath);
        return file.exists();
    }

    public DstServerInfoVO getSystemInfo() throws Exception {
        DstServerInfoVO data = new DstServerInfoVO();
        Server server = new Server();
        server.copyTo();
        data.setCpu(server.getCpu());
        data.setMem(server.getMem());
        data.setMasterStatus(Boolean.valueOf(this.shellService.getMasterStatus()));
        data.setCavesStatus(Boolean.valueOf(this.shellService.getCavesStatus()));
        ArrayList backupList = new ArrayList();
        List list = this.backupService.getBackupFileInfo();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> backupList.add(e.getFileName()));
        }
        data.setBackupList(backupList);
        return data;
    }

    public ResultVO<String> updateGame() {
        if (!this.checkIsInstallDst()) {
            return ResultVO.fail((String)I18nResourcesConfig.getMessage((String)"tip.home.start.error"));
        }
        this.shellService.updateGame();
        return ResultVO.success();
    }

    @Deprecated
    public ResultVO<String> backup(String name) {
        String fileName;
        if (!this.checkGameFileIsExists()) {
            return ResultVO.fail((String)I18nResourcesConfig.getMessage((String)"tip.home.backup.error"));
        }
        String weekStr = DateUtil.thisDayOfWeekEnum().toString();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            fileName = name + ".tar";
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String format = sdf.format(new Date());
            format = format + weekStr;
            fileName = format + ".tar";
        }
        this.shellService.createBackup(fileName);
        return ResultVO.success();
    }

    private boolean checkGameFileIsExists() {
        String path = DstConstant.ROOT_PATH + "/" + "/.klei/DoNotStarveTogether/MyDediServer";
        File file = new File(path);
        return file.exists();
    }

    @Deprecated
    public ResultVO<String> restore(String name) {
        if (!this.checkBackupIsExists(name)) {
            return ResultVO.fail((String)(I18nResourcesConfig.getMessage((String)"tip.home.backup.error2") + name));
        }
        this.delRecord();
        this.shellService.revertBackup(name);
        return ResultVO.success();
    }

    private boolean checkBackupIsExists(String name) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            String path = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether";
            File file = new File(path);
            flag = file.exists();
        }
        return flag;
    }

    public void delRecord() {
        this.shellService.delCavesRecord();
        this.shellService.delMasterRecord();
    }

    public void delMyDediServer() {
        this.stopServer();
        String path = DstConstant.ROOT_PATH + "/" + "/.klei/DoNotStarveTogether/MyDediServer";
        log.warn("\u5220\u9664MyDediServer\u76ee\u5f55:{}", (Object)path);
        FileUtil.del((String)path);
    }

    public void onlyDelSave() {
        this.shellService.delCavesRecord();
    }

    public GameArchiveVO getGameArchive() throws Exception {
        GameArchiveVO gameArchiveVO = new GameArchiveVO();
        GameConfigVO config = this.settingService.getConfig();
        if (config != null) {
            gameArchiveVO.setModContent(config.getModData());
            BeanUtils.copyProperties((Object)config, (Object)gameArchiveVO);
            List modNoList = ModFileUtil.findModNo((String)config.getModData());
            gameArchiveVO.setTotalModNum(Integer.valueOf(modNoList.size()));
            gameArchiveVO.setModNos(modNoList);
        }
        gameArchiveVO.setMaxPlayers(gameArchiveVO.getMaxPlayers());
        GameSnapshotVO gameSnapshot = this.backupService.getGameSnapshot();
        if (gameSnapshot != null) {
            gameArchiveVO.setPlayDay(gameSnapshot.getPlayDay());
            gameArchiveVO.setSeason(gameSnapshot.getSeasonChinese());
        } else {
            gameArchiveVO.setPlayDay(I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.season"));
            gameArchiveVO.setSeason(I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.playDay"));
        }
        return gameArchiveVO;
    }

    @Autowired
    public void setShellService(ShellService shellService) {
        this.shellService = shellService;
    }

    @Autowired
    public void setBackupService(BackupService backupService) {
        this.backupService = backupService;
    }

    @Autowired
    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }
}

