/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.service;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.format.DateParser;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.ZipUtil;
import com.tugos.dst.admin.common.ResultCodeEnum;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.config.I18nResourcesConfig;
import com.tugos.dst.admin.exception.ResultException;
import com.tugos.dst.admin.service.ShellService;
import com.tugos.dst.admin.utils.DstConstant;
import com.tugos.dst.admin.utils.FileUtils;
import com.tugos.dst.admin.vo.BackupFileVO;
import com.tugos.dst.admin.vo.GameSnapshotVO;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class BackupService {
    private static final Logger log = LoggerFactory.getLogger(BackupService.class);
    @Value(value="${dst.max.backup.size:4096}")
    private Integer maxBackupSize;
    private ShellService shellService;

    public List<BackupFileVO> getBackupFileInfo() {
        ArrayList<BackupFileVO> result = new ArrayList<BackupFileVO>();
        String backupPath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether";
        List allFileList = FileUtils.getFiles((String)backupPath);
        ArrayList backupFileList = new ArrayList();
        allFileList.forEach(e -> {
            String extName = FileUtil.extName((String)e);
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)"zip", (CharSequence[])new CharSequence[]{extName}) || StringUtils.equalsAnyIgnoreCase((CharSequence)"tar", (CharSequence[])new CharSequence[]{extName})) {
                backupFileList.add(e);
            }
        });
        if (CollectionUtils.isNotEmpty(backupFileList)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (String e2 : backupFileList) {
                BackupFileVO vo = new BackupFileVO();
                File file = new File(e2);
                String name = file.getName();
                long lastModified = file.lastModified();
                String time = sdf.format(lastModified);
                vo.setCreateTime(time);
                vo.setFileSize(Long.valueOf(file.length()));
                vo.setFileName(name);
                vo.setTime((Date)DateUtil.parse((CharSequence)vo.getCreateTime(), (DateParser)DatePattern.NORM_DATETIME_FORMAT));
                result.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty(result)) {
            result.sort((o1, o2) -> DateUtil.compare((Date)o1.getTime(), (Date)o2.getTime()));
            Collections.reverse(result);
        }
        return result;
    }

    public boolean deleteBackup(String fileName) {
        String basePath;
        String filePath;
        File file;
        if (StringUtils.isNotBlank((CharSequence)fileName) && (file = new File(filePath = (basePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether") + "/" + fileName)).exists()) {
            return file.delete();
        }
        return false;
    }

    public ResultVO<String> restore(String name) {
        if (!this.checkBackupIsExists(name)) {
            return ResultVO.fail((String)(I18nResourcesConfig.getMessage((String)"tip.home.backup.error2") + name));
        }
        this.delMyDediServer();
        String extName = FileUtil.extName((String)name);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)"zip", (CharSequence[])new CharSequence[]{extName})) {
            this.revertZIPBackup(name);
        } else {
            this.delMyDediServer();
            this.shellService.revertBackup(name);
        }
        return ResultVO.success();
    }

    public void delMyDediServer() {
        String path = DstConstant.ROOT_PATH + "/" + "/.klei/DoNotStarveTogether/MyDediServer";
        log.warn("\u5220\u9664MyDediServer\u76ee\u5f55:{}", (Object)path);
        FileUtil.del((String)path);
    }

    private boolean checkBackupIsExists(String name) {
        boolean flag = false;
        if (StringUtils.isNotBlank((CharSequence)name)) {
            String path = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether";
            File file = new File(path);
            flag = file.exists();
        }
        return flag;
    }

    public ResultVO<String> rename(String fileName, String newFileName) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fileName, newFileName})) {
            newFileName = this.fileNameFilter(newFileName);
            String basePath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether";
            String filePath = basePath + "/" + fileName;
            String suffix = "." + FileUtil.extName((String)filePath);
            String newFilePath = basePath + "/" + newFileName + suffix;
            File newFile = new File(newFilePath);
            if (newFile.exists()) {
                return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.BACKUP_RENAME_SAME);
            }
            File file = new File(filePath);
            if (file.exists()) {
                boolean renameTo = file.renameTo(newFile);
                if (renameTo) {
                    return ResultVO.success();
                }
                return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.BACKUP_RENAME_ERROR);
            }
        }
        return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.BACKUP_RENAME_ERROR);
    }

    public ResultVO<String> backup(String name) {
        String fileName;
        long sum;
        double total;
        if (!this.checkGameFileIsExists()) {
            return ResultVO.fail((String)I18nResourcesConfig.getMessage((String)"tip.home.backup.error"));
        }
        List backupList = this.getBackupFileInfo();
        if (CollectionUtils.isNotEmpty((Collection)backupList) && (total = (double)(sum = backupList.stream().mapToLong(BackupFileVO::getFileSize).sum()) / 1024.0 / 1024.0) > (double)this.maxBackupSize.intValue()) {
            throw new ResultException(ResultCodeEnum.BACKUP_MAX_SIZE_ERROR);
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            fileName = name + ".zip";
        } else {
            BackupService backupService;
            GameSnapshotVO gameSnapshot;
            List list;
            String serverName = I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.room");
            String playDate = I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.playDay");
            String season = I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.season");
            String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "cluster.ini";
            File file = new File(filePath);
            if (file.exists() && CollectionUtils.isNotEmpty((Collection)(list = FileUtil.readLines((String)filePath, (Charset)StandardCharsets.UTF_8)))) {
                for (String s : list) {
                    String[] split;
                    if (!s.contains("cluster_name") || !StringUtils.isNotBlank((CharSequence)(split = s.split("="))[1])) continue;
                    serverName = split[1].trim();
                }
            }
            if ((gameSnapshot = (backupService = new BackupService()).getGameSnapshot()) != null) {
                playDate = gameSnapshot.getPlayDay() + I18nResourcesConfig.getMessage((String)"tip.game.Archive.days");
                season = gameSnapshot.getSeasonChinese();
            }
            fileName = String.format("%s_%s_%s_%s.zip", DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss"), serverName, playDate, season);
        }
        this.createBackup(fileName);
        return ResultVO.success();
    }

    private boolean checkGameFileIsExists() {
        String path = DstConstant.ROOT_PATH + "/" + "/.klei/DoNotStarveTogether/MyDediServer";
        File file = new File(path);
        return file.exists();
    }

    public void createBackup(String fileName) {
        fileName = this.fileNameFilter(fileName);
        String basePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/";
        String scrPath = basePath + "MyDediServer";
        ZipUtil.zip((String)scrPath, (String)(basePath + fileName), (boolean)true);
    }

    public String fileNameFilter(String fileName) {
        fileName = StringUtils.deleteWhitespace((String)fileName);
        fileName = RegExUtils.replaceAll((String)fileName, (String)"[/\\\\:*?|]", (String)"");
        fileName = RegExUtils.replaceAll((String)fileName, (String)"[\"<>]", (String)"");
        fileName = RegExUtils.replaceAll((String)fileName, (String)"[^\\u0000-\\uFFFF]", (String)"");
        return fileName;
    }

    public GameSnapshotVO getGameSnapshot() {
        GameSnapshotVO gameSnapshotVO = null;
        try {
            String snapshot = BackupService.getSnapshot();
            log.info("\u5feb\u7167\u4fe1\u606f\uff1a{}", (Object)snapshot);
            if (StringUtils.isNotBlank((CharSequence)snapshot)) {
                gameSnapshotVO = BackupService.parseSnapshot((String)snapshot);
            }
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790\u5feb\u7167\u5931\u8d25\uff1a", (Throwable)e);
        }
        return gameSnapshotVO;
    }

    private static String getSnapshot() {
        File startFile;
        File[] files;
        String filePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/MyDediServer" + "/" + "Master/save/session";
        File sessionFile = new File(filePath);
        ArrayList<File> targetFileList = new ArrayList<File>();
        if (sessionFile.exists() && (files = sessionFile.listFiles()) != null && files.length > 0) {
            for (File targetFile : files) {
                if (targetFile.isHidden() || !targetFile.isDirectory()) continue;
                targetFileList.add(targetFile);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(targetFileList)) {
            startFile = (File)targetFileList.get(0);
            for (File file : targetFileList) {
                if (FileUtil.size((File)startFile) >= FileUtil.size((File)file)) continue;
                startFile = file;
            }
        } else {
            return null;
        }
        File[] snapshotFiles = startFile.listFiles();
        if (snapshotFiles != null && snapshotFiles.length > 0) {
            for (File snapshotFile : snapshotFiles) {
                String extName = FileUtil.extName((File)snapshotFile);
                if (!"meta".equalsIgnoreCase(extName)) continue;
                result.add(snapshotFile.getAbsolutePath());
            }
        }
        result.sort(BackupService::compare);
        Collections.reverse(result);
        if (result.size() > 0) {
            String targetPath = (String)result.get(0);
            return FileUtil.readString((String)targetPath, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    private static GameSnapshotVO parseSnapshot(String content) {
        String[] split;
        GameSnapshotVO gameSnapshotVO = new GameSnapshotVO();
        gameSnapshotVO.setOriginal(content);
        content = content.replace("\"", "");
        content = content.replace("[", "");
        content = content.replace("]", "");
        gameSnapshotVO.setPlayDay(I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.playDay"));
        gameSnapshotVO.setSeason(I18nResourcesConfig.getMessage((String)"tip.game.Archive.unknown.season"));
        ArrayList cyclesList = (ArrayList)ReUtil.findAll((String)"cycles=[1-9]\\d*", (CharSequence)content, (int)0, new ArrayList());
        ArrayList seasonList = (ArrayList)ReUtil.findAll((String)"season=\\w*", (CharSequence)content, (int)0, new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)cyclesList) && (split = ((String)cyclesList.get(0)).split("=")).length > 0) {
            gameSnapshotVO.setPlayDay(split[1]);
        }
        if (CollectionUtils.isNotEmpty((Collection)seasonList) && (split = ((String)seasonList.get(0)).split("=")).length > 0) {
            gameSnapshotVO.setSeason(split[1].replace("\"", ""));
        }
        return gameSnapshotVO;
    }

    public static int compare(String path1, String path2) {
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        if (path1.equals(path2)) {
            return 0;
        }
        File file1 = new File(path1);
        File file2 = new File(path2);
        long lastModified1 = file1.lastModified();
        long lastModified2 = file2.lastModified();
        return (int)(lastModified1 - lastModified2);
    }

    public void revertZIPBackup(String fileName) {
        String basePath = DstConstant.ROOT_PATH + "/.klei/DoNotStarveTogether/";
        String outFileDir = basePath + "MyDediServer";
        FileUtil.del((String)outFileDir);
        FileUtil.mkdir((String)outFileDir);
        String zipPath = basePath + fileName;
        String tmpPath = basePath + "tmp";
        File file = null;
        boolean unzipFail = false;
        try {
            file = ZipUtil.unzip((String)zipPath, (String)tmpPath);
        }
        catch (Exception e) {
            unzipFail = true;
            log.error("\u89e3\u538b\u5b58\u6863\u6587\u4ef6\u5931\u8d25,\u9ed8\u8ba4\u6a21\u5f0f\uff1a" + fileName, (Throwable)e);
        }
        if (unzipFail) {
            try {
                file = ZipUtil.unzip((String)zipPath, (String)tmpPath, (Charset)CharsetUtil.CHARSET_GBK);
            }
            catch (Exception e) {
                log.error("\u89e3\u538b\u5b58\u6863\u6587\u4ef6\u5931\u8d25,GBK\u6a21\u5f0f\uff1a" + fileName, (Throwable)e);
                throw new ResultException(ResultCodeEnum.BACKUP_UNZIP_ERROR);
            }
        }
        String resultPath = FileUtils.findMasterPath((File)file);
        log.info("\u89e3\u538b\u65f6\u627e\u5230Master\u76ee\u5f55\uff1a" + resultPath);
        if (StringUtils.isBlank((CharSequence)resultPath)) {
            log.warn("\u5b58\u6863\u6587\u4ef6\u6709\u95ee\u9898\uff1a" + fileName);
            throw new ResultException(ResultCodeEnum.BACKUP_CONTENT_ERROR);
        }
        try {
            HashSet<String> list = new HashSet<String>();
            list.add("Master");
            list.add("Caves");
            list.add("cluster.ini");
            list.add("cluster_token.txt");
            list.add("blacklist.txt");
            list.add("adminlist.txt");
            for (String target : list) {
                String scrPath = resultPath + "/" + target;
                File tmpFile = new File(scrPath);
                if (!tmpFile.exists()) continue;
                FileUtil.copy((String)scrPath, (String)outFileDir, (boolean)true);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u538b\u5b58\u6863\u6587\u4ef6\u65f6\u590d\u5236\u5b58\u6863\u5931\u8d25\uff1a" + fileName);
            throw new ResultException(ResultCodeEnum.BACKUP_COPY_ERROR);
        }
        finally {
            FileUtil.del((String)tmpPath);
        }
    }

    public void download(String fileName, HttpServletResponse response) throws Exception {
        String extName = FileUtil.extName((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)fileName) && !fileName.contains("../") && StringUtils.equalsAnyIgnoreCase((CharSequence)extName, (CharSequence[])new CharSequence[]{"tar", "zip"})) {
            String filepath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether";
            File file = new File(filepath = filepath + "/" + fileName);
            if (file.exists()) {
                response.setHeader("content-type", "application/octet-stream");
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
                byte[] buffer = new byte[1024];
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);
                     ServletOutputStream os = response.getOutputStream();){
                    int i = bis.read(buffer);
                    while (i != -1) {
                        os.write(buffer, 0, i);
                        i = bis.read(buffer);
                    }
                    os.flush();
                }
                catch (Exception e) {
                    log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
                }
                return;
            }
        }
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u6587\u4ef6\u4e0d\u5b58\u5728.txt", "UTF-8"));
        response.getOutputStream().flush();
    }

    public ResultVO<String> upload(MultipartFile file) throws Exception {
        String filepath = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether" + "/" + file.getOriginalFilename();
        File dest = new File(filepath);
        if (dest.exists()) {
            return ResultVO.fail((String)I18nResourcesConfig.getMessage((String)"tip.backup.file.exist"));
        }
        file.transferTo(dest);
        return ResultVO.success();
    }

    @Autowired
    public void setShellService(ShellService shellService) {
        this.shellService = shellService;
    }
}

